/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidmodelloader;

import dev.architectury.platform.Platform;
import dev.architectury.registry.level.entity.EntityAttributeRegistry;
import java.nio.file.Paths;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.sistr.littlemaidmodelloader.client.resource.loader.LMSoundLoader;
import net.sistr.littlemaidmodelloader.client.resource.loader.LMTextureLoader;
import net.sistr.littlemaidmodelloader.client.resource.manager.LMSoundManager;
import net.sistr.littlemaidmodelloader.entity.MultiModelEntity;
import net.sistr.littlemaidmodelloader.entity.compound.IHasMultiModel;
import net.sistr.littlemaidmodelloader.maidmodel.ModelLittleMaid_Archetype;
import net.sistr.littlemaidmodelloader.maidmodel.ModelLittleMaid_Aug;
import net.sistr.littlemaidmodelloader.maidmodel.ModelLittleMaid_Beverly7;
import net.sistr.littlemaidmodelloader.maidmodel.ModelLittleMaid_Chloe2;
import net.sistr.littlemaidmodelloader.maidmodel.ModelLittleMaid_Elsa5;
import net.sistr.littlemaidmodelloader.maidmodel.ModelLittleMaid_Orign;
import net.sistr.littlemaidmodelloader.maidmodel.ModelLittleMaid_SR2;
import net.sistr.littlemaidmodelloader.maidmodel.ModelMulti_Stef;
import net.sistr.littlemaidmodelloader.maidmodel.ModelMulti_Steve;
import net.sistr.littlemaidmodelloader.resource.classloader.MultiModelClassLoader;
import net.sistr.littlemaidmodelloader.resource.loader.LMConfigLoader;
import net.sistr.littlemaidmodelloader.resource.loader.LMFileLoader;
import net.sistr.littlemaidmodelloader.resource.loader.LMMultiModelLoader;
import net.sistr.littlemaidmodelloader.resource.manager.LMConfigManager;
import net.sistr.littlemaidmodelloader.resource.manager.LMModelManager;
import net.sistr.littlemaidmodelloader.resource.manager.LMTextureManager;
import net.sistr.littlemaidmodelloader.setup.Registration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LittleMaidModelLoader {
    public static final String MODID = "littlemaidmodelloader";
    public static final Logger LOGGER = LogManager.getLogger();

    public static void init() {
        LittleMaidModelLoader.initFileLoader();
        LittleMaidModelLoader.initModelLoader();
        if (Platform.getEnv() == Dist.CLIENT) {
            LittleMaidModelLoader.initTextureLoader();
            LittleMaidModelLoader.initSoundLoader();
        }
        Registration.init();
        LittleMaidModelLoader.registerAttribute();
    }

    public static void initFileLoader() {
        LMFileLoader fileLoader = LMFileLoader.INSTANCE;
        fileLoader.addLoadFolderPath(Paths.get(Platform.getGameFolder().toString(), "LMMLResources"));
        fileLoader.addLoader(new LMMultiModelLoader(LMModelManager.INSTANCE, new MultiModelClassLoader(fileLoader.getFolderPaths())));
        fileLoader.addLoader(new LMConfigLoader(LMConfigManager.INSTANCE));
    }

    public static void initModelLoader() {
        LMModelManager modelManager = LMModelManager.INSTANCE;
        modelManager.addModel("Default", ModelLittleMaid_Orign.class);
        modelManager.addModel("SR2", ModelLittleMaid_SR2.class);
        modelManager.addModel("Aug", ModelLittleMaid_Aug.class);
        modelManager.addModel("Archetype", ModelLittleMaid_Archetype.class);
        modelManager.addModel("Steve", ModelMulti_Steve.class);
        modelManager.addModel("Stef", ModelMulti_Stef.class);
        modelManager.addModel("Beverly7", ModelLittleMaid_Beverly7.class);
        modelManager.addModel("Chloe2", ModelLittleMaid_Chloe2.class);
        modelManager.addModel("Elsa5", ModelLittleMaid_Elsa5.class);
        modelManager.setDefaultModel(modelManager.getModel("Default", IHasMultiModel.Layer.SKIN).orElseThrow(RuntimeException::new));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void initTextureLoader() {
        LMFileLoader fileLoader = LMFileLoader.INSTANCE;
        LMTextureLoader textureProcessor = new LMTextureLoader(LMTextureManager.INSTANCE);
        textureProcessor.addPathConverter("assets/", "");
        textureProcessor.addPathConverter("mob/", "minecraft/textures/entity/");
        fileLoader.addLoader(textureProcessor);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void initSoundLoader() {
        LMFileLoader.INSTANCE.addLoader(new LMSoundLoader(LMSoundManager.INSTANCE));
    }

    public static void registerAttribute() {
        EntityAttributeRegistry.register(() -> Registration.MULTI_MODEL_ENTITY.get(), MultiModelEntity::createMobAttributes);
        EntityAttributeRegistry.register(() -> Registration.DUMMY_MODEL_ENTITY.get(), MultiModelEntity::createMobAttributes);
    }
}

