/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidmodelloader.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.sistr.littlemaidmodelloader.client.renderer.MultiModel;
import net.sistr.littlemaidmodelloader.entity.compound.IHasMultiModel;
import net.sistr.littlemaidmodelloader.maidmodel.IModelCaps;
import net.sistr.littlemaidmodelloader.multimodel.layer.MMRenderContext;

@OnlyIn(value=Dist.CLIENT)
public class MultiModelLightLayer<T extends LivingEntity>
extends RenderLayer<T, MultiModel<T>> {
    public MultiModelLightLayer(RenderLayerParent<T, MultiModel<T>> context) {
        super(context);
    }

    public void render(PoseStack matrices, MultiBufferSource vertexConsumers, int light, T entity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
        ProfilerFiller profiler = Minecraft.m_91087_().m_91307_();
        profiler.m_6180_("littlemaidmodelloader:mm_eye_layer");
        this.renderLightLayer(matrices, vertexConsumers, entity, limbAngle, limbDistance, tickDelta, animationProgress, headYaw, headPitch, ((IHasMultiModel)entity).getCaps());
        profiler.m_7238_();
    }

    private void renderLightLayer(PoseStack matrices, MultiBufferSource vertexConsumers, T entity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch, IModelCaps caps) {
        ((IHasMultiModel)entity).getTexture(IHasMultiModel.Layer.SKIN, IHasMultiModel.Part.HEAD, true).ifPresent(resourceLocation -> ((IHasMultiModel)entity).getModel(IHasMultiModel.Layer.SKIN, IHasMultiModel.Part.HEAD).ifPresent(model -> {
            VertexConsumer builder = vertexConsumers.m_6299_(RenderType.m_110473_((ResourceLocation)resourceLocation));
            model.animateModel(caps, limbAngle, limbDistance, tickDelta);
            model.setAngles(caps, limbAngle, limbDistance, animationProgress, headYaw, headPitch);
            model.render(new MMRenderContext(matrices, builder, 0xF00000, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f));
        }));
    }
}

