/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidmodelloader.client.resource;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ResourceWrapper
implements PackResources {
    public static final ResourceWrapper INSTANCE = new ResourceWrapper();
    public static final PackMetadataSection PACK_INFO = new PackMetadataSection((Component)new TextComponent("LittleMaidModelLoader!!!"), 6);
    protected static final HashMap<ResourceLocation, Resource> PATHS = Maps.newHashMap();

    public InputStream m_5542_(String fileName) {
        return null;
    }

    public InputStream m_8031_(PackType type, ResourceLocation id) throws IOException {
        Resource resource = PATHS.get(id);
        if (resource == null) {
            throw new FileNotFoundException(id.toString());
        }
        return resource.getInputStream();
    }

    public Collection<ResourceLocation> m_7466_(PackType type, String namespace, String prefix, int maxDepth, Predicate<String> pathFilter) {
        return PATHS.keySet().stream().filter(location -> location.m_135815_().startsWith(namespace)).filter(location -> pathFilter.test(location.m_135815_())).collect(Collectors.toList());
    }

    public boolean m_7211_(PackType type, ResourceLocation id) {
        return PATHS.containsKey(id);
    }

    public Set<String> m_5698_(PackType type) {
        return Sets.newHashSet((Object[])new String[]{"littlemaidmodelloader"});
    }

    public <T> T m_5550_(MetadataSectionSerializer<T> metaReader) {
        if (metaReader.m_7991_().equals("pack")) {
            return (T)PACK_INFO;
        }
        return null;
    }

    public String m_8017_() {
        return "LMModelLoader";
    }

    public void close() {
    }

    public static void addResourcePath(ResourceLocation resourcePath, String path, Path homePath, boolean isArchive) {
        PATHS.put(resourcePath, new Resource(path, homePath, isArchive));
    }

    private static class Resource {
        private final String path;
        private final Path homePath;
        private final boolean isArchive;

        private Resource(String path, Path homePath, boolean isArchive) {
            this.path = path;
            this.homePath = homePath;
            this.isArchive = isArchive;
        }

        public InputStream getInputStream() throws IOException {
            if (this.isArchive) {
                String resourcePath = this.homePath.toString();
                ZipFile zipfile = new ZipFile(resourcePath);
                ZipEntry zipentry = zipfile.getEntry(this.path);
                if (zipentry != null) {
                    return zipfile.getInputStream(zipentry);
                }
                throw new NoSuchFileException(this.path);
            }
            return Files.newInputStream(Paths.get(this.homePath.toString(), this.path), new OpenOption[0]);
        }
    }
}

