/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidmodelloader.client.resource.loader;

import java.io.InputStream;
import java.nio.file.Path;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.sistr.littlemaidmodelloader.client.resource.ResourceWrapper;
import net.sistr.littlemaidmodelloader.client.resource.manager.LMSoundManager;
import net.sistr.littlemaidmodelloader.config.LMMLConfig;
import net.sistr.littlemaidmodelloader.resource.loader.LMLoader;
import net.sistr.littlemaidmodelloader.resource.util.ResourceHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class LMSoundLoader
implements LMLoader {
    private static final Logger LOGGER = LogManager.getLogger();
    private final LMSoundManager soundManager;

    public LMSoundLoader(LMSoundManager soundManager) {
        this.soundManager = soundManager;
    }

    @Override
    public boolean canLoad(String path, Path homePath, InputStream inputStream, boolean isArchive) {
        return path.endsWith(".ogg") && ResourceHelper.getParentFolderName(path, isArchive).isPresent();
    }

    @Override
    public void load(String path, Path homePath, InputStream inputStream, boolean isArchive) {
        String packName = ResourceHelper.getParentFolderName(path, isArchive).orElseThrow(() -> new IllegalArgumentException("\u5f15\u6570\u304c\u4e0d\u6b63\u3067\u3059\u3002"));
        String fileName = ResourceHelper.getFileName(path, isArchive);
        ResourceLocation location = ResourceHelper.getLocation(packName, fileName);
        fileName = ResourceHelper.removeExtension(fileName);
        fileName = ResourceHelper.removeNameLastIndex(fileName);
        this.soundManager.addSound(packName, fileName, location);
        ResourceWrapper.addResourcePath(location, path, homePath, isArchive);
        if (LMMLConfig.isDebugMode()) {
            LOGGER.debug("Loaded Sound : " + packName + " : " + fileName);
        }
    }
}

