/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidmodelloader.client.resource.manager;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.WeighedSoundEvents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.sistr.littlemaidmodelloader.client.resource.LMSoundInstance;
import net.sistr.littlemaidmodelloader.client.resource.holder.SoundHolder;

@OnlyIn(value=Dist.CLIENT)
public class LMSoundManager {
    public static final LMSoundManager INSTANCE = new LMSoundManager();
    private final Map<String, SoundHolder> soundPaths = new HashMap<String, SoundHolder>();

    public void addSound(String packName, String fileName, ResourceLocation location) {
        SoundHolder soundHolder = this.soundPaths.computeIfAbsent(packName.toLowerCase(), k -> new SoundHolder(packName));
        soundHolder.addSound(fileName, location);
    }

    public Optional<WeighedSoundEvents> getSound(String soundFileName) {
        SoundHolder soundHolder;
        int lastSplitter = soundFileName.lastIndexOf(".");
        if (lastSplitter == -1) {
            return Optional.empty();
        }
        String fileName = soundFileName.substring(lastSplitter + 1);
        String packName = soundFileName.substring(0, lastSplitter);
        if ((lastSplitter = packName.lastIndexOf(".")) != -1) {
            packName = packName.substring(lastSplitter + 1);
        }
        if ((soundHolder = this.soundPaths.get(packName)) == null) {
            return Optional.empty();
        }
        return soundHolder.getSoundSet(fileName);
    }

    public void play(String soundFileName, SoundSource soundCategory, float volume, float pitch, double x, double y, double z) {
        this.getSound(soundFileName).ifPresent(soundSet -> Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new LMSoundInstance((WeighedSoundEvents)soundSet, soundCategory, volume, pitch, x, y, z)));
    }
}

