/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidmodelloader.client.screen;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.sistr.littlemaidmodelloader.client.screen.GUIElement;
import net.sistr.littlemaidmodelloader.client.screen.ListGUIElement;
import net.sistr.littlemaidmodelloader.client.screen.MarginedClickable;
import net.sistr.littlemaidmodelloader.client.screen.ModelSelectScreen;
import net.sistr.littlemaidmodelloader.client.screen.MultiModelGUIUtil;
import net.sistr.littlemaidmodelloader.entity.compound.IHasMultiModel;
import net.sistr.littlemaidmodelloader.multimodel.IMultiModel;
import net.sistr.littlemaidmodelloader.resource.holder.TextureHolder;
import net.sistr.littlemaidmodelloader.resource.manager.LMModelManager;
import net.sistr.littlemaidmodelloader.resource.util.ArmorPart;
import net.sistr.littlemaidmodelloader.resource.util.ArmorSets;

public class ArmorModelGUI
extends GUIElement
implements ListGUIElement {
    private static final ArmorSets<ItemStack> ARMOR_ICONS = new ArmorSets();
    private final MarginedClickable selectBox = new MarginedClickable(4);
    private final int scale;
    private final MultiModelGUIUtil.DummyModelEntity dummy;
    private final TextureHolder texture;
    private final ImmutableList<String> armorNames;
    private final ArmorSets<ArmorModelGUI> armors;
    private boolean selected;

    public ArmorModelGUI(TextureHolder texture, int scale, MultiModelGUIUtil.DummyModelEntity dummy, ArmorSets<ArmorModelGUI> armors) {
        super(scale * 16, scale * 3);
        this.scale = scale;
        this.dummy = dummy;
        this.texture = texture;
        this.armorNames = ImmutableList.copyOf(texture.getArmorNames());
        this.armors = armors;
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        MultiModelGUIUtil.getModel(LMModelManager.INSTANCE, this.texture).ifPresent(model -> this.renderAllArmorModel(matrices, this.scale, mouseX, mouseY, (IMultiModel)model, this.texture, this.dummy));
    }

    public void renderAllArmorModel(PoseStack matrixStack, int scale, float mouseX, float mouseY, IMultiModel model, TextureHolder texture, MultiModelGUIUtil.DummyModelEntity dummy) {
        int index = 0;
        LMModelManager modelManager = LMModelManager.INSTANCE;
        for (String armorName : this.armorNames) {
            ArmorPart armorData = MultiModelGUIUtil.getArmorDate(modelManager, texture, armorName);
            MultiModelGUIUtil.renderArmor(this.x + ++index * scale - scale / 2, this.y + this.height, mouseX, mouseY, scale, model, armorData, dummy);
        }
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        fontRenderer.m_92883_(matrixStack, texture.getTextureName(), (float)this.x, (float)this.y, -1);
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        ARMOR_ICONS.foreach((part, stack) -> {
            int n = this.x + this.width - 16 * (part.getIndex() + 1);
            Objects.requireNonNull(fontRenderer);
            itemRenderer.m_115123_(stack, n, this.y + 9);
        });
        this.armors.foreach((p, g) -> {
            if (g == this) {
                int n = this.x + this.width - 16 * (p.getIndex() + 1);
                Objects.requireNonNull(fontRenderer);
                int n2 = this.x + this.width - 16 * (p.getIndex() + 1) + 16;
                Objects.requireNonNull(fontRenderer);
                ModelSelectScreen.renderColor(matrixStack, n, this.y + 9, n2, this.y + 9 + 16, -2130706433);
            }
        });
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.selectBox.click(mouseX, mouseY);
            return true;
        }
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (button == 0 && this.selectBox.release(mouseX, mouseY)) {
            Font fontRenderer = Minecraft.m_91087_().f_91062_;
            if ((double)(this.width - 64) <= mouseX && mouseX < (double)this.width) {
                Objects.requireNonNull(fontRenderer);
                if (9.0 <= mouseY) {
                    Objects.requireNonNull(fontRenderer);
                    if (mouseY < (double)(9 + 16)) {
                        int index = 3 - Mth.m_14107_((double)((mouseX - (double)(this.width - 64)) / 16.0));
                        IHasMultiModel.Part part = IHasMultiModel.Part.getPart(index);
                        if (this.armors.getArmor(part).filter(g -> g == this).isPresent()) {
                            this.armors.setArmor(null, part);
                        } else {
                            this.armors.setArmor(this, part);
                        }
                    }
                }
            }
            return true;
        }
        return false;
    }

    public TextureHolder getTexture() {
        return this.texture;
    }

    @Override
    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    static {
        ARMOR_ICONS.setArmor(Items.f_42472_.m_7968_(), IHasMultiModel.Part.HEAD);
        ARMOR_ICONS.setArmor(Items.f_42473_.m_7968_(), IHasMultiModel.Part.BODY);
        ARMOR_ICONS.setArmor(Items.f_42474_.m_7968_(), IHasMultiModel.Part.LEGS);
        ARMOR_ICONS.setArmor(Items.f_42475_.m_7968_(), IHasMultiModel.Part.FEET);
    }
}

