/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidmodelloader.client.screen;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.util.Mth;
import net.sistr.littlemaidmodelloader.client.screen.GUIElement;
import net.sistr.littlemaidmodelloader.client.screen.ListGUIElement;
import net.sistr.littlemaidmodelloader.client.screen.MarginedClickable;

public class ListGUI<T extends GUIElement>
extends GUIElement {
    protected final MarginedClickable selectBox = new MarginedClickable(4);
    protected final int widthStack;
    protected final int heightStack;
    protected final int elementW;
    protected final int elementH;
    protected final ImmutableList<T> elements;
    protected int scroll = 0;
    protected int selectElem = -1;

    public ListGUI(int x, int y, int widthStack, int heightStack, int elementW, int elementH, Collection<T> elements) {
        super(widthStack * elementW, heightStack * elementH);
        this.x = x;
        this.y = y;
        this.widthStack = widthStack;
        this.heightStack = heightStack;
        this.elementW = elementW;
        this.elementH = elementH;
        this.elements = ImmutableList.copyOf(elements);
    }

    public int size() {
        return this.elements.size();
    }

    public void setScroll(int scroll) {
        this.scroll = scroll;
        this.scroll = Mth.m_14045_((int)this.scroll, (int)0, (int)(this.size() / this.widthStack - 1));
    }

    public int getScroll() {
        return this.scroll;
    }

    public List<T> getAllElements() {
        return Lists.newArrayList(this.elements);
    }

    public Optional<T> getSelectElement() {
        if (this.checkElementsBounds(this.selectElem)) {
            return Optional.of((GUIElement)((Object)this.elements.get(this.selectElem)));
        }
        return Optional.empty();
    }

    protected Optional<T> getElement(double mouseX, double mouseY) {
        int index = this.getIndex(mouseX, mouseY);
        if (this.checkElementsBounds(index)) {
            return Optional.of((GUIElement)((Object)this.elements.get(index)));
        }
        return Optional.empty();
    }

    protected double getElementX(double mouseX) {
        return (mouseX - (double)this.x) % (double)this.elementW;
    }

    protected double getElementY(double mouseY) {
        return (mouseY - (double)this.y) % (double)this.elementH;
    }

    protected int getIndex(double mouseX, double mouseY) {
        if ((double)this.x <= mouseX && mouseX < (double)(this.x + this.elementW * this.widthStack) && (double)this.y <= mouseY && mouseY < (double)(this.y + this.elementH * this.heightStack)) {
            int xIndex = Mth.m_14143_((float)((float)(mouseX - (double)this.x) / (float)this.elementW));
            int yIndex = Mth.m_14143_((float)((float)(mouseY - (double)this.y) / (float)this.elementH));
            int index = this.scroll * this.widthStack + yIndex * this.widthStack + xIndex;
            if (this.checkElementsBounds(index)) {
                return index;
            }
        }
        return -1;
    }

    protected boolean checkElementsBounds(int index) {
        return 0 <= index && index < this.elements.size();
    }

    protected boolean isRenderingElement(int index) {
        return this.scroll * this.widthStack <= index && index < this.scroll * this.widthStack + this.widthStack * this.heightStack;
    }

    protected int getElementXIndex(int index) {
        return index % this.widthStack;
    }

    protected int getElementYIndex(int index) {
        return index / this.widthStack - this.scroll;
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        for (int i = 0; i < this.widthStack * this.heightStack; ++i) {
            int xIndex = i % this.widthStack;
            int yIndex = i / this.widthStack;
            int x = this.x + this.elementW * xIndex;
            int y = this.y + this.elementH * yIndex;
            int index = this.scroll * this.widthStack + yIndex * this.widthStack + xIndex;
            if (!this.checkElementsBounds(index)) continue;
            GUIElement elem = (GUIElement)((Object)this.elements.get(index));
            elem.setPos(x, y);
            elem.m_6305_(matrices, mouseX, mouseY, delta);
        }
    }

    public void m_94757_(double mouseX, double mouseY) {
        Optional<T> e = this.getElement(mouseX, mouseY);
        if (e.isPresent()) {
            GUIElement element = (GUIElement)((Object)e.get());
            element.m_94757_(this.getElementX(mouseX), this.getElementY(mouseY));
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        Optional<T> e;
        if (button == 0) {
            this.selectBox.click(mouseX, mouseY);
        }
        if ((e = this.getElement(mouseX, mouseY)).isPresent()) {
            GUIElement element = (GUIElement)((Object)e.get());
            return element.m_6375_(this.getElementX(mouseX), this.getElementY(mouseY), button);
        }
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        Optional<T> e = this.getElement(mouseX, mouseY);
        if (e.isPresent()) {
            int index;
            if (button == 0 && this.selectBox.release(mouseX, mouseY) && this.checkElementsBounds(index = this.getIndex(mouseX, mouseY))) {
                GUIElement prev;
                if (this.selectElem != index && this.checkElementsBounds(this.selectElem) && (prev = (GUIElement)((Object)this.elements.get(this.selectElem))) instanceof ListGUIElement) {
                    ((ListGUIElement)((Object)prev)).setSelected(false);
                }
                this.selectElem = index;
                GUIElement now = (GUIElement)((Object)this.elements.get(this.selectElem));
                if (now instanceof ListGUIElement) {
                    ((ListGUIElement)((Object)now)).setSelected(true);
                }
            }
            GUIElement element = (GUIElement)((Object)e.get());
            return element.m_6348_(this.getElementX(mouseX), this.getElementY(mouseY), button);
        }
        return false;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        Optional<T> e = this.getElement(mouseX, mouseY);
        if (e.isPresent()) {
            GUIElement element = (GUIElement)((Object)e.get());
            return element.m_7979_(this.getElementX(mouseX), this.getElementY(mouseY), button, deltaX, deltaY);
        }
        return false;
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        GUIElement element;
        Optional<T> e = this.getElement(mouseX, mouseY);
        if (e.isPresent() && (element = (GUIElement)((Object)e.get())).m_6050_(this.getElementX(mouseX), this.getElementY(mouseY), amount)) {
            return true;
        }
        this.scroll += 0.0 < amount ? -1 : 1;
        this.scroll = Mth.m_14045_((int)this.scroll, (int)0, (int)(this.size() / this.widthStack - 1));
        return true;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char chr, int modifiers) {
        return super.m_5534_(chr, modifiers);
    }

    public boolean m_5755_(boolean lookForwards) {
        return super.m_5755_(lookForwards);
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        Optional<T> e = this.getElement(mouseX, mouseY);
        if (e.isPresent()) {
            GUIElement element = (GUIElement)((Object)e.get());
            return element.m_5953_(this.getElementX(mouseX), this.getElementY(mouseY));
        }
        return false;
    }
}

