/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidmodelloader.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.sistr.littlemaidmodelloader.client.screen.ArmorModelGUI;
import net.sistr.littlemaidmodelloader.client.screen.ListGUI;
import net.sistr.littlemaidmodelloader.client.screen.MultiModelGUI;
import net.sistr.littlemaidmodelloader.client.screen.MultiModelGUIUtil;
import net.sistr.littlemaidmodelloader.client.screen.ScrollBar;
import net.sistr.littlemaidmodelloader.client.screen.TextureAddress;
import net.sistr.littlemaidmodelloader.entity.compound.IHasMultiModel;
import net.sistr.littlemaidmodelloader.network.SyncMultiModelPacket;
import net.sistr.littlemaidmodelloader.resource.holder.TextureHolder;
import net.sistr.littlemaidmodelloader.resource.manager.LMModelManager;
import net.sistr.littlemaidmodelloader.resource.manager.LMTextureManager;
import net.sistr.littlemaidmodelloader.resource.util.ArmorPart;
import net.sistr.littlemaidmodelloader.resource.util.ArmorSets;
import net.sistr.littlemaidmodelloader.resource.util.TextureColors;
import net.sistr.littlemaidmodelloader.resource.util.TexturePair;

@OnlyIn(value=Dist.CLIENT)
public class ModelSelectScreen<T extends Entity>
extends Screen {
    public static final ResourceLocation EMPTY_TEXTURE = new ResourceLocation("littlemaidmodelloader", "textures/empty.png");
    public static final TexturePair EMPTY_TEXTURE_PAIR = new TexturePair(EMPTY_TEXTURE, null);
    public static final ArmorPart EMPTY_ARMOR_DATA = new ArmorPart(null, null, null, null, null, null);
    public static final ResourceLocation MODEL_SELECT_GUI_TEXTURE = new ResourceLocation("littlemaidmodelloader", "textures/gui/model_select.png");
    private static final ItemStack ARMOR = Items.f_42473_.m_7968_();
    private static final int GUI_WIDTH = 256;
    private static final int GUI_HEIGHT = 196;
    private final T entity;
    private final MultiModelGUIUtil.DummyModelEntity dummy;
    private final ArmorSets<ArmorModelGUI> armors = new ArmorSets();
    private ScrollBar modelScrollBar;
    private ScrollBar armorScrollBar;
    private ListGUI<MultiModelGUI> modelListGUI;
    private ListGUI<ArmorModelGUI> armorListGUI;
    private boolean guiSwitch = true;

    public ModelSelectScreen(Component titleIn, Level world, T entity) {
        super(titleIn);
        this.entity = entity;
        this.dummy = new MultiModelGUIUtil.DummyModelEntity(world);
    }

    protected void m_7856_() {
        assert (this.f_96541_ != null);
        Collection<TextureHolder> textureHolders = LMTextureManager.INSTANCE.getAllTextures();
        HashMap map = new HashMap();
        textureHolders.forEach(textureHolder -> map.put(textureHolder.getTextureName().toLowerCase(), textureHolder));
        LMModelManager modelManager = LMModelManager.INSTANCE;
        int scale = 15;
        int allColor = 16;
        int heightRatio = 3;
        int heightStack = 4;
        this.modelListGUI = new ListGUI((this.f_96543_ - scale * allColor) / 2, (this.f_96544_ - scale * heightRatio * heightStack) / 2, 1, heightStack, scale * allColor, scale * heightRatio, textureHolders.stream().map(TextureHolder::getTextureName).map(String::toLowerCase).sorted(Comparator.naturalOrder()).map(map::get).filter(textureHolder -> textureHolder.hasSkinTexture(true) && modelManager.getModel(textureHolder.getModelName(), IHasMultiModel.Layer.SKIN).isPresent()).map(t -> new MultiModelGUI((TextureHolder)t, true, scale, this.dummy)).collect(Collectors.toList()));
        this.modelScrollBar = new ScrollBar((this.f_96543_ + 256) / 2 + 4, (this.f_96544_ - 196) / 2, 8, 196, this.modelListGUI.size(), new TextureAddress(0, 200, 8, 8, 256, 256), new TextureAddress(0, 208, 8, 8, 256, 256), new TextureAddress(0, 216, 8, 8, 256, 256), new TextureAddress(0, 224, 10, 6, 256, 256), MODEL_SELECT_GUI_TEXTURE);
        TextureHolder ownerSkinTex = ((IHasMultiModel)this.entity).getTextureHolder(IHasMultiModel.Layer.SKIN, IHasMultiModel.Part.HEAD);
        int index = 0;
        for (MultiModelGUI g : this.modelListGUI.getAllElements()) {
            if (g.getTexture() == ownerSkinTex) {
                this.modelScrollBar.setPoint(index);
                this.modelListGUI.setScroll(index);
            }
            ++index;
        }
        this.armorListGUI = new ListGUI((this.f_96543_ - scale * allColor) / 2, (this.f_96544_ - scale * heightRatio * heightStack) / 2, 1, heightStack, scale * allColor, scale * heightRatio, textureHolders.stream().map(TextureHolder::getTextureName).map(String::toLowerCase).sorted(Comparator.naturalOrder()).map(map::get).filter(textureHolder -> textureHolder.hasArmorTexture() && modelManager.getModel(textureHolder.getModelName(), IHasMultiModel.Layer.INNER).isPresent()).map(t -> new ArmorModelGUI((TextureHolder)t, scale, this.dummy, this.armors)).collect(Collectors.toList()));
        this.armorScrollBar = new ScrollBar((this.f_96543_ + 256) / 2 + 4, (this.f_96544_ - 196) / 2, 8, 196, this.armorListGUI.size(), new TextureAddress(0, 200, 8, 8, 256, 256), new TextureAddress(0, 208, 8, 8, 256, 256), new TextureAddress(0, 216, 8, 8, 256, 256), new TextureAddress(0, 224, 10, 6, 256, 256), MODEL_SELECT_GUI_TEXTURE);
        TextureHolder ownerArmorTex = ((IHasMultiModel)this.entity).getTextureHolder(IHasMultiModel.Layer.INNER, IHasMultiModel.Part.HEAD);
        index = 0;
        for (ArmorModelGUI g : this.armorListGUI.getAllElements()) {
            if (g.getTexture() == ownerArmorTex) {
                this.armorScrollBar.setPoint(index);
                this.armorListGUI.setScroll(index);
            }
            ++index;
        }
    }

    public static void renderColor(PoseStack matrixStack, int minX, int minY, int maxX, int maxY, int rgba) {
        GuiComponent.m_93172_((PoseStack)matrixStack, (int)minX, (int)minY, (int)maxX, (int)maxY, (int)rgba);
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        assert (this.f_96541_ != null);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)MODEL_SELECT_GUI_TEXTURE);
        int relX = (this.f_96543_ - 256) / 2;
        int relY = (this.f_96544_ - 196) / 2;
        this.m_93228_(matrixStack, relX, relY, 0, 0, 256, 196);
        Minecraft.m_91087_().m_91291_().m_115123_(ARMOR, relX - 24, relY + 196 - 16);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)MODEL_SELECT_GUI_TEXTURE);
        this.m_93228_(matrixStack, relX - 24, relY + 196 - 16, 0, 240, 16, 16);
        if (this.guiSwitch) {
            this.modelListGUI.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
            this.modelListGUI.getSelectElement().filter(MultiModelGUI::isSelected).ifPresent(g -> g.getSelectColor().ifPresent(color -> {
                TextureHolder texture = g.getTexture();
                MultiModelGUIUtil.getModel(LMModelManager.INSTANCE, texture).ifPresent(model -> {
                    int scale = 45;
                    MultiModelGUIUtil.getTexturePair(texture, color, true).ifPresent(texturePair -> MultiModelGUIUtil.renderModel((this.f_96543_ + 240 + scale * 2) / 2, this.f_96544_ - scale, mouseX, mouseY, scale, model, texturePair, this.dummy));
                });
            }));
            this.modelScrollBar.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        } else {
            this.armorListGUI.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
            this.armors.foreach((p, g) -> {
                TextureHolder texture = g.getTexture();
                MultiModelGUIUtil.getModel(LMModelManager.INSTANCE, texture).ifPresent(model -> {
                    int scale = 45;
                    LMModelManager modelManager = LMModelManager.INSTANCE;
                    ArmorPart armorData = MultiModelGUIUtil.getArmorDate(modelManager, texture, "default");
                    MultiModelGUIUtil.renderArmorPart((this.f_96543_ + 240 + scale * 2) / 2, this.f_96544_ - scale, mouseX, mouseY, scale, model, armorData, p, this.dummy);
                });
            });
            this.armorScrollBar.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        }
    }

    public boolean m_6375_(double x, double y, int button) {
        int minX = (this.f_96543_ - 256) / 2 - 24;
        int minY = (this.f_96544_ - 196) / 2 + 196 - 16;
        if ((double)minX <= x && x < (double)(minX + 16) && (double)minY <= y && y < (double)(minY + 16)) {
            this.guiSwitch = !this.guiSwitch;
            ModelSelectScreen.playDownSound();
            return true;
        }
        if (this.guiSwitch) {
            if (this.modelScrollBar.m_6375_(x, y, button)) {
                this.modelListGUI.setScroll(this.modelScrollBar.getPoint());
                return true;
            }
            return this.modelListGUI.m_6375_(x, y, button);
        }
        if (this.armorScrollBar.m_6375_(x, y, button)) {
            this.armorListGUI.setScroll(this.armorScrollBar.getPoint());
            return true;
        }
        return this.armorListGUI.m_6375_(x, y, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.guiSwitch) {
            if (this.modelScrollBar.m_7979_(mouseX, mouseY, button, deltaX, deltaY)) {
                this.modelListGUI.setScroll(this.modelScrollBar.getPoint());
                return true;
            }
        } else if (this.armorScrollBar.m_7979_(mouseX, mouseY, button, deltaX, deltaY)) {
            this.armorListGUI.setScroll(this.armorScrollBar.getPoint());
            return true;
        }
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.guiSwitch) {
            this.modelScrollBar.m_6348_(mouseX, mouseY, button);
            return this.modelListGUI.m_6348_(mouseX, mouseY, button);
        }
        this.armorScrollBar.m_6348_(mouseX, mouseY, button);
        return this.armorListGUI.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double x, double y, double scrollAmount) {
        if (this.guiSwitch) {
            if (this.modelScrollBar.m_6050_(x, y, scrollAmount)) {
                this.modelListGUI.setScroll(this.modelScrollBar.getPoint());
                return true;
            }
            if (this.modelListGUI.m_6050_(x, y, scrollAmount)) {
                this.modelScrollBar.setPoint(this.modelListGUI.getScroll());
                return true;
            }
            return false;
        }
        if (this.armorScrollBar.m_6050_(x, y, scrollAmount)) {
            this.armorListGUI.setScroll(this.armorScrollBar.getPoint());
            return true;
        }
        if (this.armorListGUI.m_6050_(x, y, scrollAmount)) {
            this.armorScrollBar.setPoint(this.armorListGUI.getScroll());
            return true;
        }
        return false;
    }

    public void m_7379_() {
        super.m_7379_();
        this.modelListGUI.getSelectElement().ifPresent(g -> g.getSelectColor().ifPresent(color -> {
            TextureHolder texture = g.getTexture();
            ((IHasMultiModel)this.entity).setColor((TextureColors)((Object)((Object)color)));
            ((IHasMultiModel)this.entity).setContract(true);
            ((IHasMultiModel)this.entity).setTextureHolder(texture, IHasMultiModel.Layer.SKIN, IHasMultiModel.Part.HEAD);
            for (IHasMultiModel.Part part : IHasMultiModel.Part.values()) {
                ((IHasMultiModel)this.entity).setTextureHolder(texture, IHasMultiModel.Layer.INNER, part);
            }
        }));
        this.armors.foreach((p, g) -> ((IHasMultiModel)this.entity).setTextureHolder(g.getTexture(), IHasMultiModel.Layer.INNER, (IHasMultiModel.Part)((Object)p)));
        ArmorSets<String> armorNames = new ArmorSets<String>();
        for (IHasMultiModel.Part part : IHasMultiModel.Part.values()) {
            armorNames.setArmor(((IHasMultiModel)this.entity).getTextureHolder(IHasMultiModel.Layer.INNER, part).getTextureName(), part);
        }
        SyncMultiModelPacket.sendC2SPacket(this.entity, (IHasMultiModel)this.entity);
    }

    public static void playDownSound() {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
    }
}

