/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidmodelloader.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.util.Mth;
import net.sistr.littlemaidmodelloader.client.screen.GUIElement;
import net.sistr.littlemaidmodelloader.client.screen.ListGUIElement;
import net.sistr.littlemaidmodelloader.client.screen.MarginedClickable;
import net.sistr.littlemaidmodelloader.client.screen.MultiModelGUIUtil;
import net.sistr.littlemaidmodelloader.multimodel.IMultiModel;
import net.sistr.littlemaidmodelloader.resource.holder.TextureHolder;
import net.sistr.littlemaidmodelloader.resource.manager.LMModelManager;
import net.sistr.littlemaidmodelloader.resource.util.TextureColors;

public class MultiModelGUI
extends GUIElement
implements ListGUIElement {
    private final MarginedClickable selectBox = new MarginedClickable(4);
    private final int scale;
    private final MultiModelGUIUtil.DummyModelEntity dummy;
    private final TextureHolder texture;
    private final boolean isContract;
    private TextureColors selectColor = null;
    private boolean selected;

    public MultiModelGUI(TextureHolder texture, boolean isContract, int scale, MultiModelGUIUtil.DummyModelEntity dummy) {
        super(scale * 16, scale * 3);
        this.isContract = isContract;
        this.scale = scale;
        this.dummy = dummy;
        this.texture = texture;
    }

    public TextureHolder getTexture() {
        return this.texture;
    }

    public Optional<TextureColors> getSelectColor() {
        return Optional.ofNullable(this.selectColor);
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        if (this.selected && this.selectColor != null) {
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            MultiModelGUI.m_93172_((PoseStack)matrices, (int)(this.x + this.selectColor.getIndex() * this.scale), (int)this.y, (int)(this.x + this.selectColor.getIndex() * this.scale + this.scale), (int)(this.y + this.height), (int)(Integer.MIN_VALUE | this.selectColor.getColorCode()));
            RenderSystem.m_69461_();
        }
        MultiModelGUIUtil.getModel(LMModelManager.INSTANCE, this.texture).ifPresent(model -> this.renderAllColorModel(matrices, this.scale, mouseX, mouseY, (IMultiModel)model, this.texture, this.isContract));
    }

    private void renderAllColorModel(PoseStack matrixStack, int scale, float mouseX, float mouseY, IMultiModel model, TextureHolder holder, boolean isContract) {
        for (TextureColors color : TextureColors.values()) {
            MultiModelGUIUtil.getTexturePair(holder, color, isContract).ifPresent(texturePair -> MultiModelGUIUtil.renderModel(this.x + (color.getIndex() + 1) * scale - scale / 2, this.y + this.height, mouseX, mouseY, scale, model, texturePair, this.dummy));
        }
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        fontRenderer.m_92883_(matrixStack, holder.getTextureName(), (float)this.x, (float)this.y, -1);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.selectBox.click(mouseX, mouseY);
            return true;
        }
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (button == 0 && this.selectBox.release(mouseX, mouseY)) {
            this.selectColor = TextureColors.getColor(Mth.m_14107_((double)(mouseX / (double)this.scale)));
            return true;
        }
        return false;
    }

    @Override
    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }
}

