/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidmodelloader.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.sistr.littlemaidmodelloader.client.screen.GUIElement;
import net.sistr.littlemaidmodelloader.client.screen.RangeChecker;
import net.sistr.littlemaidmodelloader.client.screen.TextureAddress;

public class ScrollBar
extends GUIElement {
    private final int elemSize;
    private final TextureAddress sliderT;
    private final TextureAddress sliderM;
    private final TextureAddress sliderB;
    private final TextureAddress pointer;
    private final ResourceLocation texture;
    private boolean clicked;
    private int point;

    public ScrollBar(int x, int y, int width, int height, int elemSize, TextureAddress sliderT, TextureAddress sliderM, TextureAddress sliderB, TextureAddress pointer, ResourceLocation texture) {
        super(width, height);
        this.x = x;
        this.y = y;
        this.elemSize = elemSize;
        this.sliderT = sliderT;
        this.sliderM = sliderM;
        this.sliderB = sliderB;
        this.pointer = pointer;
        this.texture = texture;
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.texture);
        this.draw(matrices, this.x, this.y, this.sliderT);
        int midRange = this.height - (this.sliderT.getHeight() + this.sliderB.getHeight());
        int i = 0;
        while (i < midRange) {
            this.draw(matrices, this.x, this.y + (i += this.sliderM.getHeight()), this.sliderM);
        }
        this.draw(matrices, this.x, this.y + this.height - this.sliderB.getHeight(), this.sliderB);
        this.draw(matrices, this.x + (this.sliderT.getWidth() - this.pointer.getWidth()) / 2, (int)((float)this.y + (float)(this.width - this.pointer.getHeight()) / 2.0f + this.getPercent() * (float)(this.height - this.width)), this.pointer);
    }

    private void draw(PoseStack matrices, int x, int y, TextureAddress texture) {
        ScrollBar.m_93133_((PoseStack)matrices, (int)x, (int)y, (float)texture.getU(), (float)texture.getV(), (int)texture.getWidth(), (int)texture.getHeight(), (int)texture.getTexSizeW(), (int)texture.getTexSizeH());
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button != 0) {
            return false;
        }
        if (!RangeChecker.checkFromWidth(mouseX, mouseY, this.x, this.y, this.width, this.height)) {
            return false;
        }
        this.clicked = true;
        this.pointAt(mouseY);
        return true;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (button != 0) {
            return false;
        }
        if (!this.clicked && !RangeChecker.checkFromWidth(mouseX, mouseY, this.x, this.y, this.width, this.height)) {
            return false;
        }
        this.clicked = true;
        this.pointAt(mouseY);
        return true;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.clicked = false;
            return false;
        }
        return false;
    }

    public void pointAt(double y) {
        float percent = ((float)y - (float)this.y - (float)this.width / 2.0f) / (float)(this.height - this.width);
        this.point = Mth.m_14143_((float)(percent * (float)this.elemSize));
        this.point = Mth.m_14045_((int)this.point, (int)0, (int)(this.elemSize - 1));
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        if (!RangeChecker.checkFromWidth(mouseX, mouseY, this.x, this.y, this.width, this.height)) {
            return false;
        }
        this.point += 0.0 < amount ? -1 : 1;
        this.point = Mth.m_14045_((int)this.point, (int)0, (int)(this.elemSize - 1));
        return true;
    }

    public float getPercent() {
        return (float)this.getPoint() / (float)this.elemSize;
    }

    public void setPercent(float percent) {
        this.point = Mth.m_14143_((float)(percent * (float)this.elemSize));
        this.point = Mth.m_14045_((int)this.point, (int)0, (int)(this.elemSize - 1));
    }

    public int getPoint() {
        return this.point;
    }

    public void setPoint(int point) {
        this.point = point;
        this.point = Mth.m_14045_((int)this.point, (int)0, (int)(this.elemSize - 1));
    }
}

