/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidmodelloader.entity;

import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.sistr.littlemaidmodelloader.client.screen.ModelSelectScreen;
import net.sistr.littlemaidmodelloader.client.screen.SoundPackSelectScreen;
import net.sistr.littlemaidmodelloader.entity.compound.IHasMultiModel;
import net.sistr.littlemaidmodelloader.entity.compound.MultiModelCompound;
import net.sistr.littlemaidmodelloader.entity.compound.SoundPlayable;
import net.sistr.littlemaidmodelloader.entity.compound.SoundPlayableCompound;
import net.sistr.littlemaidmodelloader.maidmodel.IModelCaps;
import net.sistr.littlemaidmodelloader.multimodel.IMultiModel;
import net.sistr.littlemaidmodelloader.multimodel.layer.MMPose;
import net.sistr.littlemaidmodelloader.network.CustomMobSpawnPacket;
import net.sistr.littlemaidmodelloader.network.util.CustomPacketEntity;
import net.sistr.littlemaidmodelloader.resource.holder.ConfigHolder;
import net.sistr.littlemaidmodelloader.resource.holder.TextureHolder;
import net.sistr.littlemaidmodelloader.resource.manager.LMModelManager;
import net.sistr.littlemaidmodelloader.resource.manager.LMTextureManager;
import net.sistr.littlemaidmodelloader.resource.util.TextureColors;
import net.sistr.littlemaidmodelloader.setup.Registration;

public class MultiModelEntity
extends PathfinderMob
implements IHasMultiModel,
SoundPlayable,
CustomPacketEntity {
    private final MultiModelCompound multiModel = new MultiModelCompound((LivingEntity)this, LMTextureManager.INSTANCE.getTexture("default").orElseThrow(() -> new IllegalStateException("\u30c7\u30d5\u30a9\u30eb\u30c8\u30e2\u30c7\u30eb\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002")), LMTextureManager.INSTANCE.getTexture("default").orElseThrow(() -> new IllegalStateException("\u30c7\u30d5\u30a9\u30eb\u30c8\u30e2\u30c7\u30eb\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002")));
    private final SoundPlayableCompound soundPlayer = new SoundPlayableCompound((Entity)this, () -> this.multiModel.getTextureHolder(IHasMultiModel.Layer.SKIN, IHasMultiModel.Part.HEAD).getTextureName());

    public MultiModelEntity(Level worldIn) {
        this((EntityType<MultiModelEntity>)((EntityType)Registration.MULTI_MODEL_ENTITY.get()), worldIn);
    }

    public MultiModelEntity(EntityType<MultiModelEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder createMobAttributes() {
        return PathfinderMob.m_21552_().m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22277_, 16.0).m_22266_(Attributes.f_22282_);
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        this.multiModel.writeToNbt(nbt);
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.multiModel.readFromNbt(nbt);
    }

    @Override
    public void writeCustomPacket(FriendlyByteBuf packet) {
        this.multiModel.writeToPacket(packet);
    }

    @Override
    public void readCustomPacket(FriendlyByteBuf packet) {
        this.multiModel.readFromPacket(packet);
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_() instanceof ArmorItem) {
            ArmorItem armor = (ArmorItem)stack.m_41720_();
            this.m_8061_(armor.m_40402_(), stack);
            return InteractionResult.m_19078_((boolean)player.f_19853_.f_46443_);
        }
        if (this.f_19853_.f_46443_) {
            this.openGUI(player.m_6144_());
            this.play("se_living_daytime");
        }
        return super.m_6071_(player, hand);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void openGUI(boolean shift) {
        Minecraft.m_91087_().m_91152_(shift ? new SoundPackSelectScreen<MultiModelEntity>((Component)new TextComponent(""), this) : new ModelSelectScreen<MultiModelEntity>((Component)new TextComponent(""), this.f_19853_, this));
    }

    public EntityDimensions m_6972_(Pose pose) {
        IMultiModel model = this.getModel(IHasMultiModel.Layer.SKIN, IHasMultiModel.Part.HEAD).orElse(LMModelManager.INSTANCE.getDefaultModel());
        IModelCaps caps = this.getCaps();
        MMPose mmPose = MMPose.convertPose(pose);
        float height = model.getHeight(caps, mmPose);
        float width = model.getWidth(caps, mmPose);
        EntityDimensions dimensions = EntityDimensions.m_20395_((float)width, (float)height);
        return dimensions.m_20388_(this.m_6134_());
    }

    protected float m_6431_(Pose pose, EntityDimensions dimensions) {
        if (this.multiModel == null) {
            return dimensions.f_20378_ * 0.85f;
        }
        return this.getModel(IHasMultiModel.Layer.SKIN, IHasMultiModel.Part.HEAD).orElse(LMModelManager.INSTANCE.getDefaultModel()).getEyeHeight(this.getCaps(), MMPose.convertPose(pose));
    }

    public double m_6048_() {
        IMultiModel model = this.getModel(IHasMultiModel.Layer.SKIN, IHasMultiModel.Part.HEAD).orElse(LMModelManager.INSTANCE.getDefaultModel());
        return model.getMountedYOffset(this.getCaps());
    }

    public double m_6049_() {
        IMultiModel model = this.getModel(IHasMultiModel.Layer.SKIN, IHasMultiModel.Part.HEAD).orElse(LMModelManager.INSTANCE.getDefaultModel());
        return model.getyOffset(this.getCaps()) - this.m_20206_();
    }

    public void m_8061_(EquipmentSlot slot, ItemStack stack) {
        if (slot.m_20743_() == EquipmentSlot.Type.ARMOR) {
            this.multiModel.updateArmor();
        }
        super.m_8061_(slot, stack);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Optional<ResourceLocation> getTexture(IHasMultiModel.Layer layer, IHasMultiModel.Part part, boolean isLight) {
        return this.multiModel.getTexture(layer, part, isLight);
    }

    @Override
    public void setTextureHolder(TextureHolder textureHolder, IHasMultiModel.Layer layer, IHasMultiModel.Part part) {
        this.multiModel.setTextureHolder(textureHolder, layer, part);
        if (layer == IHasMultiModel.Layer.SKIN) {
            this.m_6210_();
        }
    }

    @Override
    public TextureHolder getTextureHolder(IHasMultiModel.Layer layer, IHasMultiModel.Part part) {
        return this.multiModel.getTextureHolder(layer, part);
    }

    @Override
    public void setColor(TextureColors color) {
        this.multiModel.setColor(color);
    }

    @Override
    public TextureColors getColor() {
        return this.multiModel.getColor();
    }

    @Override
    public void setContract(boolean isContract) {
        this.multiModel.setContract(isContract);
    }

    @Override
    public boolean isContract() {
        return this.multiModel.isContract();
    }

    @Override
    public Optional<IMultiModel> getModel(IHasMultiModel.Layer layer, IHasMultiModel.Part part) {
        return this.multiModel.getModel(layer, part);
    }

    @Override
    public IModelCaps getCaps() {
        return this.multiModel.getCaps();
    }

    @Override
    public boolean isArmorVisible(IHasMultiModel.Part part) {
        return this.multiModel.isArmorVisible(part);
    }

    @Override
    public boolean isArmorGlint(IHasMultiModel.Part part) {
        return this.multiModel.isArmorGlint(part);
    }

    @Override
    public boolean isAllowChangeTexture(Entity changer, TextureHolder textureHolder, IHasMultiModel.Layer layer, IHasMultiModel.Part part) {
        return true;
    }

    @Override
    public void play(String soundName) {
        this.soundPlayer.play(soundName);
    }

    @Override
    public void setConfigHolder(ConfigHolder configHolder) {
        this.soundPlayer.setConfigHolder(configHolder);
    }

    @Override
    public ConfigHolder getConfigHolder() {
        return this.soundPlayer.getConfigHolder();
    }

    public Packet<?> m_5654_() {
        return CustomMobSpawnPacket.createPacket((LivingEntity)this);
    }
}

