/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidmodelloader.entity.compound;

import java.util.Optional;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.sistr.littlemaidmodelloader.entity.compound.IHasMultiModel;
import net.sistr.littlemaidmodelloader.maidmodel.EntityCaps;
import net.sistr.littlemaidmodelloader.maidmodel.IModelCaps;
import net.sistr.littlemaidmodelloader.multimodel.IMultiModel;
import net.sistr.littlemaidmodelloader.resource.holder.TextureHolder;
import net.sistr.littlemaidmodelloader.resource.manager.LMModelManager;
import net.sistr.littlemaidmodelloader.resource.manager.LMTextureManager;
import net.sistr.littlemaidmodelloader.resource.util.ArmorPart;
import net.sistr.littlemaidmodelloader.resource.util.ArmorSets;
import net.sistr.littlemaidmodelloader.resource.util.TextureColors;
import net.sistr.littlemaidmodelloader.resource.util.TexturePair;

public class MultiModelCompound
implements IHasMultiModel {
    private final Entity entity;
    private final IModelCaps caps;
    private final TextureHolder defaultMainPackage;
    private final TextureHolder defaultArmorPackage;
    private TextureHolder skinTexHolder;
    private IMultiModel skinModel;
    private TexturePair skinTexture;
    private final ArmorSets<TextureHolder> armorsTexHolder = new ArmorSets();
    private final ArmorSets<ArmorPart> armorsData = new ArmorSets();
    private TextureColors color;
    private boolean isContract;

    public MultiModelCompound(LivingEntity entity, TextureHolder defaultMainPackage, TextureHolder defaultArmorPackage) {
        this.entity = entity;
        this.caps = new EntityCaps(entity);
        this.defaultMainPackage = defaultMainPackage;
        this.defaultArmorPackage = defaultArmorPackage;
        this.color = TextureColors.BROWN;
        this.update();
    }

    public void update() {
        this.updateMain();
        this.updateArmor();
    }

    public void updateMain() {
        if (this.skinTexHolder == null) {
            this.skinTexHolder = this.defaultMainPackage;
        }
        LMModelManager modelManager = LMModelManager.INSTANCE;
        this.skinModel = modelManager.getOrDefaultModel(this.skinTexHolder.getModelName(), IHasMultiModel.Layer.SKIN);
        this.skinTexture = new TexturePair(this.skinTexHolder.getTexture(this.color, this.isContract, false).orElse(null), this.skinTexHolder.getTexture(this.color, this.isContract, true).orElse(null));
    }

    public void updateArmor() {
        int index = 0;
        for (ItemStack stack : this.entity.m_6168_()) {
            if (4 < index) break;
            this.updateArmorPart(IHasMultiModel.Part.getPart(index++), this.getName(stack.m_41720_()), this.getDamagePercent(stack));
        }
    }

    private String getName(Item item) {
        if (this.entity.f_19853_.f_46443_ && item instanceof ArmorItem) {
            return ((ArmorItem)item).m_40401_().m_6082_().toLowerCase();
        }
        ResourceLocation location = Registry.f_122827_.m_7981_((Object)item);
        return location.toString();
    }

    private float getDamagePercent(ItemStack stack) {
        float damagePercent = 0.0f;
        if (stack.m_41763_() && 0 < stack.m_41776_()) {
            damagePercent = (float)stack.m_41773_() / (float)stack.m_41776_();
        }
        return damagePercent;
    }

    private void updateArmorPart(IHasMultiModel.Part part, String armorName, float damagePercent) {
        TextureHolder textureHolder = this.armorsTexHolder.getArmor(part).orElse(this.defaultArmorPackage);
        this.armorsTexHolder.setArmor(textureHolder, part);
        LMModelManager manager = LMModelManager.INSTANCE;
        ArmorPart.Builder dataBuilder = ArmorPart.Builder.newInstance();
        dataBuilder.innerModel(manager.getOrDefaultModel(textureHolder.getModelName(), IHasMultiModel.Layer.INNER));
        dataBuilder.outerModel(manager.getOrDefaultModel(textureHolder.getModelName(), IHasMultiModel.Layer.OUTER));
        dataBuilder.innerTex(textureHolder.getArmorTexture(IHasMultiModel.Layer.INNER, armorName, damagePercent, false).orElse(null));
        dataBuilder.innerTexLight(textureHolder.getArmorTexture(IHasMultiModel.Layer.INNER, armorName, damagePercent, true).orElse(null));
        dataBuilder.outerTex(textureHolder.getArmorTexture(IHasMultiModel.Layer.OUTER, armorName, damagePercent, false).orElse(null));
        dataBuilder.outerTexLight(textureHolder.getArmorTexture(IHasMultiModel.Layer.OUTER, armorName, damagePercent, true).orElse(null));
        this.armorsData.setArmor(dataBuilder.build(), part);
    }

    @Override
    public void setTextureHolder(TextureHolder textureHolder, IHasMultiModel.Layer layer, IHasMultiModel.Part part) {
        if (layer == IHasMultiModel.Layer.SKIN) {
            this.skinTexHolder = textureHolder;
            this.updateMain();
        } else {
            this.armorsTexHolder.setArmor(textureHolder, part);
            int index = 0;
            for (ItemStack stack : this.entity.m_6168_()) {
                if (part.getIndex() != index++) continue;
                this.updateArmorPart(part, this.getName(stack.m_41720_()), this.getDamagePercent(stack));
            }
        }
    }

    @Override
    public TextureHolder getTextureHolder(IHasMultiModel.Layer layer, IHasMultiModel.Part part) {
        if (layer == IHasMultiModel.Layer.SKIN) {
            return this.skinTexHolder;
        }
        return this.armorsTexHolder.getArmor(part).orElseThrow(() -> new IllegalStateException("\u9632\u5177\u30c6\u30af\u30b9\u30c1\u30e3\u30db\u30eb\u30c0\u30fc\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002"));
    }

    @Override
    public Optional<IMultiModel> getModel(IHasMultiModel.Layer layer, IHasMultiModel.Part part) {
        if (layer == IHasMultiModel.Layer.SKIN) {
            return Optional.ofNullable(this.skinModel);
        }
        IMultiModel model = this.armorsData.getArmor(part).orElseThrow(() -> new IllegalStateException("\u9632\u5177\u30c7\u30fc\u30bf\u304c\u5b58\u5728\u3057\u307e\u305b\u3093")).getModel(layer);
        return Optional.ofNullable(model);
    }

    @Override
    public Optional<ResourceLocation> getTexture(IHasMultiModel.Layer layer, IHasMultiModel.Part part, boolean isLight) {
        if (layer == IHasMultiModel.Layer.SKIN) {
            return Optional.ofNullable(this.skinTexture.getTexture(isLight));
        }
        ResourceLocation resourceLocation = this.armorsData.getArmor(part).orElseThrow(() -> new IllegalStateException("\u9632\u5177\u30c7\u30fc\u30bf\u304c\u5b58\u5728\u3057\u307e\u305b\u3093")).getTexture(layer, isLight);
        return Optional.ofNullable(resourceLocation);
    }

    @Override
    public IModelCaps getCaps() {
        return this.caps;
    }

    @Override
    public boolean isArmorVisible(IHasMultiModel.Part part) {
        int index = 0;
        for (ItemStack stack : this.entity.m_6168_()) {
            if (part.getIndex() != index++ || stack.m_41619_()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isArmorGlint(IHasMultiModel.Part part) {
        int index = 0;
        for (ItemStack stack : this.entity.m_6168_()) {
            if (part.getIndex() != index++ || stack.m_41619_()) continue;
            return stack.m_41793_();
        }
        return false;
    }

    @Override
    public boolean isAllowChangeTexture(Entity changer, TextureHolder textureHolder, IHasMultiModel.Layer layer, IHasMultiModel.Part part) {
        return true;
    }

    @Override
    public void setColor(TextureColors color) {
        this.color = color;
        this.updateMain();
    }

    @Override
    public TextureColors getColor() {
        return this.color;
    }

    @Override
    public void setContract(boolean contract) {
        this.isContract = contract;
        this.updateMain();
    }

    @Override
    public boolean isContract() {
        return this.isContract;
    }

    public void writeToNbt(CompoundTag nbt) {
        nbt.m_128344_("SkinColor", (byte)this.getColor().getIndex());
        nbt.m_128379_("IsContract", this.isContract());
        nbt.m_128359_("SkinTexture", this.getTextureHolder(IHasMultiModel.Layer.SKIN, IHasMultiModel.Part.HEAD).getTextureName());
        for (IHasMultiModel.Part part : IHasMultiModel.Part.values()) {
            nbt.m_128359_("ArmorTextureInner" + part.getPartName(), this.getTextureHolder(IHasMultiModel.Layer.INNER, part).getTextureName());
            nbt.m_128359_("ArmorTextureOuter" + part.getPartName(), this.getTextureHolder(IHasMultiModel.Layer.OUTER, part).getTextureName());
        }
    }

    public void readFromNbt(CompoundTag nbt) {
        if (nbt.m_128441_("SkinColor")) {
            this.setColor(TextureColors.getColor(nbt.m_128445_("SkinColor")));
        }
        this.setContract(nbt.m_128471_("IsContract"));
        LMTextureManager textureManager = LMTextureManager.INSTANCE;
        if (nbt.m_128441_("SkinTexture")) {
            textureManager.getTexture(nbt.m_128461_("SkinTexture")).ifPresent(textureHolder -> this.setTextureHolder((TextureHolder)textureHolder, IHasMultiModel.Layer.SKIN, IHasMultiModel.Part.HEAD));
        }
        for (IHasMultiModel.Part part : IHasMultiModel.Part.values()) {
            String inner = "ArmorTextureInner" + part.getPartName();
            String outer = "ArmorTextureOuter" + part.getPartName();
            if (nbt.m_128441_(inner)) {
                textureManager.getTexture(nbt.m_128461_(inner)).ifPresent(textureHolder -> this.setTextureHolder((TextureHolder)textureHolder, IHasMultiModel.Layer.INNER, part));
            }
            if (!nbt.m_128441_(outer)) continue;
            textureManager.getTexture(nbt.m_128461_(outer)).ifPresent(textureHolder -> this.setTextureHolder((TextureHolder)textureHolder, IHasMultiModel.Layer.OUTER, part));
        }
    }

    public void writeToPacket(FriendlyByteBuf packet) {
        packet.m_130068_((Enum)this.getColor());
        packet.writeBoolean(this.isContract());
        packet.m_130070_(this.getTextureHolder(IHasMultiModel.Layer.SKIN, IHasMultiModel.Part.HEAD).getTextureName());
        for (IHasMultiModel.Part part : IHasMultiModel.Part.values()) {
            packet.m_130070_(this.getTextureHolder(IHasMultiModel.Layer.INNER, part).getTextureName());
            packet.m_130070_(this.getTextureHolder(IHasMultiModel.Layer.OUTER, part).getTextureName());
        }
    }

    public void readFromPacket(FriendlyByteBuf packet) {
        this.setColor((TextureColors)packet.m_130066_(TextureColors.class));
        this.setContract(packet.readBoolean());
        LMTextureManager textureManager = LMTextureManager.INSTANCE;
        textureManager.getTexture(packet.m_130277_()).ifPresent(textureHolder -> this.setTextureHolder((TextureHolder)textureHolder, IHasMultiModel.Layer.SKIN, IHasMultiModel.Part.HEAD));
        for (IHasMultiModel.Part part : IHasMultiModel.Part.values()) {
            textureManager.getTexture(packet.m_130277_()).ifPresent(textureHolder -> this.setTextureHolder((TextureHolder)textureHolder, IHasMultiModel.Layer.INNER, part));
            textureManager.getTexture(packet.m_130277_()).ifPresent(textureHolder -> this.setTextureHolder((TextureHolder)textureHolder, IHasMultiModel.Layer.OUTER, part));
        }
    }
}

