/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidmodelloader.maidmodel;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.sistr.littlemaidmodelloader.maidmodel.ModelRenderer;
import net.sistr.littlemaidmodelloader.maidmodel.compat.GLCompat;

public abstract class ModelBoxBase {
    protected PositionTextureVertex[] vertexPositions;
    protected TexturedQuad[] quadList;
    public float posX1;
    public float posY1;
    public float posZ1;
    public float posX2;
    public float posY2;
    public float posZ2;
    public String boxName;

    public ModelBoxBase(ModelRenderer pMRenderer, Object ... pArg) {
    }

    public final void render(PoseStack matrices, VertexConsumer buffer, int light, int overlay, float red, float green, float blue, float alpha, float scale) {
        for (TexturedQuad texturedQuad : this.quadList) {
            texturedQuad.draw(matrices, buffer, light, overlay, red, green, blue, alpha, scale);
        }
    }

    public ModelBoxBase setBoxName(String pName) {
        this.boxName = pName;
        return this;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class TexturedQuad {
        public PositionTextureVertex[] vertexPositions;
        public int nVertices;
        private Vector3f normalCache;

        public TexturedQuad(PositionTextureVertex[] vertices) {
            this.vertexPositions = vertices;
            this.nVertices = vertices.length;
            this.normalCache = this.calcNormal();
        }

        public TexturedQuad(PositionTextureVertex[] vertices, int texcoordU1, int texcoordV1, int texcoordU2, int texcoordV2, float textureWidth, float textureHeight) {
            this(vertices);
            float f = 0.0f / textureWidth;
            float f1 = 0.0f / textureHeight;
            vertices[0] = vertices[0].setTexturePosition((float)texcoordU2 / textureWidth - f, (float)texcoordV1 / textureHeight + f1);
            vertices[1] = vertices[1].setTexturePosition((float)texcoordU1 / textureWidth + f, (float)texcoordV1 / textureHeight + f1);
            vertices[2] = vertices[2].setTexturePosition((float)texcoordU1 / textureWidth + f, (float)texcoordV2 / textureHeight - f1);
            vertices[3] = vertices[3].setTexturePosition((float)texcoordU2 / textureWidth - f, (float)texcoordV2 / textureHeight - f1);
        }

        public void flipFace() {
            PositionTextureVertex[] vertices = new PositionTextureVertex[this.vertexPositions.length];
            for (int i = 0; i < this.vertexPositions.length; ++i) {
                vertices[i] = this.vertexPositions[this.vertexPositions.length - i - 1];
            }
            this.vertexPositions = vertices;
            this.normalCache = this.calcNormal();
        }

        public final void draw(PoseStack matrices, VertexConsumer buffer, int light, int overlay, float red, float green, float blue, float alpha, float scale) {
            PoseStack.Pose entry = matrices.m_85850_();
            Matrix4f matrix4f = entry.m_85861_();
            Matrix3f matrix3f = entry.m_85864_();
            Vector3f normal = this.normalCache.m_122281_();
            normal.m_122249_(matrix3f);
            float normalX = normal.m_122239_();
            float normalY = normal.m_122260_();
            float normalZ = normal.m_122269_();
            for (int i = 0; i < 4; ++i) {
                PositionTextureVertex vertex = this.vertexPositions[i];
                float x = vertex.vector3D.m_122239_() * scale;
                float y = vertex.vector3D.m_122260_() * scale;
                float z = vertex.vector3D.m_122269_() * scale;
                Vector4f pos = new Vector4f(x, y, z, 1.0f);
                pos.m_123607_(matrix4f);
                if (pos.m_123617_() != 1.0f) {
                    pos.m_123621_();
                }
                Vector4f uv = new Vector4f(vertex.texturePositionX, vertex.texturePositionY, 0.0f, 1.0f);
                if (!GLCompat.textureStack.m_85851_()) {
                    uv.m_123607_(GLCompat.textureStack.m_85850_().m_85861_());
                }
                buffer.m_5954_(pos.m_123601_(), pos.m_123615_(), pos.m_123616_(), red, green, blue, alpha, uv.m_123601_(), uv.m_123615_(), overlay, light, normalX, normalY, normalZ);
            }
        }

        private Vector3f calcNormal() {
            Vector3f n1 = this.vertexPositions[0].vector3D.m_122281_();
            Vector3f n2 = this.vertexPositions[2].vector3D.m_122281_();
            n1.m_122267_(this.vertexPositions[1].vector3D);
            n2.m_122267_(this.vertexPositions[1].vector3D);
            n2.m_122279_(n1);
            n2.m_122278_();
            return n2;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class PositionTextureVertex {
        public Vector3f vector3D;
        public float texturePositionX;
        public float texturePositionY;

        public PositionTextureVertex(float x, float y, float z, float u, float v) {
            this(new Vector3f(x, y, z), u, v);
        }

        public PositionTextureVertex setTexturePosition(float u, float v) {
            return new PositionTextureVertex(this, u, v);
        }

        public PositionTextureVertex(PositionTextureVertex textureVertex, float texturePositionXIn, float texturePositionYIn) {
            this.vector3D = textureVertex.vector3D;
            this.texturePositionX = texturePositionXIn;
            this.texturePositionY = texturePositionYIn;
        }

        public PositionTextureVertex(Vector3f vec, float u, float v) {
            this.vector3D = vec;
            this.texturePositionX = u;
            this.texturePositionY = v;
        }
    }
}

