/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidmodelloader.maidmodel.compat;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.nio.FloatBuffer;
import net.minecraft.world.phys.Vec2;
import net.sistr.littlemaidmodelloader.maidmodel.ModelBoxBase;
import net.sistr.littlemaidmodelloader.maidmodel.ModelRenderer;

public final class GLCompat {
    public static int mode = 5888;
    public static ModelRenderer modelRenderer;
    public static PoseStack textureStack;
    private static int renderMode;
    private static ModelBoxBase.PositionTextureVertex vertexCurrent;
    private static ModelBoxBase.PositionTextureVertex vertexPrev1;
    private static ModelBoxBase.PositionTextureVertex vertexPrev2;
    private static Vector3f pos;
    private static Vec2 tex;

    public static void glPushMatrix() {
        if (mode == 5888) {
            ModelRenderer.matrixStack.m_85836_();
        } else if (mode == 5890) {
            textureStack.m_85836_();
        }
    }

    public static void glPopMatrix() {
        if (mode == 5888) {
            ModelRenderer.matrixStack.m_85849_();
        } else if (mode == 5890) {
            textureStack.m_85849_();
        }
    }

    public static void glTranslatef(float x, float y, float z) {
        if (mode == 5888) {
            ModelRenderer.matrixStack.m_85837_((double)x, (double)y, (double)z);
        } else if (mode == 5890) {
            textureStack.m_85837_((double)x, (double)y, (double)z);
        }
    }

    public static void glScalef(float x, float y, float z) {
        if (mode == 5888) {
            PoseStack.Pose entry = ModelRenderer.matrixStack.m_85850_();
            entry.m_85861_().m_27644_(Matrix4f.m_27632_((float)x, (float)y, (float)z));
        } else if (mode == 5890) {
            PoseStack.Pose entry = textureStack.m_85850_();
            entry.m_85861_().m_27644_(Matrix4f.m_27632_((float)x, (float)y, (float)z));
        }
    }

    public static void glRotatef(float deg, float x, float y, float z) {
        if (mode == 5888) {
            ModelRenderer.matrixStack.m_85845_(new Vector3f(x, y, z).m_122240_(deg));
        } else if (mode == 5890) {
            Matrix4f model = textureStack.m_85850_().m_85861_();
            model.m_27646_(new Vector3f(x, y, z).m_122240_(deg));
        }
    }

    public static void glColor3f(float red, float green, float blue) {
        ModelRenderer.red = red;
        ModelRenderer.green = green;
        ModelRenderer.blue = blue;
    }

    public static void glMatrixMode(int mode) {
        GLCompat.mode = mode;
    }

    public static void glGetFloat(int mode, FloatBuffer buf) {
        if (mode == 2982) {
            ModelRenderer.matrixStack.m_85850_().m_85861_().m_27650_(buf);
        }
    }

    public static void glLoadMatrix(FloatBuffer buf) {
        if (mode == 5888) {
            ModelRenderer.matrixStack.m_85850_().m_85861_().m_162212_(buf);
        } else if (mode == 5890) {
            textureStack.m_85850_().m_85861_().m_162212_(buf);
        }
    }

    public static void glMultMatrix(FloatBuffer buf) {
        if (mode == 5888) {
            Matrix4f matrix4f = new Matrix4f();
            matrix4f.m_162212_(buf);
            ModelRenderer.matrixStack.m_85850_().m_85861_().m_27644_(matrix4f);
        } else if (mode == 5890) {
            Matrix4f matrix4f = new Matrix4f();
            matrix4f.m_162212_(buf);
            textureStack.m_85850_().m_85861_().m_27644_(matrix4f);
        }
    }

    private static int pack(int x, int y) {
        return y * 4 + x;
    }

    public static void glCallList(int i) {
        for (ModelBoxBase boxBase : GLCompat.modelRenderer.cubeList) {
            boxBase.render(ModelRenderer.matrixStack, ModelRenderer.buffer, ModelRenderer.light, ModelRenderer.overlay, ModelRenderer.red, ModelRenderer.green, ModelRenderer.blue, ModelRenderer.alpha, GLCompat.modelRenderer.scale);
        }
    }

    public static void glLoadIdentity() {
        ModelRenderer.matrixStack.m_85850_().m_85861_().m_27624_();
    }

    public static void glBegin(int i) {
        if (i == 5) {
            renderMode = i;
        }
    }

    public static void glEnd() {
        if (renderMode == 5) {
            vertexCurrent = null;
            vertexPrev1 = null;
            vertexPrev2 = null;
            pos = null;
            tex = null;
        }
        renderMode = 0;
    }

    public static void glVertex3f(float x, float y, float z) {
        if (renderMode == 5) {
            pos = new Vector3f(x, y, z);
            GLCompat.combine();
        }
    }

    public static void glNormal3f(float f, float f2, float f3) {
    }

    public static void glTexCoord2f(float u, float v) {
        if (renderMode == 5) {
            tex = new Vec2(u, v);
            GLCompat.combine();
        }
    }

    private static void combine() {
        if (tex != null && pos != null) {
            vertexPrev2 = vertexPrev1;
            vertexPrev1 = vertexCurrent;
            vertexCurrent = new ModelBoxBase.PositionTextureVertex(pos, GLCompat.tex.f_82470_, GLCompat.tex.f_82471_);
            pos = null;
            tex = null;
            if (vertexPrev2 != null) {
                ModelBoxBase.TexturedQuad quad = new ModelBoxBase.TexturedQuad(new ModelBoxBase.PositionTextureVertex[]{vertexPrev2, vertexPrev1, vertexCurrent, vertexCurrent});
                quad.draw(ModelRenderer.matrixStack, ModelRenderer.buffer, ModelRenderer.light, ModelRenderer.overlay, ModelRenderer.red, ModelRenderer.green, ModelRenderer.blue, ModelRenderer.alpha, 1.0f);
            }
        }
    }

    public static void glPushAttrib(int i) {
    }

    public static void glPopAttrib() {
    }

    public static void glCullFace(int i) {
    }

    public static void glEnable(int i) {
    }

    public static void dummy() {
    }

    public static void dummy(int i) {
    }

    public static void dummy(float a, float b) {
    }

    public static void dummy(float a, float b, float c) {
    }

    public static void dummy(FloatBuffer f) {
    }

    public static void dummy(int i, FloatBuffer f) {
    }

    static {
        textureStack = new PoseStack();
    }
}

