/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidmodelloader.mixin;

import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.main.GameConfig;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.sistr.littlemaidmodelloader.resource.manager.LMTextureManager;
import net.sistr.littlemaidmodelloader.resource.util.ResourceHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={Minecraft.class})
public class MixinMinecraftClient {
    @Inject(at={@At(value="RETURN")}, method={"<init>"})
    public void onInit(GameConfig args, CallbackInfo ci) {
        MixinMinecraftClient.loadTexture();
    }

    private static void loadTexture() {
        Collection resourceLocations = Minecraft.m_91087_().m_91098_().m_6540_("textures/entity/littlemaid", s -> true);
        resourceLocations.forEach(resourcePath -> {
            String path = resourcePath.m_135815_();
            ResourceHelper.getTexturePackName(path, false).ifPresent(textureName -> {
                String modelName = ResourceHelper.getModelName(textureName);
                int index = ResourceHelper.getIndex(path);
                if (index != -1) {
                    LMTextureManager.INSTANCE.addTexture(ResourceHelper.getFileName(path, false), (String)textureName, modelName, index, (ResourceLocation)resourcePath);
                }
            });
        });
    }
}

