/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidmodelloader.network;

import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.sistr.littlemaidmodelloader.network.util.CustomPacketEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CustomMobSpawnPacket {
    public static final ResourceLocation ID = new ResourceLocation("littlemaidmodelloader", "custom_mob_spawn");
    public static final Logger LOGGER = LogManager.getLogger();

    public static Packet<?> createPacket(LivingEntity entity) {
        if (!(entity instanceof CustomPacketEntity)) {
            throw new IllegalStateException("CustomPacketEntity\u3092\u5b9f\u88c5\u3057\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.m_130130_(entity.m_142049_());
        buf.m_130077_(entity.m_142081_());
        buf.m_130130_(Registry.f_122826_.m_7447_((Object)entity.m_6095_()));
        buf.writeDouble(entity.m_20185_());
        buf.writeDouble(entity.m_20186_());
        buf.writeDouble(entity.m_20189_());
        buf.writeByte((int)(entity.m_146908_() * 256.0f / 360.0f));
        buf.writeByte((int)(entity.m_146909_() * 256.0f / 360.0f));
        buf.writeByte((int)(entity.f_20885_ * 256.0f / 360.0f));
        Vec3 vec3d = entity.m_20184_();
        int velocityX = (int)(Mth.m_14008_((double)vec3d.f_82479_, (double)-3.9, (double)3.9) * 8000.0);
        int velocityY = (int)(Mth.m_14008_((double)vec3d.f_82480_, (double)-3.9, (double)3.9) * 8000.0);
        int velocityZ = (int)(Mth.m_14008_((double)vec3d.f_82481_, (double)-3.9, (double)3.9) * 8000.0);
        buf.writeShort(velocityX);
        buf.writeShort(velocityY);
        buf.writeShort(velocityZ);
        ((CustomPacketEntity)entity).writeCustomPacket(buf);
        return NetworkManager.toPacket((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)ID, (FriendlyByteBuf)buf);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void receiveS2CPacket(FriendlyByteBuf buf, NetworkManager.PacketContext context) {
        int id = buf.m_130242_();
        UUID uuid = buf.m_130259_();
        int entityTypeId = buf.m_130242_();
        double x = buf.readDouble();
        double y = buf.readDouble();
        double z = buf.readDouble();
        float yaw = (float)buf.readByte() * 360.0f / 256.0f;
        float pitch = (float)buf.readByte() * 360.0f / 256.0f;
        float headYaw = (float)buf.readByte() * 360.0f / 256.0f;
        float velocityX = (float)buf.readShort() / 8000.0f;
        float velocityY = (float)buf.readShort() / 8000.0f;
        float velocityZ = (float)buf.readShort() / 8000.0f;
        FriendlyByteBuf additional = new FriendlyByteBuf(buf.copy());
        context.queue(() -> CustomMobSpawnPacket.spawn(id, uuid, entityTypeId, x, y, z, yaw, pitch, headYaw, velocityX, velocityY, velocityZ, additional));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void spawn(int id, UUID uuid, int entityTypeId, double x, double y, double z, float yaw, float pitch, float headYaw, float velocityX, float velocityY, float velocityZ, FriendlyByteBuf additional) {
        Minecraft client = Minecraft.m_91087_();
        ClientLevel world = client.f_91073_;
        if (world == null) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)EntityType.m_20589_((int)entityTypeId, (Level)world);
        if (livingEntity instanceof CustomPacketEntity) {
            livingEntity.m_20167_(x, y, z);
            livingEntity.f_20883_ = headYaw;
            livingEntity.f_20885_ = headYaw;
            livingEntity.m_20234_(id);
            livingEntity.m_20084_(uuid);
            livingEntity.m_19890_(x, y, z, yaw, pitch);
            livingEntity.m_20334_((double)velocityX, (double)velocityY, (double)velocityZ);
            ((CustomPacketEntity)livingEntity).readCustomPacket(additional);
            world.m_104627_(id, (Entity)livingEntity);
        } else {
            LOGGER.warn("Skipping Entity with id {}", (Object)entityTypeId);
        }
        if (additional.refCnt() > 0) {
            additional.release();
        }
    }
}

