/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidmodelloader.network;

import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.sistr.littlemaidmodelloader.entity.compound.IHasMultiModel;
import net.sistr.littlemaidmodelloader.resource.holder.TextureHolder;
import net.sistr.littlemaidmodelloader.resource.manager.LMTextureManager;
import net.sistr.littlemaidmodelloader.resource.util.ArmorSets;
import net.sistr.littlemaidmodelloader.resource.util.TextureColors;
import net.sistr.littlemaidmodelloader.util.PlayerList;

public class SyncMultiModelPacket {
    public static final ResourceLocation ID = new ResourceLocation("littlemaidmodelloader", "sync_multi_model");

    @OnlyIn(value=Dist.CLIENT)
    public static void sendC2SPacket(Entity entity, IHasMultiModel hasMultiModel) {
        FriendlyByteBuf passedData = SyncMultiModelPacket.createC2SPacket(entity, hasMultiModel);
        NetworkManager.sendToServer((ResourceLocation)ID, (FriendlyByteBuf)passedData);
    }

    public static FriendlyByteBuf createC2SPacket(Entity entity, IHasMultiModel hasMultiModel) {
        FriendlyByteBuf passedData = new FriendlyByteBuf(Unpooled.buffer());
        passedData.writeInt(entity.m_142049_());
        passedData.m_130070_(hasMultiModel.getTextureHolder(IHasMultiModel.Layer.SKIN, IHasMultiModel.Part.HEAD).getTextureName());
        for (IHasMultiModel.Part part : IHasMultiModel.Part.values()) {
            passedData.m_130070_(hasMultiModel.getTextureHolder(IHasMultiModel.Layer.INNER, part).getTextureName());
        }
        passedData.m_130068_((Enum)hasMultiModel.getColor());
        passedData.writeBoolean(hasMultiModel.isContract());
        return passedData;
    }

    public static void sendS2CPacket(Entity entity, IHasMultiModel hasMultiModel) {
        FriendlyByteBuf passedData = SyncMultiModelPacket.createS2CPacket(entity, hasMultiModel);
        PlayerList.tracking(entity).forEach(watchingPlayer -> NetworkManager.sendToPlayer((ServerPlayer)watchingPlayer, (ResourceLocation)ID, (FriendlyByteBuf)passedData));
    }

    public static FriendlyByteBuf createS2CPacket(Entity entity, IHasMultiModel hasMultiModel) {
        FriendlyByteBuf passedData = new FriendlyByteBuf(Unpooled.buffer());
        passedData.writeInt(entity.m_142049_());
        passedData.m_130070_(hasMultiModel.getTextureHolder(IHasMultiModel.Layer.SKIN, IHasMultiModel.Part.HEAD).getTextureName());
        for (IHasMultiModel.Part part : IHasMultiModel.Part.values()) {
            passedData.m_130070_(hasMultiModel.getTextureHolder(IHasMultiModel.Layer.INNER, part).getTextureName());
        }
        passedData.m_130068_((Enum)hasMultiModel.getColor());
        passedData.writeBoolean(hasMultiModel.isContract());
        return passedData;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void receiveS2CPacket(FriendlyByteBuf buf, NetworkManager.PacketContext context) {
        int entityId = buf.readInt();
        String textureName = buf.m_130277_();
        ArmorSets<String> armorTextureName = new ArmorSets<String>();
        for (IHasMultiModel.Part part : IHasMultiModel.Part.values()) {
            armorTextureName.setArmor(buf.m_130277_(), part);
        }
        TextureColors color = (TextureColors)buf.m_130066_(TextureColors.class);
        boolean isContract = buf.readBoolean();
        context.queue(() -> SyncMultiModelPacket.applyMultiModelClient(entityId, isContract, color, textureName, armorTextureName));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void applyMultiModelClient(int entityId, boolean isContract, TextureColors color, String textureName, ArmorSets<String> armorTextureName) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world == null) {
            return;
        }
        Entity entity = world.m_6815_(entityId);
        if (!(entity instanceof IHasMultiModel)) {
            return;
        }
        IHasMultiModel multiModel = (IHasMultiModel)entity;
        multiModel.setContract(isContract);
        multiModel.setColor(color);
        LMTextureManager textureManager = LMTextureManager.INSTANCE;
        textureManager.getTexture(textureName).filter(textureHolder -> multiModel.isAllowChangeTexture(entity, (TextureHolder)textureHolder, IHasMultiModel.Layer.SKIN, IHasMultiModel.Part.HEAD)).ifPresent(textureHolder -> multiModel.setTextureHolder((TextureHolder)textureHolder, IHasMultiModel.Layer.SKIN, IHasMultiModel.Part.HEAD));
        for (IHasMultiModel.Part part : IHasMultiModel.Part.values()) {
            String armorName = armorTextureName.getArmor(part).orElseThrow(() -> new IllegalStateException("\u30c6\u30af\u30b9\u30c1\u30e3\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002"));
            textureManager.getTexture(armorName).filter(textureHolder -> multiModel.isAllowChangeTexture(entity, (TextureHolder)textureHolder, IHasMultiModel.Layer.INNER, part)).ifPresent(textureHolder -> multiModel.setTextureHolder((TextureHolder)textureHolder, IHasMultiModel.Layer.INNER, part));
        }
    }

    public static void receiveC2SPacket(FriendlyByteBuf buf, NetworkManager.PacketContext context) {
        int entityId = buf.readInt();
        String textureName = buf.m_130136_(Short.MAX_VALUE);
        ArmorSets<String> armorTextureName = new ArmorSets<String>();
        for (IHasMultiModel.Part part : IHasMultiModel.Part.values()) {
            armorTextureName.setArmor(buf.m_130136_(Short.MAX_VALUE), part);
        }
        TextureColors color = (TextureColors)buf.m_130066_(TextureColors.class);
        boolean isContract = buf.readBoolean();
        context.queue(() -> SyncMultiModelPacket.applyMultiModelServer(context.getPlayer(), entityId, isContract, color, textureName, armorTextureName));
    }

    public static void applyMultiModelServer(Player player, int entityId, boolean isContract, TextureColors color, String textureName, ArmorSets<String> armorTextureName) {
        Entity entity = player.f_19853_.m_6815_(entityId);
        if (!(entity instanceof IHasMultiModel)) {
            return;
        }
        IHasMultiModel multiModel = (IHasMultiModel)entity;
        multiModel.setContract(isContract);
        multiModel.setColor(color);
        LMTextureManager textureManager = LMTextureManager.INSTANCE;
        textureManager.getTexture(textureName).filter(textureHolder -> multiModel.isAllowChangeTexture(entity, (TextureHolder)textureHolder, IHasMultiModel.Layer.SKIN, IHasMultiModel.Part.HEAD)).ifPresent(textureHolder -> multiModel.setTextureHolder((TextureHolder)textureHolder, IHasMultiModel.Layer.SKIN, IHasMultiModel.Part.HEAD));
        for (IHasMultiModel.Part part : IHasMultiModel.Part.values()) {
            String armorName = armorTextureName.getArmor(part).orElseThrow(() -> new IllegalStateException("\u30c6\u30af\u30b9\u30c1\u30e3\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002"));
            textureManager.getTexture(armorName).filter(textureHolder -> multiModel.isAllowChangeTexture(entity, (TextureHolder)textureHolder, IHasMultiModel.Layer.INNER, part)).ifPresent(textureHolder -> multiModel.setTextureHolder((TextureHolder)textureHolder, IHasMultiModel.Layer.INNER, part));
        }
        SyncMultiModelPacket.sendS2CPacket(entity, multiModel);
    }
}

