/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidmodelloader.network;

import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.sistr.littlemaidmodelloader.entity.compound.SoundPlayable;
import net.sistr.littlemaidmodelloader.resource.holder.ConfigHolder;
import net.sistr.littlemaidmodelloader.resource.manager.LMConfigManager;
import net.sistr.littlemaidmodelloader.util.PlayerList;

public class SyncSoundPackPacket {
    public static final ResourceLocation ID = new ResourceLocation("littlemaidmodelloader", "sync_sound_pack");

    @OnlyIn(value=Dist.CLIENT)
    public static void sendC2SPacket(Entity entity, ConfigHolder configHolder) {
        FriendlyByteBuf passedData = SyncSoundPackPacket.createC2SPacket(entity, configHolder);
        NetworkManager.sendToServer((ResourceLocation)ID, (FriendlyByteBuf)passedData);
    }

    public static FriendlyByteBuf createC2SPacket(Entity entity, ConfigHolder configHolder) {
        FriendlyByteBuf passedData = new FriendlyByteBuf(Unpooled.buffer());
        passedData.writeInt(entity.m_142049_());
        passedData.m_130070_(configHolder.getName());
        return passedData;
    }

    public static void sendS2CPacket(Entity entity, ConfigHolder configHolder) {
        FriendlyByteBuf passedData = SyncSoundPackPacket.createS2CPacket(entity, configHolder);
        PlayerList.tracking(entity).forEach(watchingPlayer -> NetworkManager.sendToPlayer((ServerPlayer)watchingPlayer, (ResourceLocation)ID, (FriendlyByteBuf)passedData));
    }

    public static FriendlyByteBuf createS2CPacket(Entity entity, ConfigHolder configHolder) {
        FriendlyByteBuf passedData = new FriendlyByteBuf(Unpooled.buffer());
        passedData.writeInt(entity.m_142049_());
        passedData.m_130070_(configHolder.getName());
        return passedData;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void receiveS2CPacket(FriendlyByteBuf buf, NetworkManager.PacketContext context) {
        int entityId = buf.readInt();
        String soundPackName = buf.m_130277_();
        context.queue(() -> SyncSoundPackPacket.applyMultiModelClient(entityId, soundPackName));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void applyMultiModelClient(int entityId, String soundPackName) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world == null) {
            return;
        }
        Entity entity = world.m_6815_(entityId);
        if (!(entity instanceof SoundPlayable)) {
            return;
        }
        SoundPlayable soundPlayable = (SoundPlayable)entity;
        ConfigHolder configHolder = LMConfigManager.INSTANCE.getConfig(soundPackName).orElse(LMConfigManager.EMPTY_CONFIG);
        soundPlayable.setConfigHolder(configHolder);
    }

    public static void receiveC2SPacket(FriendlyByteBuf buf, NetworkManager.PacketContext context) {
        int entityId = buf.readInt();
        String soundPackName = buf.m_130277_();
        context.queue(() -> SyncSoundPackPacket.applyMultiModelServer(context.getPlayer(), entityId, soundPackName));
    }

    public static void applyMultiModelServer(Player player, int entityId, String soundPackName) {
        Entity entity = player.f_19853_.m_6815_(entityId);
        if (!(entity instanceof SoundPlayable)) {
            return;
        }
        SoundPlayable soundPlayable = (SoundPlayable)entity;
        ConfigHolder configHolder = LMConfigManager.INSTANCE.getConfig(soundPackName).orElse(LMConfigManager.EMPTY_CONFIG);
        soundPlayable.setConfigHolder(configHolder);
        SyncSoundPackPacket.sendS2CPacket(entity, configHolder);
    }
}

