/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidmodelloader.resource.classloader;

import dev.architectury.platform.Platform;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MultiANewArrayInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;

public class MultiModelClassTransformer {
    private static final String PACKAGE_STRING = "net/sistr/littlemaidmodelloader/maidmodel/";
    private static final Map<String, String> CODE_REPLACE_MAP = new Object2ObjectOpenHashMap<String, String>(){
        {
            String caps = "firis/lmmm/api/caps/";
            this.addTransformTarget("IModelCaps");
            this.addTransformTarget("IModelCaps", caps);
            this.put("mmmlibx/lib/MMM_EntityCaps", "net/sistr/littlemaidmodelloader/maidmodel/EntityCaps");
            this.put("littleMaidMobX/EntityCaps", "net/sistr/littlemaidmodelloader/maidmodel/EntityCaps");
            this.put("net/blacklab/lmr/util/EntityCaps", "net/sistr/littlemaidmodelloader/maidmodel/EntityCaps");
            this.put("net/blacklab/lmr/util/EntityCapsLiving", "net/sistr/littlemaidmodelloader/maidmodel/EntityCaps");
            this.addTransformTarget("ModelCapsHelper");
            this.addTransformTarget("ModelCapsHelper", caps);
            String renderer = "firis/lmmm/api/renderer/";
            this.addTransformTarget("ModelRenderer");
            this.addTransformTarget("ModelRenderer", renderer);
            String modelParts = "firis/lmmm/api/model/parts/";
            this.addTransformTarget("ModelBoxBase");
            this.addTransformTarget("ModelBoxBase", modelParts);
            this.addTransformTarget("ModelBox");
            this.addTransformTarget("ModelBox", modelParts);
            this.addTransformTarget("ModelPlate");
            this.addTransformTarget("ModelPlate", modelParts);
            String builtinModel = "firis/lmmm/builtin/model/";
            this.addTransformTarget("ModelLittleMaid_Aug");
            this.addTransformTarget("ModelLittleMaid_Aug", builtinModel);
            this.addTransformTarget("ModelLittleMaid_SR2");
            this.addTransformTarget("ModelLittleMaid_SR2", builtinModel);
            this.addTransformTarget("ModelLittleMaid_Orign");
            this.addTransformTarget("ModelLittleMaid_Orign", builtinModel);
            this.addTransformTarget("ModelLittleMaid_Archetype");
            this.addTransformTarget("ModelLittleMaid_Archetype", builtinModel);
            String model = "firis/lmmm/api/model/";
            this.addTransformTarget("ModelLittleMaidBase");
            this.addTransformTarget("ModelLittleMaidBase", model);
            this.addTransformTarget("ModelMultiMMMBase");
            this.addTransformTarget("ModelMultiMMMBase", model);
            this.addTransformTarget("ModelMultiBase");
            this.addTransformTarget("ModelMultiBase", model);
            this.addTransformTarget("ModelBase");
            this.addTransformTarget("ModelBase", model);
            this.put("net/blacklab/lmr/entity/EntityLittleMaid", "net/sistr/littlemaidmodelloader/entity/EntityLittleMaid");
            this.put("net/minecraft/entity/EntityLivingBase", "net/minecraft/entity/LivingEntity");
            this.put("net/minecraft/entity/passive/EntityAnimal", "net/minecraft/entity/passive/AnimalEntity");
            this.put("net/minecraft/entity/player/EntityPlayer", "net/minecraft/entity/player/PlayerEntity");
            this.put("net/blacklab/lmr/entity/littlemaid/EntityLittleMaid", "net/sistr/littlemaidmodelloader/entity/EntityLittleMaid");
            if (!Platform.isDevelopmentEnvironment()) {
                if (Platform.isFabric()) {
                    this.put("net/minecraft/entity/Entity", "net/minecraft/class_1297");
                } else {
                    this.put("net/minecraft/entity/Entity", "net/minecraft/world/entity/Entity");
                }
            }
        }

        private void addTransformTarget(String className) {
            this.put("MMM_" + className, MultiModelClassTransformer.PACKAGE_STRING + className);
            this.put("mmmlibx/lib/multiModel/model/mc162/" + className, MultiModelClassTransformer.PACKAGE_STRING + className);
            this.put("net/blacklab/lmr/entity/maidmodel/" + className, MultiModelClassTransformer.PACKAGE_STRING + className);
        }

        private void addTransformTarget(String className, String oldPackage) {
            this.put(oldPackage + className, MultiModelClassTransformer.PACKAGE_STRING + className);
        }
    };
    private static final Set<String> GL_REPLACE_MODEL_RENDERER_SET = new ObjectOpenHashSet<String>(){
        {
            this.add("glPushMatrix()V");
            this.add("glPopMatrix()V");
            this.add("glTranslatef(FFF)V");
            this.add("glScalef(FFF)V");
            this.add("glRotatef(FFFF)V");
            this.add("glColor3f(FFF)V");
            this.add("glMatrixMode(I)V");
            this.add("glGetFloat(ILjava/nio/FloatBuffer;)V");
            this.add("glLoadMatrix(Ljava/nio/FloatBuffer;)V");
            this.add("glMultMatrix(Ljava/nio/FloatBuffer;)V");
            this.add("glCallList(I)V");
            this.add("glEnable(I)V");
            this.add("glTexCoord2f(FF)V");
            this.add("glNormal3f(FFF)V");
            this.add("glVertex3f(FFF)V");
            this.add("glPushAttrib(I)V");
            this.add("glCullFace(I)V");
            this.add("glBegin(I)V");
            this.add("glEnd()V");
            this.add("glPopAttrib()V");
            this.add("glLoadIdentity()V");
            this.add("");
        }
    };
    private static final Set<String> GL_REPLACE_DUMMY_SET = new ObjectOpenHashSet<String>(){
        {
            this.add("()V");
            this.add("(I)V");
            this.add("(FF)V");
            this.add("(FFF)V");
            this.add("(Ljava/nio/FloatBuffer;)V");
            this.add("(ILjava/nio/FloatBuffer;)V");
        }
    };

    public byte[] transform(byte[] basicClass) {
        ClassReader reader = new ClassReader(basicClass);
        ClassNode cNode = new ClassNode();
        reader.accept((ClassVisitor)cNode, 0);
        AtomicBoolean changed = new AtomicBoolean(false);
        this.tryReplace(changed, cNode.superName, superName -> {
            cNode.superName = superName;
        });
        cNode.fields.parallelStream().forEach(fNode -> this.tryReplace(changed, fNode.desc, desc -> {
            fNode.desc = desc;
        }));
        cNode.methods.parallelStream().forEach(mNode -> {
            this.tryReplace(changed, mNode.desc, desc -> {
                mNode.desc = desc;
            });
            if (mNode.localVariables != null) {
                mNode.localVariables.parallelStream().forEach(lNode -> {
                    if (lNode.desc != null) {
                        this.tryReplace(changed, lNode.desc, desc -> {
                            lNode.desc = desc;
                        });
                    }
                    if (lNode.name != null) {
                        this.tryReplace(changed, lNode.name, name -> {
                            lNode.name = name;
                        });
                    }
                    if (lNode.signature != null) {
                        this.tryReplace(changed, lNode.signature, signature -> {
                            lNode.signature = signature;
                        });
                    }
                });
            }
            AbstractInsnNode aNode = mNode.instructions.getFirst();
            while (aNode != null) {
                if (aNode instanceof FieldInsnNode) {
                    fANode = (FieldInsnNode)aNode;
                    this.tryReplace(changed, fANode.desc, desc -> {
                        fANode.desc = desc;
                    });
                    this.tryReplace(changed, fANode.name, name -> {
                        fANode.name = name;
                    });
                    this.tryReplace(changed, fANode.owner, owner -> {
                        fANode.owner = owner;
                    });
                } else if (aNode instanceof InvokeDynamicInsnNode) {
                    fANode = (InvokeDynamicInsnNode)aNode;
                    this.tryReplace(changed, fANode.desc, arg_0 -> MultiModelClassTransformer.lambda$transform$11((InvokeDynamicInsnNode)fANode, arg_0));
                    this.tryReplace(changed, fANode.name, arg_0 -> MultiModelClassTransformer.lambda$transform$12((InvokeDynamicInsnNode)fANode, arg_0));
                } else if (aNode instanceof MethodInsnNode) {
                    fANode = (MethodInsnNode)aNode;
                    if (this.shouldRemove(fANode.owner)) {
                        changed.set(true);
                        aNode = aNode.getNext();
                        if (GL_REPLACE_MODEL_RENDERER_SET.contains(fANode.name + fANode.desc)) {
                            mNode.instructions.set((AbstractInsnNode)fANode, (AbstractInsnNode)new MethodInsnNode(fANode.getOpcode(), "net/sistr/littlemaidmodelloader/maidmodel/compat/GLCompat", fANode.name, fANode.desc));
                            continue;
                        }
                        if (GL_REPLACE_DUMMY_SET.contains(fANode.desc)) {
                            mNode.instructions.set((AbstractInsnNode)fANode, (AbstractInsnNode)new MethodInsnNode(fANode.getOpcode(), "net/sistr/littlemaidmodelloader/maidmodel/compat/GLCompat", "dummy", fANode.desc));
                            continue;
                        }
                        mNode.instructions.set((AbstractInsnNode)fANode, (AbstractInsnNode)new MethodInsnNode(fANode.getOpcode(), "net/sistr/littlemaidmodelloader/maidmodel/compat/GLCompat", "dummy", "()V"));
                        continue;
                    }
                    this.tryReplace(changed, fANode.desc, arg_0 -> MultiModelClassTransformer.lambda$transform$13((MethodInsnNode)fANode, arg_0));
                    this.tryReplace(changed, fANode.name, arg_0 -> MultiModelClassTransformer.lambda$transform$14((MethodInsnNode)fANode, arg_0));
                    this.tryReplace(changed, fANode.owner, arg_0 -> MultiModelClassTransformer.lambda$transform$15((MethodInsnNode)fANode, arg_0));
                } else if (aNode instanceof MultiANewArrayInsnNode) {
                    fANode = (MultiANewArrayInsnNode)aNode;
                    this.tryReplace(changed, fANode.desc, arg_0 -> MultiModelClassTransformer.lambda$transform$16((MultiANewArrayInsnNode)fANode, arg_0));
                } else if (aNode instanceof TypeInsnNode) {
                    fANode = (TypeInsnNode)aNode;
                    this.tryReplace(changed, fANode.desc, arg_0 -> MultiModelClassTransformer.lambda$transform$17((TypeInsnNode)fANode, arg_0));
                } else if (aNode instanceof LdcInsnNode && ((LdcInsnNode)aNode).cst instanceof Type) {
                    fANode = (LdcInsnNode)aNode;
                    this.tryReplace(changed, ((Type)fANode.cst).getInternalName(), arg_0 -> MultiModelClassTransformer.lambda$transform$18((LdcInsnNode)fANode, arg_0));
                }
                aNode = aNode.getNext();
            }
        });
        if (changed.get()) {
            ClassWriter writer = new ClassWriter(3);
            cNode.accept((ClassVisitor)writer);
            return writer.toByteArray();
        }
        return basicClass;
    }

    private void tryReplace(AtomicBoolean changed, String text, Consumer<String> replacer) {
        String newText = null;
        for (Map.Entry<String, String> entry : CODE_REPLACE_MAP.entrySet()) {
            if (!(text + ";").contains(entry.getKey() + ";")) continue;
            newText = text = text.replace(entry.getKey(), entry.getValue());
        }
        if (newText != null) {
            changed.set(true);
            replacer.accept(newText);
        }
    }

    private boolean shouldRemove(String text) {
        return text.endsWith("GL11");
    }

    private static /* synthetic */ void lambda$transform$18(LdcInsnNode fANode, String desc) {
        fANode.cst = Type.getObjectType((String)desc);
    }

    private static /* synthetic */ void lambda$transform$17(TypeInsnNode fANode, String desc) {
        fANode.desc = desc;
    }

    private static /* synthetic */ void lambda$transform$16(MultiANewArrayInsnNode fANode, String desc) {
        fANode.desc = desc;
    }

    private static /* synthetic */ void lambda$transform$15(MethodInsnNode fANode, String owner) {
        fANode.owner = owner;
    }

    private static /* synthetic */ void lambda$transform$14(MethodInsnNode fANode, String name) {
        fANode.name = name;
    }

    private static /* synthetic */ void lambda$transform$13(MethodInsnNode fANode, String desc) {
        fANode.desc = desc;
    }

    private static /* synthetic */ void lambda$transform$12(InvokeDynamicInsnNode fANode, String name) {
        fANode.name = name;
    }

    private static /* synthetic */ void lambda$transform$11(InvokeDynamicInsnNode fANode, String desc) {
        fANode.desc = desc;
    }
}

