/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidmodelloader.resource.loader;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import net.sistr.littlemaidmodelloader.config.LMMLConfig;
import net.sistr.littlemaidmodelloader.resource.loader.LMLoader;
import net.sistr.littlemaidmodelloader.resource.manager.LMConfigManager;
import net.sistr.littlemaidmodelloader.resource.util.ResourceHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LMConfigLoader
implements LMLoader {
    private static final Logger LOGGER = LogManager.getLogger();
    private final LMConfigManager configManager;

    public LMConfigLoader(LMConfigManager configManager) {
        this.configManager = configManager;
    }

    @Override
    public boolean canLoad(String path, Path homePath, InputStream inputStream, boolean isArchive) {
        return path.endsWith(".cfg");
    }

    @Override
    public void load(String path, Path homePath, InputStream inputStream, boolean isArchive) {
        HashMap<String, String> settings = new HashMap<String, String>();
        try {
            this.getTextStream(inputStream).forEach(s -> this.addSettings((Map<String, String>)settings, (String)s));
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        String packName = ResourceHelper.getFirstParentName(path, homePath, isArchive).orElse("");
        String parentName = ResourceHelper.getParentFolderName(path, isArchive).orElse("");
        String fileName = ResourceHelper.getFileName(path, isArchive);
        fileName = ResourceHelper.removeExtension(fileName);
        this.configManager.addConfig(packName, parentName, fileName, settings);
        if (LMMLConfig.isDebugMode()) {
            LOGGER.debug("Loaded Config : " + packName + "." + parentName + "." + fileName + " : Total " + settings.size());
        }
    }

    public void addSettings(Map<String, String> settings, String text) {
        int firstSplitter;
        int firstComment = text.indexOf(35);
        if (firstComment != -1) {
            text = text.substring(0, firstComment);
        }
        if ((firstSplitter = text.indexOf(61)) == -1) {
            return;
        }
        String firstText = text.substring(0, firstSplitter);
        String secondText = text.substring(firstSplitter + 1);
        settings.put(firstText.toLowerCase(), secondText.toLowerCase());
    }

    public Stream<String> getTextStream(InputStream inputStream) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        return reader.lines();
    }
}

