/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidmodelloader.resource.loader;

import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.sistr.littlemaidmodelloader.resource.loader.LMLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LMFileLoader {
    public static final LMFileLoader INSTANCE = new LMFileLoader();
    private static final Logger LOGGER = LogManager.getLogger();
    private final ArrayList<LMLoader> loaders = new ArrayList();
    private final ArrayList<Path> folderPaths = new ArrayList();

    public void addLoader(LMLoader loader) {
        this.loaders.add(loader);
    }

    public void addLoadFolderPath(Path path) {
        if (Files.notExists(path, new LinkOption[0])) {
            try {
                Files.createDirectory(path, new FileAttribute[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
        this.folderPaths.add(path);
    }

    public ArrayList<Path> getFolderPaths() {
        return this.folderPaths;
    }

    public void load() {
        long start = System.nanoTime();
        LOGGER.debug("Loading start");
        this.folderPaths.forEach(folderPath -> {
            try {
                if (Files.notExists(folderPath, new LinkOption[0])) {
                    Files.createDirectory(folderPath, new FileAttribute[0]);
                }
                Files.walk(folderPath, new FileVisitOption[0]).filter(path -> !Files.isDirectory(path, new LinkOption[0])).forEach(path -> this.fileLoad((Path)folderPath, (Path)path));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        long end = System.nanoTime();
        LOGGER.debug("Loading end : " + (double)(end - start) / 1000000.0 + "ms");
    }

    private void fileLoad(Path folderPath, Path path) {
        if (this.isArchive(path)) {
            this.loadArchive(folderPath, path);
        } else {
            this.loadFile(folderPath, path);
        }
    }

    public void loadArchive(Path folderPath, Path path) {
        ZipInputStream zipStream;
        try {
            zipStream = new ZipInputStream(Files.newInputStream(path, new OpenOption[0]));
        }
        catch (Exception e) {
            LOGGER.debug("Can't load Zip! : " + path);
            e.printStackTrace();
            return;
        }
        try {
            ZipEntry entry;
            while ((entry = zipStream.getNextEntry()) != null) {
                ZipEntry finalEntry = entry;
                this.loaders.stream().filter(loader -> loader.canLoad(finalEntry.getName(), path, zipStream, true)).forEach(loader -> loader.load(finalEntry.getName(), path, zipStream, true));
            }
        }
        catch (Exception e) {
            LOGGER.debug("Zip\u306e\u8aad\u307f\u8fbc\u307f\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3002\u30d5\u30a1\u30a4\u30eb\u30cd\u30fc\u30e0\u306b\u65e5\u672c\u8a9e\u306a\u3069\u304c\u5165\u3063\u3066\u308b\u3068\u8aad\u307f\u8fbc\u3081\u307e\u305b\u3093\u3002An error occurs while reading a Zip file. If the file name contains Japanese characters, it cannot be read. : " + path);
            e.printStackTrace();
        }
    }

    public void loadFile(Path folderPath, Path path) {
        try {
            String relPath = path.toString().replace(folderPath.toString(), "");
            InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);
            this.loaders.stream().filter(loader -> loader.canLoad(relPath, folderPath, inputStream, false)).forEach(loader -> loader.load(relPath, folderPath, inputStream, false));
        }
        catch (Exception e) {
            LOGGER.debug("Error! : " + e.getMessage() + " : " + path);
        }
    }

    public boolean isArchive(Path path) {
        return path.toString().endsWith("zip") || path.toString().endsWith("jar");
    }
}

