/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidmodelloader.resource.loader;

import java.io.InputStream;
import java.nio.file.Path;
import net.sistr.littlemaidmodelloader.LittleMaidModelLoader;
import net.sistr.littlemaidmodelloader.config.LMMLConfig;
import net.sistr.littlemaidmodelloader.maidmodel.ModelMultiBase;
import net.sistr.littlemaidmodelloader.resource.loader.LMLoader;
import net.sistr.littlemaidmodelloader.resource.manager.LMModelManager;

public class LMMultiModelLoader
implements LMLoader {
    private final LMModelManager modelManager;
    private final ClassLoader classLoader;

    public LMMultiModelLoader(LMModelManager modelManager, ClassLoader classLoader) {
        this.modelManager = modelManager;
        this.classLoader = classLoader;
    }

    @Override
    public boolean canLoad(String path, Path homePath, InputStream inputStream, boolean isArchive) {
        return path.endsWith(".class") && (path.contains("ModelMulti_") || path.contains("ModelLittleMaid_"));
    }

    @Override
    public void load(String path, Path homePath, InputStream inputStream, boolean isArchive) {
        block2: {
            String classpath = path.replace("/", ".");
            classpath = classpath.substring(0, path.lastIndexOf(".class"));
            try {
                this.tryAddModel(classpath, this.classForName(classpath));
            }
            catch (Exception e) {
                LittleMaidModelLoader.LOGGER.error("\u8aad\u307f\u8fbc\u3081\u307e\u305b\u3093\u3067\u3057\u305f\u3002\u53e4\u3044\u30e2\u30c7\u30eb\u306e\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059 : " + path);
                if (!LMMLConfig.isDebugMode()) break block2;
                e.printStackTrace();
            }
        }
    }

    private void tryAddModel(String classpath, Class<?> modelClass) {
        if (modelClass != null && ModelMultiBase.class.isAssignableFrom(modelClass)) {
            int lastSplitter = classpath.lastIndexOf("_");
            if (lastSplitter == -1) {
                return;
            }
            String className = classpath.toLowerCase().substring(lastSplitter + 1);
            this.modelManager.addModel(className, modelClass);
        }
    }

    public Class<?> classForName(String className) throws ClassNotFoundException {
        try {
            return Class.forName(className, true, this.classLoader);
        }
        catch (Error e) {
            throw new ClassNotFoundException(className + ":classForName_Error:[" + e + "]");
        }
    }
}

