/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidmodelloader.resource.manager;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.sistr.littlemaidmodelloader.config.LMMLConfig;
import net.sistr.littlemaidmodelloader.entity.compound.IHasMultiModel;
import net.sistr.littlemaidmodelloader.maidmodel.ModelMultiBase;
import net.sistr.littlemaidmodelloader.multimodel.IMultiModel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LMModelManager {
    public static final LMModelManager INSTANCE = new LMModelManager();
    private static final Logger LOGGER = LogManager.getLogger();
    private IMultiModel defaultModel;
    private final Map<String, ModelHolder> models = new HashMap<String, ModelHolder>();

    public void addModel(String modelName, Class<? extends ModelMultiBase> modelClass) {
        try {
            Constructor<? extends ModelMultiBase> constructor = modelClass.getConstructor(Float.TYPE);
            ModelMultiBase skin = constructor.newInstance(Float.valueOf(0.0f));
            float[] size = skin.getArmorModelsSize();
            ModelMultiBase inner = constructor.newInstance(Float.valueOf(size[0]));
            ModelMultiBase outer = constructor.newInstance(Float.valueOf(size[1]));
            this.models.put(modelName.toLowerCase(), new ModelHolder(skin, inner, outer));
        }
        catch (Exception e) {
            LOGGER.debug("\u30a4\u30f3\u30b9\u30bf\u30f3\u30b9\u5316\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\u62bd\u8c61\u30af\u30e9\u30b9\u307e\u305f\u306f\u975e\u5bfe\u5fdc\u306e\u30e2\u30c7\u30eb\u3067\u3042\u308b\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002 : " + modelClass);
            e.printStackTrace();
            return;
        }
        if (LMMLConfig.isDebugMode()) {
            LOGGER.debug("Loaded Model : " + modelClass);
        }
    }

    public void addModel(String modelName, IMultiModel skin, IMultiModel inner, IMultiModel outer) {
        this.models.put(modelName.toLowerCase(), new ModelHolder(skin, inner, outer));
    }

    public boolean hasModel(String modelName) {
        return this.models.get(modelName.toLowerCase()) != null;
    }

    public Optional<IMultiModel> getModel(String modelName, IHasMultiModel.Layer layer) {
        ModelHolder modelHolder = this.models.get(modelName.toLowerCase());
        if (modelHolder == null) {
            return Optional.empty();
        }
        IMultiModel model = modelHolder.getModel(layer);
        return Optional.of(model);
    }

    public IMultiModel getOrDefaultModel(String modelName, IHasMultiModel.Layer layer) {
        ModelHolder modelHolder = this.models.get(modelName.toLowerCase());
        if (modelHolder == null) {
            return this.getDefaultModel();
        }
        return modelHolder.getModel(layer);
    }

    public void setDefaultModel(IMultiModel defaultModel) {
        this.defaultModel = defaultModel;
    }

    public IMultiModel getDefaultModel() {
        return this.defaultModel;
    }

    public static class ModelHolder {
        private final IMultiModel skin;
        private final IMultiModel inner;
        private final IMultiModel outer;

        public ModelHolder(IMultiModel skin, IMultiModel inner, IMultiModel outer) {
            this.skin = skin;
            this.inner = inner;
            this.outer = outer;
            if (skin == null || inner == null || outer == null) {
                throw new IllegalArgumentException("ModelHolder\u306fnull\u4e0d\u8a31\u5bb9\u3067\u3059");
            }
        }

        public IMultiModel getModel(IHasMultiModel.Layer layer) {
            switch (layer) {
                case SKIN: {
                    return this.skin;
                }
                case INNER: {
                    return this.inner;
                }
                case OUTER: {
                    return this.outer;
                }
            }
            throw new IllegalStateException();
        }
    }
}

