/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.scalar.mineall;

import com.electronwill.nightconfig.core.file.FileConfig;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.scalar.mineall.ModProperty;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModConfig {
    private static final Logger LOGGER = LogManager.getLogger();
    private static Class<?> _cls = null;
    private static List<AbstractMap.SimpleEntry<Field, ForgeConfigSpec.ConfigValue<?>>> mapConfigFields = new ArrayList();
    static ForgeConfigSpec modConfigSpec = null;
    public static ModConfig modconfigInstance = null;
    private static FileConfig _config = null;
    private static volatile boolean _changed = false;
    private static volatile long _lastModified = -1L;
    private static long _lastCheck = System.currentTimeMillis();
    private static final long _checkInterval = 500L;

    public static void configure(Class<?> cls, IEventBus modEventBus) {
        _cls = cls;
        Pair specPair = new ForgeConfigSpec.Builder().configure(ModConfig::new);
        modConfigSpec = (ForgeConfigSpec)specPair.getRight();
        modconfigInstance = (ModConfig)specPair.getLeft();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)modConfigSpec);
        modEventBus.register(ModConfig.class);
    }

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading configEvent) {
        LOGGER.info("{}::onLoad file:{}", (Object)ModConfig.class.getCanonicalName(), (Object)configEvent.getConfig().getFullPath());
        if (configEvent.getConfig().getConfigData() instanceof FileConfig) {
            _config = (FileConfig)configEvent.getConfig().getConfigData();
        }
        ModConfig.setFieldsFromConfig();
        _changed = true;
    }

    @SubscribeEvent
    public static void onFileChange(ModConfigEvent.Reloading configEvent) {
        configEvent.setResult(Event.Result.ALLOW);
        ModConfig.onFileChange();
    }

    private static void onFileChange() {
        if (null != _config) {
            _lastModified = _config.getFile().lastModified();
            _config.load();
        }
        ModConfig.setFieldsFromConfig();
        _changed = true;
        String s = String.format("%s config reload.", _cls.getName());
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            Minecraft minecraft = Minecraft.m_91087_();
            if (null != minecraft && null != minecraft.f_91065_ && null != minecraft.f_91065_.m_93076_()) {
                minecraft.f_91065_.m_93076_().m_93785_((Component)new TextComponent(s));
            }
        });
        LOGGER.info(s);
    }

    public static boolean checkAndReload() {
        if (System.currentTimeMillis() - _lastCheck >= 500L) {
            _lastCheck = System.currentTimeMillis();
            if (null != _config) {
                long l = _config.getFile().lastModified();
                if (_lastModified < 0L) {
                    _lastModified = l;
                }
                if (_lastModified != l) {
                    _lastModified = l;
                    ModConfig.onFileChange();
                }
            }
        }
        boolean ret = _changed;
        _changed = false;
        return ret;
    }

    public ModConfig(ForgeConfigSpec.Builder builder) {
        ModConfig.execConfigure(builder);
    }

    private static void execConfigure(ForgeConfigSpec.Builder builder) {
        Field[] fields;
        builder.comment(_cls.getCanonicalName()).push("configuration");
        for (Field f : fields = _cls.getFields()) {
            ModProperty anno = f.getAnnotation(ModProperty.class);
            if (null == anno || !Modifier.isStatic(f.getModifiers())) continue;
            Class<?> type = f.getType();
            try {
                Object comment = null;
                if (type.equals(Boolean.TYPE)) {
                    comment = "Boolean: " + (f.getBoolean(null) ? "true" : "false");
                } else if (type.equals(Integer.TYPE)) {
                    comment = "Integer: " + f.getInt(null);
                } else if (type.equals(Double.TYPE)) {
                    comment = "Double: " + f.getDouble(null);
                } else if (type.equals(String.class)) {
                    comment = "String: \"" + f.get(null) + "\"";
                } else {
                    LOGGER.printf(Level.INFO, "unrecognizable type: %s", new Object[]{type.getCanonicalName()});
                }
                if (null != anno.comment() && anno.comment().length() >= 1) {
                    comment = null == comment ? anno.comment() : (String)comment + "\n" + anno.comment();
                }
                if (null != comment) {
                    builder.comment((String)comment);
                }
                builder.translation(f.getName());
                if (type.equals(Boolean.TYPE)) {
                    mapConfigFields.add(new AbstractMap.SimpleEntry<Field, ForgeConfigSpec.BooleanValue>(f, builder.define(f.getName(), anno.defaultBoolean())));
                    continue;
                }
                if (type.equals(Integer.TYPE)) {
                    mapConfigFields.add(new AbstractMap.SimpleEntry<Field, ForgeConfigSpec.ConfigValue>(f, builder.define(f.getName(), (Object)anno.defaultInt())));
                    continue;
                }
                if (type.equals(Double.TYPE)) {
                    mapConfigFields.add(new AbstractMap.SimpleEntry<Field, ForgeConfigSpec.ConfigValue>(f, builder.define(f.getName(), (Object)anno.defaultDouble())));
                    continue;
                }
                if (type.equals(String.class)) {
                    mapConfigFields.add(new AbstractMap.SimpleEntry<Field, ForgeConfigSpec.ConfigValue>(f, builder.define(f.getName(), (Object)anno.defaultString())));
                    continue;
                }
                LOGGER.printf(Level.INFO, "unrecognizable type: %s", new Object[]{type.getCanonicalName()});
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        builder.pop();
    }

    private static void setFieldsFromConfig() {
        mapConfigFields.forEach(i -> {
            try {
                Field f = (Field)i.getKey();
                ForgeConfigSpec.ConfigValue val = (ForgeConfigSpec.ConfigValue)i.getValue();
                Class<?> type = f.getType();
                val.clearCache();
                if (type.equals(Boolean.TYPE)) {
                    f.setBoolean(null, (Boolean)((ForgeConfigSpec.BooleanValue)val).get());
                } else if (type.equals(Integer.TYPE)) {
                    f.setInt(null, (Integer)val.get());
                } else if (type.equals(Double.TYPE)) {
                    f.setDouble(null, (Double)val.get());
                } else if (type.equals(String.class)) {
                    f.set(null, val.get().toString());
                } else {
                    LOGGER.error("config param:{} not set", (Object)f.getName());
                }
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                LOGGER.error("config read error", (Throwable)e);
            }
        });
    }

    public static void saveFieldToConfigFile(String fieldName) {
        mapConfigFields.forEach(i -> {
            try {
                Field f = (Field)i.getKey();
                if (!f.getName().equals(fieldName)) {
                    return;
                }
                ForgeConfigSpec.ConfigValue val = (ForgeConfigSpec.ConfigValue)i.getValue();
                Class<?> type = f.getType();
                if (type.equals(Boolean.TYPE)) {
                    ((ForgeConfigSpec.BooleanValue)val).set((Object)f.getBoolean(null));
                } else if (type.equals(Integer.TYPE)) {
                    val.set((Object)f.getInt(null));
                } else if (type.equals(Double.TYPE)) {
                    val.set((Object)f.getDouble(null));
                } else if (type.equals(String.class)) {
                    val.set((Object)f.get(null).toString());
                } else {
                    LOGGER.error("field {} is Unknown Type.", (Object)f.getName());
                    return;
                }
                val.save();
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                LOGGER.error("config read error", (Throwable)e);
            }
        });
    }

    public static String getKeyboardKeyName(int keyno) {
        Field[] fs = null;
        try {
            Class<?> cls = Class.forName("org.lwjgl.glfw.GLFW");
            fs = cls.getFields();
        }
        catch (ClassNotFoundException e1) {
            return "" + keyno;
        }
        if (null == fs) {
            return "" + keyno;
        }
        for (Field f : fs) {
            String s;
            block7: {
                if (!Modifier.isStatic(f.getModifiers()) || !Integer.TYPE.equals(f.getType()) || 0 != (s = f.getName()).indexOf("GLFW_KEY_")) continue;
                try {
                    if (keyno != f.getInt(null)) {
                    }
                    break block7;
                }
                catch (IllegalAccessException | IllegalArgumentException e) {}
                continue;
            }
            s = s.substring(5);
            LOGGER.printf(Level.INFO, "getKeyboardKeyName=%s", new Object[]{s});
            return s;
        }
        return "" + keyno;
    }

    public static int getKeyboardNo(String name) {
        Integer i = (Integer)DistExecutor.callWhenOn((Dist)Dist.CLIENT, () -> () -> ModConfig.getKeyboardNoClient(name));
        if (null != i) {
            return i;
        }
        return -1;
    }

    private static int getKeyboardNoClient(String name) {
        Field[] fs = null;
        try {
            Class<?> cls = Class.forName("org.lwjgl.glfw.GLFW");
            fs = cls.getFields();
        }
        catch (ClassNotFoundException e1) {
            return -1;
        }
        if (null == fs) {
            return -1;
        }
        if ("KEY_COLON".equals(name)) {
            name = "KEY_APOSTROPHE";
        }
        int key_no = 0;
        for (Field f : fs) {
            String s;
            if (!Modifier.isStatic(f.getModifiers()) || 0 != (s = f.getName()).indexOf("GLFW_KEY_") || !(s = s.substring(5)).equalsIgnoreCase(name)) continue;
            try {
                key_no = f.getInt(null);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
            break;
        }
        LOGGER.printf(Level.INFO, "getKeyboardNo=%d", new Object[]{key_no});
        return key_no;
    }
}

