/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.scalar.mineall;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundCustomPayloadPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.scalar.mineall.BlockAndMetadata;
import net.minecraft.scalar.mineall.ModConfig;
import net.minecraft.scalar.mineall.Packet_mod_MineAll;
import net.minecraft.scalar.mineall.mod_MineAllSMP;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.ClientRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ProxyClient {
    private static KeyMapping keyToggle = new KeyMapping("key.mineall.toggle", 77, "mod.mineall");
    private int beforeKeyToggle = -1;

    public ProxyClient() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        ClientRegistry.registerKeyBinding((KeyMapping)keyToggle);
    }

    @SubscribeEvent
    public void tickEvent(TickEvent.ClientTickEvent event) {
        if (!TickEvent.Phase.END.equals((Object)event.phase)) {
            return;
        }
        if (ModConfig.checkAndReload()) {
            mod_MineAllSMP._itemIds = null;
        }
        if (null == mod_MineAllSMP._itemIds) {
            mod_MineAllSMP._mod.reloadConfigData();
        }
        if (this.beforeKeyToggle < 0) {
            this.beforeKeyToggle = keyToggle.getKey().m_84873_();
        }
        if (mod_MineAllSMP._mod.key_no >= 1) {
            keyToggle.m_90848_(InputConstants.Type.KEYSYM.m_84895_(mod_MineAllSMP._mod.key_no));
            KeyMapping.m_90854_();
            mod_MineAllSMP._mod.key_no = 0;
        }
        if (this.beforeKeyToggle != keyToggle.getKey().m_84873_()) {
            this.beforeKeyToggle = keyToggle.getKey().m_84873_();
            mod_MineAllSMP.Key = ModConfig.getKeyboardKeyName(this.beforeKeyToggle);
            ModConfig.saveFieldToConfigFile("Key");
        }
        Minecraft minecraft = Minecraft.m_91087_();
        if (!mod_MineAllSMP.StartMode) {
            mod_MineAllSMP.attackHistory.clear();
        } else {
            ClientLevel world = minecraft.f_91073_;
            if (null != world) {
                Iterator i = mod_MineAllSMP.attackHistory.iterator();
                while (i.hasNext()) {
                    BlockPos n;
                    Packet_mod_MineAll l = (Packet_mod_MineAll)i.next();
                    if (System.nanoTime() - l.nanoTime >= 15000000000L) {
                        i.remove();
                        continue;
                    }
                    BlockState blockID1 = world.m_8055_(l._pos);
                    if (null != blockID1.m_60734_() && Blocks.f_50016_ != blockID1.m_60734_()) continue;
                    i.remove();
                    if (mod_MineAllSMP.isDelArea(l._pos)) continue;
                    Long delAreaKey = System.currentTimeMillis() + 3000L;
                    List delArea = mod_MineAllSMP.untouchableArea.computeIfAbsent(delAreaKey, k -> Collections.synchronizedList(new ArrayList()));
                    l.position.clear();
                    l.position.add(l._pos);
                    while (!l.position.isEmpty() && null != (n = l.position.poll())) {
                        if (delArea.contains(n)) continue;
                        delArea.add(n);
                        mod_MineAllSMP.checkConnection((Level)world, n, l);
                    }
                    l.position.clear();
                    ServerboundCustomPayloadPacket packet = new ServerboundCustomPayloadPacket(new ResourceLocation(mod_MineAllSMP.channelName), new FriendlyByteBuf(l.writePacketData()));
                    minecraft.m_91403_().m_104955_((Packet)packet);
                }
            }
        }
        if (keyToggle.m_90857_() && minecraft.f_91080_ == null) {
            if (mod_MineAllSMP._mod.flag_change <= 0) {
                mod_MineAllSMP.StartMode = !mod_MineAllSMP.StartMode;
                minecraft.f_91065_.m_93076_().m_93785_((Component)new TextComponent("MineAll " + (mod_MineAllSMP.StartMode ? "ON" : "OFF")));
                mod_MineAllSMP._mod.flag_change = mod_MineAllSMP._mod.FLAG_CHANGE_NUM;
            }
        } else if (mod_MineAllSMP._mod.flag_change >= 1) {
            --mod_MineAllSMP._mod.flag_change;
        }
    }

    static void addAttackBlock(BlockPos pos, boolean clearHistory) {
        if (clearHistory) {
            mod_MineAllSMP.attackHistory.clear();
        }
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        BlockState blockID = world.m_8055_(pos);
        if (mod_MineAllSMP.isDelArea(pos)) {
            return;
        }
        Item equipedItemId = null == player.m_21205_() ? null : player.m_21205_().m_41720_();
        int metadata = mod_MineAllSMP.getMetaFromBlockState(blockID);
        BlockAndMetadata attackedBlock = new BlockAndMetadata(blockID.m_60734_(), metadata);
        List<Object> blockIds = mod_MineAllSMP.getBlockIds();
        boolean isOreTag = blockID.m_204336_(Tags.Blocks.ORES);
        boolean blAdd = (isOreTag || mod_MineAllSMP.isIdInList(attackedBlock, blockIds)) && mod_MineAllSMP.isIdInList(equipedItemId, mod_MineAllSMP._itemIds);
        for (Packet_mod_MineAll l : mod_MineAllSMP.attackHistory) {
            if (!blAdd || !pos.equals((Object)l._pos)) continue;
            l.nanoTime = System.nanoTime();
            l.blockID = blockID.m_60734_();
            l.metadata = mod_MineAllSMP.getMetaFromBlockState(blockID);
            blAdd = false;
        }
        if (blAdd) {
            Packet_mod_MineAll p = new Packet_mod_MineAll();
            p._pos = pos;
            p.blockID = blockID.m_60734_();
            p.metadata = metadata;
            if (p.blockID == Blocks.f_50173_) {
                p.flag_rs = true;
            }
            p.isOreTag = isOreTag;
            p.nanoTime = System.nanoTime();
            try {
                mod_MineAllSMP.attackHistory.put(p);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @SubscribeEvent
    public void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        ProxyClient.addAttackBlock(event.getPos(), false);
    }
}

