/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.scalar.mineall;

import io.netty.buffer.ByteBuf;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.scalar.mineall.BlockAndMetadata;
import net.minecraft.scalar.mineall.ModConfig;
import net.minecraft.scalar.mineall.ModProperty;
import net.minecraft.scalar.mineall.Packet_mod_MineAll;
import net.minecraft.scalar.mineall.ProxyClient;
import net.minecraft.scalar.mineall.ProxyServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.event.EventNetworkChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="mineallsmp")
public class mod_MineAllSMP {
    public static final String MODID = "MineAllSMP";
    private static final Logger LOGGER = LogManager.getLogger();
    @ModProperty(defaultString="iron_pickaxe, wooden_pickaxe, stone_pickaxe, diamond_pickaxe, golden_pickaxe, netherite_pickaxe, wooden_hoe,stone_hoe,golden_hoe,iron_hoe,diamond_hoe,netherite_hoe")
    public static String itemIds = "iron_pickaxe, wooden_pickaxe, stone_pickaxe, diamond_pickaxe, golden_pickaxe, netherite_pickaxe, wooden_hoe,stone_hoe,golden_hoe,iron_hoe,diamond_hoe,netherite_hoe";
    @ModProperty(defaultString="gold_ore, iron_ore, coal_ore, lapis_ore, obsidian, diamond_ore, redstone_ore, glowstone, emerald_ore, nether_quartz_ore, granite, polished_granite, diorite, polished_diorite, andesite, polished_andesite,ancient_debris,nether_gold_ore,sponge,wet_sponge,nether_wart_block,warped_wart_block,crying_obsidian,ancient_debris, deepslate_coal_ore, deepslate_copper_ore, deepslate_diamond_ore, deepslate_emerald_ore, deepslate_gold_ore, deepslate_iron_ore, deepslate_lapis_ore, deepslate_redstone_ore")
    public static String blockIds = "gold_ore, iron_ore, coal_ore, lapis_ore, obsidian, diamond_ore, redstone_ore, glowstone, emerald_ore, nether_quartz_ore, granite, polished_granite, diorite, polished_diorite, andesite, polished_andesite,ancient_debris,nether_gold_ore,sponge,wet_sponge,nether_wart_block,warped_wart_block,crying_obsidian,ancient_debris, deepslate_coal_ore, deepslate_copper_ore, deepslate_diamond_ore, deepslate_emerald_ore, deepslate_gold_ore, deepslate_iron_ore, deepslate_lapis_ore, deepslate_redstone_ore";
    @ModProperty(defaultBoolean=true)
    public static boolean DestroyUnder = true;
    @ModProperty(defaultBoolean=true)
    public static boolean StartMode = true;
    @ModProperty(defaultString="KEY_M")
    public static String Key = "KEY_M";
    @ModProperty(defaultInt=0)
    public static int Limiter = 0;
    @ModProperty(comment="0:not decrease durability 1,2:decrease durability(1=until whole blocks 2=until break an item)", defaultInt=0)
    public static int Durability = 0;
    @ModProperty(defaultBoolean=false)
    public static boolean AutoCollect = false;
    @ModProperty(defaultBoolean=false)
    public static boolean DropGather = false;
    @ModProperty(defaultString="mod_mineall")
    public static String channelName = "mod_mineall";
    @ModProperty(defaultBoolean=true)
    public static boolean UseOreTag = true;
    int key_no = 0;
    int flag_change = 0;
    final int FLAG_CHANGE_NUM = 10;
    static List<Object> _itemIds = null;
    static List<Object> _blockIds = null;
    static final BlockingQueue<Packet_mod_MineAll> attackHistory = new LinkedBlockingQueue<Packet_mod_MineAll>();
    static final long attackHistoryDelayNanoTime = 15000000000L;
    static final int untouchableMiliSec = 3000;
    static final ConcurrentMap<Long, List<BlockPos>> untouchableArea = new ConcurrentHashMap<Long, List<BlockPos>>();
    static final BlockingQueue<Packet_mod_MineAll> _serverPacket = new LinkedBlockingQueue<Packet_mod_MineAll>();
    static mod_MineAllSMP _mod;
    private final Object _client = DistExecutor.unsafeRunForDist(() -> ProxyClient::new, () -> ProxyServer::new);
    private static final Pattern ptnNum;

    public mod_MineAllSMP() {
        _mod = this;
        ModConfig.configure(this.getClass(), FMLJavaModLoadingContext.get().getModEventBus());
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        MinecraftForge.EVENT_BUS.register((Object)this);
        EventNetworkChannel e = NetworkRegistry.newEventChannel((ResourceLocation)new ResourceLocation(channelName), () -> "0.1", s -> true, s -> true);
        e.addListener(this::onServerPacket);
    }

    private void setup(FMLCommonSetupEvent event) {
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        mod_MineAllSMP.outputAllMetadataName();
    }

    void reloadConfigData() {
        _itemIds = mod_MineAllSMP.idStringToArray(itemIds, false);
        _blockIds = mod_MineAllSMP.idStringToArray(blockIds, true);
        this.key_no = ModConfig.getKeyboardNo(Key);
        LOGGER.info("DestroyUnder={}, blocks={}", (Object)DestroyUnder, (Object)_blockIds.stream().map(s -> s.toString()).collect(Collectors.joining(",")));
    }

    public <T extends NetworkEvent> void onServerPacket(T event) {
        if (ModConfig.checkAndReload()) {
            _itemIds = null;
        }
        if (null == _itemIds) {
            this.reloadConfigData();
        }
        Packet_mod_MineAll p = new Packet_mod_MineAll();
        NetworkEvent.Context con = (NetworkEvent.Context)event.getSource().get();
        p._player = con.getSender();
        ByteBuf bbPayload = event.getPayload().asReadOnly();
        byte[] payload = new byte[bbPayload.capacity()];
        bbPayload.getBytes(0, payload);
        p.readPacketData(payload);
        double d = p._player.m_20275_((double)p._pos.m_123341_(), (double)p._pos.m_123342_(), (double)p._pos.m_123343_());
        if (d > 36.0) {
            return;
        }
        _serverPacket.offer(p);
    }

    @SubscribeEvent
    public void tickEventServer(TickEvent.ServerTickEvent event) {
        if (!TickEvent.Phase.END.equals((Object)event.phase)) {
            return;
        }
        Packet_mod_MineAll p = (Packet_mod_MineAll)_serverPacket.poll();
        if (null == p) {
            return;
        }
        mod_MineAllSMP.startMine(p, p._player);
    }

    static boolean isDelArea(BlockPos pos) {
        for (Long key : untouchableArea.keySet()) {
            if (key <= System.currentTimeMillis()) {
                untouchableArea.remove(key);
                continue;
            }
            if (!((List)untouchableArea.get(key)).contains(pos)) continue;
            return true;
        }
        return false;
    }

    protected static void startMine(Packet_mod_MineAll p, Player player) {
        Level world = player.m_20193_();
        if (!mod_MineAllSMP.canMine(world, player, p)) {
            return;
        }
        mod_MineAllSMP.breakAll(world, player, p);
        if (AutoCollect) {
            mod_MineAllSMP.collectDrop(world, player, p);
        }
        if (DropGather) {
            mod_MineAllSMP.stackItem(world, player, p);
        }
    }

    private static boolean canMine(Level world, Player player, Packet_mod_MineAll p) {
        Block block = p.blockID;
        p.itemstack = player.m_21205_();
        if (p.itemstack == null || block == null) {
            return false;
        }
        if (p.itemstack.m_41613_() <= 0) {
            return false;
        }
        if (null == p.blockID || Blocks.f_50752_ == p.blockID) {
            return false;
        }
        if (!mod_MineAllSMP.isIdInList(p.itemstack.m_41720_(), _itemIds)) {
            return false;
        }
        if (UseOreTag) {
            if (p.isOreTag) {
                LOGGER.info("mod_MineAllSMP.canMine:{}(pos={}) is Tags.Blocks.ORES.", (Object)p.blockID.toString(), (Object)p._pos.toString());
                return true;
            }
            LOGGER.info("mod_MineAllSMP.canMine:{}(pos={}) is not Tags.Blocks.ORES.", (Object)p.blockID.toString(), (Object)p._pos.toString());
        }
        List<Object> blockIds = mod_MineAllSMP.getBlockIds();
        if (p.flag_rs) {
            return mod_MineAllSMP.isIdInList(new BlockAndMetadata(Blocks.f_50173_, -1), blockIds);
        }
        return mod_MineAllSMP.isIdInList(new BlockAndMetadata(block, p.metadata), blockIds);
    }

    private static void collectDrop(Level world, Player entityplayer, Packet_mod_MineAll p) {
        List list = world.m_45933_((Entity)entityplayer, new AABB((double)p._pos.m_123341_() - 0.5, (double)p._pos.m_123342_() - 0.5, (double)p._pos.m_123343_() - 0.5, (double)p._pos.m_123341_() + 1.5, (double)p._pos.m_123342_() + 1.5, (double)p._pos.m_123343_() + 1.5));
        if (list == null || list.isEmpty()) {
            return;
        }
        for (Object o : list) {
            Entity entity = (Entity)o;
            if (!(entity instanceof ItemEntity)) continue;
            ((ItemEntity)entity).m_32061_();
            entity.m_6123_(entityplayer);
        }
    }

    private static void stackItem(Level world, Player entityplayer, Packet_mod_MineAll p) {
        List list = world.m_45933_((Entity)entityplayer, new AABB((double)p._pos.m_123341_(), (double)p._pos.m_123342_(), (double)p._pos.m_123343_(), (double)p._pos.m_123341_() + 1.0, (double)p._pos.m_123342_() + 1.0, (double)p._pos.m_123343_() + 1.0));
        if (list == null || list.isEmpty()) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            Entity entity1 = (Entity)list.get(i);
            if (!(entity1 instanceof ItemEntity) || !entity1.m_6084_()) continue;
            ItemEntity e1 = (ItemEntity)entity1;
            ItemStack e1Item = e1.m_32055_();
            int itemDamage = e1Item.m_41773_();
            for (int j = i + 1; j < list.size(); ++j) {
                Entity entity2 = (Entity)list.get(j);
                if (!(entity2 instanceof ItemEntity) || !entity2.m_6084_()) continue;
                ItemEntity e2 = (ItemEntity)entity2;
                ItemStack e2Item = e2.m_32055_();
                int itemDamage1 = e2Item.m_41773_();
                if (e1Item.m_41720_() != e2Item.m_41720_() || itemDamage != itemDamage1) continue;
                e1Item.m_41769_(e2Item.m_41613_());
                entity2.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            e1.m_32045_(e1Item);
        }
    }

    private static void breakAll(Level world, Player player, Packet_mod_MineAll p) {
        mod_MineAllSMP.checkConnection(world, p._pos, p);
        while (mod_MineAllSMP.breakBlock(world, player, p)) {
        }
        p.position.clear();
    }

    static void checkConnection(Level world, BlockPos pos, Packet_mod_MineAll p) {
        int is = 1;
        int ie = 1;
        int js = 1;
        int je = 1;
        int ks = 1;
        int ke = 1;
        if (Limiter != 0) {
            if (p._pos.m_123341_() - Limiter / 2 == pos.m_123341_()) {
                is = 0;
            }
            if (p._pos.m_123341_() + Limiter / 2 == pos.m_123341_()) {
                ie = 0;
            }
            if (p._pos.m_123342_() - Limiter / 2 == pos.m_123342_()) {
                js = 0;
            }
            if (p._pos.m_123342_() + Limiter / 2 == pos.m_123342_()) {
                je = 0;
            }
            if (p._pos.m_123343_() - Limiter / 2 == pos.m_123343_()) {
                ks = 0;
            }
            if (p._pos.m_123343_() + Limiter / 2 == pos.m_123343_()) {
                ke = 0;
            }
        }
        if (!DestroyUnder && p._pos.m_123342_() == pos.m_123342_()) {
            js = 0;
        }
        for (int i2 = -is; i2 <= ie; ++i2) {
            for (int j2 = -js; j2 <= je; ++j2) {
                for (int k2 = -ks; k2 <= ke; ++k2) {
                    if (Math.abs(i2) + Math.abs(j2) + Math.abs(k2) != 1) continue;
                    BlockPos pos2 = pos.m_142082_(i2, j2, k2);
                    BlockState block = world.m_8055_(pos2);
                    int metadata1 = mod_MineAllSMP.getMetaFromBlockState(block);
                    if (!mod_MineAllSMP.checkBlock(block.m_60734_(), metadata1, p)) continue;
                    p.position.offer(pos2);
                }
            }
        }
    }

    private static boolean breakBlock(Level world, Player entityplayer, Packet_mod_MineAll p) {
        EquipmentSlot activehand;
        BlockPos pos = p.position.poll();
        if (pos == null) {
            return false;
        }
        BlockState block1 = world.m_8055_(pos);
        int metadata1 = mod_MineAllSMP.getMetaFromBlockState(block1);
        EquipmentSlot equipmentSlot = activehand = InteractionHand.OFF_HAND == entityplayer.m_7655_() ? EquipmentSlot.OFFHAND : EquipmentSlot.MAINHAND;
        if (mod_MineAllSMP.checkBlock(block1.m_60734_(), metadata1, p)) {
            if ((1 == Durability || 2 == Durability) && null != entityplayer.m_6844_(activehand)) {
                p.itemstack.m_41686_(world, block1, pos, entityplayer);
                if (p.itemstack.m_41613_() <= 0) {
                    entityplayer.m_8061_(activehand, ItemStack.f_41583_);
                }
            }
            ItemStack i2 = null == entityplayer.m_21205_() ? null : entityplayer.m_21205_().m_41777_();
            block1.m_60734_().m_6240_(world, entityplayer, pos, block1, world.m_7702_(pos), i2);
            try {
                BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, pos, block1, entityplayer);
                if (world instanceof ServerLevel) {
                    block1.m_60734_().m_49805_((ServerLevel)world, pos, event.getExpToDrop());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            world.m_7471_(pos, false);
            if (DropGather || AutoCollect) {
                mod_MineAllSMP.moveItemEntity(world, entityplayer, pos, p._pos);
            }
            if (2 == Durability && null == entityplayer.m_6844_(activehand)) {
                return false;
            }
            mod_MineAllSMP.checkConnection(world, pos, p);
        }
        return true;
    }

    private static boolean checkBlock(Block block1, int l, Packet_mod_MineAll p) {
        if (block1 == null) {
            return false;
        }
        return !(!p.flag_rs ? block1 != p.blockID || p.metadata != l : block1 != Blocks.f_50173_);
    }

    private static void moveItemEntity(Level world, Player entityplayer, BlockPos from, BlockPos to) {
        List list = world.m_45933_((Entity)entityplayer, new AABB((double)from.m_123341_(), (double)from.m_123342_(), (double)from.m_123343_(), (double)(from.m_123341_() + 1), (double)(from.m_123342_() + 1), (double)(from.m_123343_() + 1)));
        if (null == list || list.isEmpty()) {
            return;
        }
        for (Object o : list) {
            Entity e = (Entity)o;
            if (!(e instanceof ItemEntity) || !e.m_6084_()) continue;
            e.m_6034_((double)to.m_123341_() + 0.5, (double)to.m_123342_() + 0.5, (double)to.m_123343_() + 0.5);
        }
    }

    static boolean isIdInList(Object o, List<Object> list) {
        return null != list && list.indexOf(o) >= 0;
    }

    /*
     * WARNING - void declaration
     */
    private static List<Object> idStringToArray(String s, boolean isBlock) {
        try {
            String[] ss;
            Pattern ptn = Pattern.compile("^(.*):(.*)$");
            ArrayList<Object> l = new ArrayList<Object>();
            for (String string : ss = s.split(",")) {
                String metastr = null;
                Object b = null;
                String string2 = string.trim();
                Object object = b = isBlock ? Registry.f_122824_.m_7745_(new ResourceLocation(string2)) : Registry.f_122827_.m_7745_(new ResourceLocation(string2));
                if (Blocks.f_50016_ == b || Items.f_41852_ == b) {
                    void var8_13;
                    Matcher m;
                    if (isBlock && (m = ptn.matcher(string2)).matches()) {
                        String string3 = m.group(1);
                        metastr = m.group(2);
                    }
                    Object object2 = b = isBlock ? Registry.f_122824_.m_7745_(new ResourceLocation((String)var8_13)) : Registry.f_122827_.m_7745_(new ResourceLocation((String)var8_13));
                    if (Blocks.f_50016_ == b || Items.f_41852_ == b) {
                        String string4 = "minecraft:" + (String)var8_13;
                        Object object3 = b = isBlock ? Registry.f_122824_.m_7745_(new ResourceLocation(string4)) : Registry.f_122827_.m_7745_(new ResourceLocation(string4));
                    }
                }
                if (Blocks.f_50016_ == b || Items.f_41852_ == b) continue;
                if (isBlock) {
                    if (Blocks.f_50016_ == b) continue;
                    Block block = (Block)b;
                    BlockAndMetadata bam = new BlockAndMetadata(block, mod_MineAllSMP.convertMetaString(block, metastr));
                    l.add(bam);
                    continue;
                }
                l.add(b);
            }
            return l;
        }
        catch (Exception e) {
            LOGGER.error("idStringToArray", (Throwable)e);
            return Collections.emptyList();
        }
    }

    static int getMetaFromBlockState(BlockState i) {
        return 0;
    }

    static int convertMetaString(Block b, String s) {
        return -1;
    }

    static void outputAllMetadataName() {
    }

    static List<Object> getBlockIds() {
        ArrayList<Object> blockIds = new ArrayList<Object>();
        blockIds.addAll(_blockIds);
        return blockIds;
    }

    public static Method getMethod(Class<?> targetClass, Class<?> retType, Class<?> ... args) {
        for (Method m : targetClass.getDeclaredMethods()) {
            if (!m.getReturnType().equals(retType)) continue;
            boolean bl = true;
            if (args.length >= 1) {
                Class<?>[] p = m.getParameterTypes();
                if (p.length != args.length) continue;
                for (int i = 0; i < args.length; ++i) {
                    if (p[i] == args[i]) continue;
                    bl = false;
                    break;
                }
            }
            if (!bl) continue;
            m.setAccessible(true);
            return m;
        }
        LOGGER.warn("no invoke method.");
        return null;
    }

    static {
        ptnNum = Pattern.compile("^[0-9]+$");
    }
}

