/*
 * Decompiled with CFR 0.152.
 */
package appeng.api.crafting;

import appeng.api.crafting.IPatternDetails;
import appeng.api.crafting.IPatternDetailsDecoder;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.GenericStack;
import appeng.core.definitions.AEItems;
import appeng.crafting.pattern.AEPatternDecoder;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nullable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.level.Level;

public final class PatternDetailsHelper {
    private static final List<IPatternDetailsDecoder> DECODERS = new CopyOnWriteArrayList<IPatternDetailsDecoder>();

    public static void registerDecoder(IPatternDetailsDecoder decoder) {
        Objects.requireNonNull(decoder);
        DECODERS.add(decoder);
    }

    public static boolean isEncodedPattern(ItemStack stack) {
        for (IPatternDetailsDecoder decoder : DECODERS) {
            if (!decoder.isEncodedPattern(stack)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static IPatternDetails decodePattern(ItemStack stack, Level level) {
        return PatternDetailsHelper.decodePattern(stack, level, false);
    }

    @Nullable
    public static IPatternDetails decodePattern(AEItemKey what, Level level) {
        for (IPatternDetailsDecoder decoder : DECODERS) {
            IPatternDetails decoded = decoder.decodePattern(what, level);
            if (decoded == null) continue;
            return decoded;
        }
        return null;
    }

    @Nullable
    public static IPatternDetails decodePattern(ItemStack stack, Level level, boolean autoRecovery) {
        for (IPatternDetailsDecoder decoder : DECODERS) {
            IPatternDetails decoded = decoder.decodePattern(stack, level, autoRecovery);
            if (decoded == null) continue;
            return decoded;
        }
        return null;
    }

    public static ItemStack encodeProcessingPattern(GenericStack[] in, GenericStack[] out) {
        return AEItems.PROCESSING_PATTERN.m_5456_().encode(in, out);
    }

    public static ItemStack encodeCraftingPattern(CraftingRecipe recipe, ItemStack[] in, ItemStack out, boolean allowSubstitutes, boolean allowFluidSubstitutes) {
        return AEItems.CRAFTING_PATTERN.m_5456_().encode(recipe, in, out, allowSubstitutes, allowFluidSubstitutes);
    }

    static {
        PatternDetailsHelper.registerDecoder(AEPatternDecoder.INSTANCE);
    }
}

