/*
 * Decompiled with CFR 0.152.
 */
package appeng.blockentity.crafting;

import appeng.block.crafting.AbstractCraftingUnitBlock;
import appeng.blockentity.crafting.CraftingBlockEntity;
import appeng.core.definitions.AEBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class CraftingStorageBlockEntity
extends CraftingBlockEntity {
    private static final int KILO_SCALAR = 1024;

    public CraftingStorageBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState blockState) {
        super(blockEntityType, pos, blockState);
    }

    @Override
    protected Item getItemFromBlockEntity() {
        int storage = this.getStorageBytes() / 1024;
        return switch (storage) {
            case 1 -> (BlockItem)AEBlocks.CRAFTING_STORAGE_1K.m_5456_();
            case 4 -> (BlockItem)AEBlocks.CRAFTING_STORAGE_4K.m_5456_();
            case 16 -> (BlockItem)AEBlocks.CRAFTING_STORAGE_16K.m_5456_();
            case 64 -> (BlockItem)AEBlocks.CRAFTING_STORAGE_64K.m_5456_();
            case 256 -> (BlockItem)AEBlocks.CRAFTING_STORAGE_256K.m_5456_();
            default -> super.getItemFromBlockEntity();
        };
    }

    @Override
    public boolean isAccelerator() {
        return false;
    }

    @Override
    public boolean isStorage() {
        return true;
    }

    @Override
    public int getStorageBytes() {
        if (this.f_58857_ == null || this.notLoaded() || this.m_58901_()) {
            return 0;
        }
        AbstractCraftingUnitBlock unit = (AbstractCraftingUnitBlock)this.f_58857_.m_8055_(this.f_58858_).m_60734_();
        return switch (unit.type) {
            case AbstractCraftingUnitBlock.CraftingUnitType.STORAGE_1K -> 1024;
            case AbstractCraftingUnitBlock.CraftingUnitType.STORAGE_4K -> 4096;
            case AbstractCraftingUnitBlock.CraftingUnitType.STORAGE_16K -> 16384;
            case AbstractCraftingUnitBlock.CraftingUnitType.STORAGE_64K -> 65536;
            case AbstractCraftingUnitBlock.CraftingUnitType.STORAGE_256K -> 262144;
            default -> 0;
        };
    }
}

