/*
 * Decompiled with CFR 0.152.
 */
package appeng.core;

import appeng.api.config.CondenserOutput;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.PowerUnits;
import appeng.api.config.SearchBoxMode;
import appeng.api.config.Settings;
import appeng.api.config.TerminalStyle;
import appeng.api.config.YesNo;
import appeng.api.features.AEWorldGenInternal;
import appeng.api.networking.pathing.ChannelMode;
import appeng.core.AELog;
import appeng.core.settings.TickRates;
import appeng.util.EnumCycler;
import com.google.common.base.Strings;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.DoubleSupplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="ae2", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class AEConfig {
    public static final ClientConfig CLIENT;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final CommonConfig COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;
    private static final double DEFAULT_RF_EXCHANGE = 0.5;
    private static final AEConfig instance;
    private int formationPlaneEntityLimit;
    private boolean enableEffects;
    private boolean useLargeFonts;
    private boolean useColoredCraftingStatus;
    private int craftingCalculationTimePerTick;
    private PowerUnits selectedPowerUnit = PowerUnits.AE;
    private double spatialPowerExponent;
    private double spatialPowerMultiplier;
    private int wirelessTerminalBattery;
    private int entropyManipulatorBattery;
    private int matterCannonBattery;
    private int portableCellBattery;
    private int colorApplicatorBattery;
    private int chargedStaffBattery;
    private double wirelessBaseCost;
    private double wirelessCostMultiplier;
    private double wirelessTerminalDrainMultiplier;
    private double wirelessBaseRange;
    private double wirelessBoosterRangeMultiplier;
    private double wirelessBoosterExp;
    private double wirelessHighWirelessCount;
    public static final double TUNNEL_POWER_LOSS = 0.05;
    @Nullable
    private TagKey<Fluid> improvedFluidTagKey;

    @SubscribeEvent
    public static void onModConfigEvent(ModConfigEvent configEvent) {
        if (configEvent.getConfig().getSpec() == CLIENT_SPEC) {
            instance.syncClientConfig();
        } else if (configEvent.getConfig().getSpec() == COMMON_SPEC) {
            instance.syncCommonConfig();
        }
    }

    private void syncClientConfig() {
        this.enableEffects = (Boolean)AEConfig.CLIENT.enableEffects.get();
        this.useLargeFonts = (Boolean)AEConfig.CLIENT.useLargeFonts.get();
        this.useColoredCraftingStatus = (Boolean)AEConfig.CLIENT.useColoredCraftingStatus.get();
    }

    private void syncCommonConfig() {
        PowerUnits.RF.conversionRatio = (Double)AEConfig.COMMON.powerRatioForgeEnergy.get();
        PowerMultiplier.CONFIG.multiplier = (Double)AEConfig.COMMON.powerUsageMultiplier.get();
        CondenserOutput.MATTER_BALLS.requiredPower = (Integer)AEConfig.COMMON.condenserMatterBallsPower.get();
        CondenserOutput.SINGULARITY.requiredPower = (Integer)AEConfig.COMMON.condenserSingularityPower.get();
        this.wirelessBaseCost = (Double)AEConfig.COMMON.wirelessBaseCost.get();
        this.wirelessCostMultiplier = (Double)AEConfig.COMMON.wirelessCostMultiplier.get();
        this.wirelessBaseRange = (Double)AEConfig.COMMON.wirelessBaseRange.get();
        this.wirelessBoosterRangeMultiplier = (Double)AEConfig.COMMON.wirelessBoosterRangeMultiplier.get();
        this.wirelessBoosterExp = (Double)AEConfig.COMMON.wirelessBoosterExp.get();
        this.wirelessHighWirelessCount = (Double)AEConfig.COMMON.wirelessHighWirelessCount.get();
        this.wirelessTerminalDrainMultiplier = (Double)AEConfig.COMMON.wirelessTerminalDrainMultiplier.get();
        this.formationPlaneEntityLimit = (Integer)AEConfig.COMMON.formationPlaneEntityLimit.get();
        this.wirelessTerminalBattery = (Integer)AEConfig.COMMON.wirelessTerminalBattery.get();
        this.chargedStaffBattery = (Integer)AEConfig.COMMON.chargedStaffBattery.get();
        this.entropyManipulatorBattery = (Integer)AEConfig.COMMON.entropyManipulatorBattery.get();
        this.portableCellBattery = (Integer)AEConfig.COMMON.portableCellBattery.get();
        this.colorApplicatorBattery = (Integer)AEConfig.COMMON.colorApplicatorBattery.get();
        this.matterCannonBattery = (Integer)AEConfig.COMMON.matterCannonBattery.get();
        for (TickRates tr : TickRates.values()) {
            tr.setMin((Integer)AEConfig.COMMON.tickRateMin.get((Object)tr).get());
            tr.setMax((Integer)AEConfig.COMMON.tickRateMax.get((Object)tr).get());
        }
        this.spatialPowerMultiplier = (Double)AEConfig.COMMON.spatialPowerMultiplier.get();
        this.spatialPowerExponent = (Double)AEConfig.COMMON.spatialPowerExponent.get();
        this.craftingCalculationTimePerTick = (Integer)AEConfig.COMMON.craftingCalculationTimePerTick.get();
        AEWorldGenInternal.setConfigBlacklists(((List)AEConfig.COMMON.quartzOresBiomeBlacklist.get()).stream().map(ResourceLocation::new).collect(Collectors.toList()));
        AELog.setCraftingLogEnabled((Boolean)AEConfig.COMMON.craftingLog.get());
        AELog.setDebugLogEnabled((Boolean)AEConfig.COMMON.debugLog.get());
        AELog.setGridLogEnabled((Boolean)AEConfig.COMMON.gridLog.get());
    }

    public static AEConfig instance() {
        return instance;
    }

    public double wireless_getDrainRate(double range) {
        return this.wirelessTerminalDrainMultiplier * range;
    }

    public double wireless_getMaxRange(int boosters) {
        return this.wirelessBaseRange + this.wirelessBoosterRangeMultiplier * Math.pow(boosters, this.wirelessBoosterExp);
    }

    public double wireless_getPowerDrain(int boosters) {
        return this.wirelessBaseCost + this.wirelessCostMultiplier * Math.pow(boosters, 1.0 + (double)boosters / this.wirelessHighWirelessCount);
    }

    public YesNo getSearchTooltips() {
        return (YesNo)((Object)AEConfig.CLIENT.searchTooltips.get());
    }

    public TerminalStyle getTerminalStyle() {
        return (TerminalStyle)((Object)AEConfig.CLIENT.terminalStyle.get());
    }

    public void setTerminalStyle(TerminalStyle setting) {
        AEConfig.CLIENT.terminalStyle.set((Object)setting);
    }

    public SearchBoxMode getTerminalSearchMode() {
        return (SearchBoxMode)((Object)AEConfig.CLIENT.terminalSearchMode.get());
    }

    public void setTerminalSearchMode(SearchBoxMode setting) {
        AEConfig.CLIENT.terminalSearchMode.set((Object)setting);
    }

    public void save() {
        if (CLIENT_SPEC.isLoaded()) {
            AEConfig.CLIENT.selectedPowerUnit.set((Object)this.selectedPowerUnit);
            CLIENT_SPEC.save();
        }
        if (COMMON_SPEC.isLoaded()) {
            COMMON_SPEC.save();
        }
    }

    public PowerUnits getSelectedPowerUnit() {
        return this.selectedPowerUnit;
    }

    public void nextPowerUnit(boolean backwards) {
        this.selectedPowerUnit = EnumCycler.rotateEnum(this.selectedPowerUnit, backwards, Settings.POWER_UNITS.getValues());
        this.save();
    }

    public boolean isBlockEntityFacadesEnabled() {
        return (Boolean)AEConfig.COMMON.allowBlockEntityFacades.get();
    }

    public boolean isDebugToolsEnabled() {
        return (Boolean)AEConfig.COMMON.debugTools.get();
    }

    public int getFormationPlaneEntityLimit() {
        return this.formationPlaneEntityLimit;
    }

    public boolean isEnableEffects() {
        return this.enableEffects;
    }

    public boolean isUseLargeFonts() {
        return this.useLargeFonts;
    }

    public boolean isUseColoredCraftingStatus() {
        return this.useColoredCraftingStatus;
    }

    public boolean isDisableColoredCableRecipesInJEI() {
        return (Boolean)AEConfig.CLIENT.disableColoredCableRecipesInJEI.get();
    }

    public boolean isShowFacadesInJEIEnabled() {
        return (Boolean)AEConfig.CLIENT.showFacadesInJEI.get();
    }

    public int getCraftingCalculationTimePerTick() {
        return this.craftingCalculationTimePerTick;
    }

    public double getSpatialPowerExponent() {
        return this.spatialPowerExponent;
    }

    public double getSpatialPowerMultiplier() {
        return this.spatialPowerMultiplier;
    }

    public double getChargerChargeRate() {
        return (Double)AEConfig.COMMON.chargerChargeRate.get();
    }

    public DoubleSupplier getWirelessTerminalBattery() {
        return () -> this.wirelessTerminalBattery;
    }

    public DoubleSupplier getEntropyManipulatorBattery() {
        return () -> this.entropyManipulatorBattery;
    }

    public DoubleSupplier getMatterCannonBattery() {
        return () -> this.matterCannonBattery;
    }

    public DoubleSupplier getPortableCellBattery() {
        return () -> this.portableCellBattery;
    }

    public DoubleSupplier getColorApplicatorBattery() {
        return () -> this.colorApplicatorBattery;
    }

    public DoubleSupplier getChargedStaffBattery() {
        return () -> this.chargedStaffBattery;
    }

    public int getQuartzOresPerCluster() {
        return (Integer)AEConfig.COMMON.quartzOresPerCluster.get();
    }

    public int getQuartzOresClusterAmount() {
        return (Integer)AEConfig.COMMON.quartzOresClusterAmount.get();
    }

    @Nullable
    public TagKey<Fluid> getImprovedFluidTag() {
        String tagName;
        if (this.improvedFluidTagKey == null && (tagName = Strings.emptyToNull((String)((String)AEConfig.COMMON.improvedFluidTag.get()))) != null) {
            this.improvedFluidTagKey = TagKey.m_203882_((ResourceKey)Registry.f_122899_, (ResourceLocation)new ResourceLocation(tagName));
        }
        return this.improvedFluidTagKey;
    }

    public float getImprovedFluidMultiplier() {
        return ((Double)AEConfig.COMMON.improvedFluidMultiplier.get()).floatValue();
    }

    public boolean isShowDebugGuiOverlays() {
        return (Boolean)AEConfig.CLIENT.debugGuiOverlays.get();
    }

    public boolean isSpawnPressesInMeteoritesEnabled() {
        return (Boolean)AEConfig.COMMON.spawnPressesInMeteorites.get();
    }

    public boolean isGenerateQuartzOre() {
        return (Boolean)AEConfig.COMMON.generateQuartzOre.get();
    }

    public boolean isMatterCanonBlockDamageEnabled() {
        return (Boolean)AEConfig.COMMON.matterCannonBlockDamage.get();
    }

    public boolean isTinyTntBlockDamageEnabled() {
        return (Boolean)AEConfig.COMMON.tinyTntBlockDamage.get();
    }

    public boolean isInWorldSingularityEnabled() {
        return (Boolean)AEConfig.COMMON.inWorldSingularity.get();
    }

    public boolean isInWorldFluixEnabled() {
        return (Boolean)AEConfig.COMMON.inWorldFluix.get();
    }

    public boolean isInWorldCrystalGrowthEnabled() {
        return (Boolean)AEConfig.COMMON.inWorldCrystalGrowth.get();
    }

    public boolean isDisassemblyCraftingEnabled() {
        return (Boolean)AEConfig.COMMON.disassemblyCrafting.get();
    }

    public boolean isSecurityAuditLogEnabled() {
        return (Boolean)AEConfig.COMMON.securityAuditLog.get();
    }

    public boolean isBlockUpdateLogEnabled() {
        return (Boolean)AEConfig.COMMON.blockUpdateLog.get();
    }

    public boolean isPacketLogEnabled() {
        return (Boolean)AEConfig.COMMON.packetLog.get();
    }

    public boolean isChunkLoggerTraceEnabled() {
        return (Boolean)AEConfig.COMMON.chunkLoggerTrace.get();
    }

    public boolean serverOpsIgnoreSecurity() {
        return (Boolean)AEConfig.COMMON.serverOpsIgnoreSecurity.get();
    }

    public ChannelMode getChannelMode() {
        return (ChannelMode)((Object)AEConfig.COMMON.channels.get());
    }

    public void setChannelModel(ChannelMode mode) {
        AEConfig.COMMON.channels.set((Object)mode);
    }

    public int getPathfindingStepsPerTick() {
        return (Integer)AEConfig.COMMON.pathfindingStepsPerTick.get();
    }

    public boolean isPlacementPreviewEnabled() {
        return (Boolean)AEConfig.CLIENT.showPlacementPreview.get();
    }

    public boolean isPortableCellDisassemblyEnabled() {
        return (Boolean)AEConfig.COMMON.portableCellDisassembly.get();
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        CLIENT_SPEC = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (ClientConfig)specPair.getLeft();
        Pair commonPair = new ForgeConfigSpec.Builder().configure(CommonConfig::new);
        COMMON_SPEC = (ForgeConfigSpec)commonPair.getRight();
        COMMON = (CommonConfig)commonPair.getLeft();
        instance = new AEConfig();
    }

    private static class ClientConfig {
        public final ForgeConfigSpec.BooleanValue enableEffects;
        public final ForgeConfigSpec.BooleanValue useLargeFonts;
        public final ForgeConfigSpec.BooleanValue useColoredCraftingStatus;
        public final ForgeConfigSpec.BooleanValue disableColoredCableRecipesInJEI;
        public final ForgeConfigSpec.BooleanValue showFacadesInJEI;
        public final ForgeConfigSpec.EnumValue<PowerUnits> selectedPowerUnit;
        public final ForgeConfigSpec.BooleanValue debugGuiOverlays;
        public final ForgeConfigSpec.BooleanValue showPlacementPreview;
        public final ForgeConfigSpec.EnumValue<YesNo> searchTooltips;
        public final ForgeConfigSpec.EnumValue<TerminalStyle> terminalStyle;
        public final ForgeConfigSpec.EnumValue<SearchBoxMode> terminalSearchMode;

        public ClientConfig(ForgeConfigSpec.Builder builder) {
            builder.push("client");
            this.disableColoredCableRecipesInJEI = builder.comment("TODO").define("disableColoredCableRecipesInJEI", true);
            this.showFacadesInJEI = builder.define("showFacadesInJEI", true);
            this.enableEffects = builder.comment("TODO").define("enableEffects", true);
            this.useLargeFonts = builder.comment("TODO").define("useTerminalUseLargeFont", false);
            this.useColoredCraftingStatus = builder.comment("TODO").define("useColoredCraftingStatus", true);
            this.selectedPowerUnit = builder.comment("Power unit shown in AE UIs").defineEnum("PowerUnit", (Enum)PowerUnits.AE, (Enum[])PowerUnits.values());
            this.debugGuiOverlays = builder.comment("Show debugging GUI overlays").define("showDebugGuiOverlays", false);
            this.showPlacementPreview = builder.comment("Show a preview of part and facade placement").define("showPlacementPreview", true);
            builder.push("terminals");
            this.searchTooltips = builder.comment("Should tooltips be searched. Performance impact").defineEnum("searchTooltips", (Enum)YesNo.YES, (Enum[])YesNo.values());
            this.terminalStyle = builder.defineEnum("terminalStyle", (Enum)TerminalStyle.TALL, (Enum[])TerminalStyle.values());
            this.terminalSearchMode = builder.defineEnum("terminalSearchMode", (Enum)SearchBoxMode.DEFAULT, (Enum[])SearchBoxMode.values());
            builder.pop();
        }
    }

    private static class CommonConfig {
        public final ForgeConfigSpec.ConfigValue<Integer> formationPlaneEntityLimit;
        public final ForgeConfigSpec.ConfigValue<Integer> craftingCalculationTimePerTick;
        public final ForgeConfigSpec.BooleanValue allowBlockEntityFacades;
        public final ForgeConfigSpec.BooleanValue debugTools;
        public final ForgeConfigSpec.BooleanValue matterCannonBlockDamage;
        public final ForgeConfigSpec.BooleanValue tinyTntBlockDamage;
        public final ForgeConfigSpec.BooleanValue serverOpsIgnoreSecurity;
        public final ForgeConfigSpec.ConfigValue<ChannelMode> channels;
        public final ForgeConfigSpec.ConfigValue<Integer> pathfindingStepsPerTick;
        public final ForgeConfigSpec.BooleanValue inWorldSingularity;
        public final ForgeConfigSpec.BooleanValue inWorldFluix;
        public final ForgeConfigSpec.BooleanValue inWorldCrystalGrowth;
        public final ForgeConfigSpec.BooleanValue disassemblyCrafting;
        public final ForgeConfigSpec.ConfigValue<Double> spatialPowerExponent;
        public final ForgeConfigSpec.ConfigValue<Double> spatialPowerMultiplier;
        public final ForgeConfigSpec.BooleanValue securityAuditLog;
        public final ForgeConfigSpec.BooleanValue blockUpdateLog;
        public final ForgeConfigSpec.BooleanValue packetLog;
        public final ForgeConfigSpec.BooleanValue craftingLog;
        public final ForgeConfigSpec.BooleanValue debugLog;
        public final ForgeConfigSpec.BooleanValue gridLog;
        public final ForgeConfigSpec.BooleanValue chunkLoggerTrace;
        public final ForgeConfigSpec.ConfigValue<Double> chargerChargeRate;
        public final ForgeConfigSpec.ConfigValue<Integer> wirelessTerminalBattery;
        public final ForgeConfigSpec.ConfigValue<Integer> entropyManipulatorBattery;
        public final ForgeConfigSpec.ConfigValue<Integer> matterCannonBattery;
        public final ForgeConfigSpec.ConfigValue<Integer> portableCellBattery;
        public final ForgeConfigSpec.ConfigValue<Integer> colorApplicatorBattery;
        public final ForgeConfigSpec.ConfigValue<Integer> chargedStaffBattery;
        public final ForgeConfigSpec.ConfigValue<Integer> quartzOresPerCluster;
        public final ForgeConfigSpec.ConfigValue<Integer> quartzOresClusterAmount;
        public final ForgeConfigSpec.BooleanValue generateQuartzOre;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> quartzOresBiomeBlacklist;
        public final ForgeConfigSpec.BooleanValue spawnPressesInMeteorites;
        public final ForgeConfigSpec.ConfigValue<Double> wirelessBaseCost;
        public final ForgeConfigSpec.ConfigValue<Double> wirelessCostMultiplier;
        public final ForgeConfigSpec.ConfigValue<Double> wirelessTerminalDrainMultiplier;
        public final ForgeConfigSpec.ConfigValue<Double> wirelessBaseRange;
        public final ForgeConfigSpec.ConfigValue<Double> wirelessBoosterRangeMultiplier;
        public final ForgeConfigSpec.ConfigValue<Double> wirelessBoosterExp;
        public final ForgeConfigSpec.ConfigValue<Double> wirelessHighWirelessCount;
        public final ForgeConfigSpec.BooleanValue portableCellDisassembly;
        public final ForgeConfigSpec.ConfigValue<Double> powerRatioForgeEnergy;
        public final ForgeConfigSpec.DoubleValue powerUsageMultiplier;
        public final ForgeConfigSpec.ConfigValue<Integer> condenserMatterBallsPower;
        public final ForgeConfigSpec.ConfigValue<Integer> condenserSingularityPower;
        public final ForgeConfigSpec.ConfigValue<String> improvedFluidTag;
        public final ForgeConfigSpec.ConfigValue<Double> improvedFluidMultiplier;
        public final Map<TickRates, ForgeConfigSpec.ConfigValue<Integer>> tickRateMin = new HashMap<TickRates, ForgeConfigSpec.ConfigValue<Integer>>();
        public final Map<TickRates, ForgeConfigSpec.ConfigValue<Integer>> tickRateMax = new HashMap<TickRates, ForgeConfigSpec.ConfigValue<Integer>>();

        public CommonConfig(ForgeConfigSpec.Builder builder) {
            builder.push("general");
            this.debugTools = builder.define("unsupportedDeveloperTools", false);
            this.matterCannonBlockDamage = builder.comment("Enables the ability of the Matter Cannon to break blocks.").define("matterCannonBlockDamage", true);
            this.tinyTntBlockDamage = builder.comment("Enables the ability of Tiny TNT to break blocks.").define("tinyTntBlockDamage", true);
            this.serverOpsIgnoreSecurity = builder.comment("Server operators are not restricted by ME security terminal settings.").define("serverOpsIgnoreSecurity", true);
            this.channels = builder.comment("Changes the channel capacity that cables provide in AE2.").defineEnum("channels", (Enum)ChannelMode.DEFAULT, (Enum[])ChannelMode.values());
            this.pathfindingStepsPerTick = builder.comment("The number of pathfinding steps that are taken per tick and per grid that is booting. Lower numbers will mean booting takes longer, but less work is done per tick.").defineInRange("pathfindingStepsPerTick", 4, 1, 1024);
            builder.pop();
            builder.push("automation");
            this.formationPlaneEntityLimit = builder.comment("TODO").define("formationPlaneEntityLimit", (Object)128);
            builder.pop();
            builder.push("facades");
            this.allowBlockEntityFacades = builder.comment("Unsupported: Allows whitelisting block entities as facades. Could work, have render issues, or corrupt your world. USE AT YOUR OWN RISK.").define("allowBlockEntities", false);
            builder.pop();
            builder.push("craftingCPU");
            this.craftingCalculationTimePerTick = builder.define("craftingCalculationTimePerTick", (Object)5);
            builder.pop();
            builder.push("crafting");
            this.inWorldSingularity = builder.comment("Enable the in-world crafting of singularities.").define("inWorldSingularity", true);
            this.inWorldFluix = builder.comment("Enable the in-world crafting of fluix crystals.").define("inWorldFluix", true);
            this.inWorldCrystalGrowth = builder.comment("Enable the in-world crafting of pure crystals.").define("inWorldCrystalGrowth", true);
            this.disassemblyCrafting = builder.comment("Enable shift-clicking with the crafting units in hand to disassemble them.").define("disassemblyCrafting", true);
            builder.pop();
            builder.push("spatialio");
            this.spatialPowerMultiplier = builder.define("spatialPowerMultiplier", (Object)1250.0);
            this.spatialPowerExponent = builder.define("spatialPowerExponent", (Object)1.35);
            builder.pop();
            builder.push("logging");
            this.securityAuditLog = builder.define("securityAuditLog", false);
            this.blockUpdateLog = builder.define("blockUpdateLog", false);
            this.packetLog = builder.define("packetLog", false);
            this.craftingLog = builder.define("craftingLog", false);
            this.debugLog = builder.define("debugLog", false);
            this.gridLog = builder.define("gridLog", false);
            this.chunkLoggerTrace = builder.comment("Enable stack trace logging for the chunk loading debug command").define("chunkLoggerTrace", false);
            builder.pop();
            builder.push("battery");
            this.chargerChargeRate = builder.comment("The chargers charging rate factor, which is applied to the charged items charge rate. 2 means it charges everything twice as fast. 0.5 half as fast.").defineInRange("chargerChargeRate", 1.0, 0.1, 10.0);
            this.wirelessTerminalBattery = builder.define("wirelessTerminal", (Object)1600000);
            this.chargedStaffBattery = builder.define("chargedStaff", (Object)8000);
            this.entropyManipulatorBattery = builder.define("entropyManipulator", (Object)200000);
            this.portableCellBattery = builder.define("portableCell", (Object)20000);
            this.colorApplicatorBattery = builder.define("colorApplicator", (Object)20000);
            this.matterCannonBattery = builder.define("matterCannon", (Object)200000);
            builder.pop();
            builder.push("worldGen");
            this.spawnPressesInMeteorites = builder.define("spawnPressesInMeteorites", true);
            this.generateQuartzOre = builder.define("generateQuartzOre", true);
            this.quartzOresPerCluster = builder.define("quartzOresPerCluster", (Object)7);
            this.quartzOresClusterAmount = builder.define("quartzOresClusterAmount", (Object)20);
            this.quartzOresBiomeBlacklist = builder.defineList("quartzOresBiomeBlacklist", Collections.emptyList(), obj -> obj instanceof String && ResourceLocation.m_135830_((String)((String)obj)));
            builder.pop();
            builder.push("wireless");
            this.wirelessBaseCost = builder.define("wirelessBaseCost", (Object)8.0);
            this.wirelessCostMultiplier = builder.define("wirelessCostMultiplier", (Object)1.0);
            this.wirelessBaseRange = builder.define("wirelessBaseRange", (Object)16.0);
            this.wirelessBoosterRangeMultiplier = builder.define("wirelessBoosterRangeMultiplier", (Object)1.0);
            this.wirelessBoosterExp = builder.define("wirelessBoosterExp", (Object)1.5);
            this.wirelessHighWirelessCount = builder.define("wirelessHighWirelessCount", (Object)64.0);
            this.wirelessTerminalDrainMultiplier = builder.define("wirelessTerminalDrainMultiplier", (Object)1.0);
            builder.pop();
            builder.push("PortableCells");
            this.portableCellDisassembly = builder.comment("Allow disassembly of portable cells into the recipe ingredients using shift+right-click").define("allowDisassembly", true);
            builder.push("PowerRatios");
            this.powerRatioForgeEnergy = builder.define("ForgeEnergy", (Object)0.5);
            this.powerUsageMultiplier = builder.defineInRange("UsageMultiplier", 1.0, 0.01, Double.MAX_VALUE);
            builder.pop();
            builder.push("Condenser");
            this.condenserMatterBallsPower = builder.define("MatterBalls", (Object)256);
            this.condenserSingularityPower = builder.define("Singularity", (Object)256000);
            builder.pop();
            builder.comment(" Min / Max Tickrates for dynamic ticking, most of these components also use sleeping, to prevent constant ticking, adjust with care, non standard rates are not supported or tested.").push("tickRates");
            for (TickRates tickRate : TickRates.values()) {
                this.tickRateMin.put(tickRate, (ForgeConfigSpec.ConfigValue<Integer>)builder.define(tickRate.name() + "Min", (Object)tickRate.getDefaultMin()));
                this.tickRateMax.put(tickRate, (ForgeConfigSpec.ConfigValue<Integer>)builder.define(tickRate.name() + "Max", (Object)tickRate.getDefaultMax()));
            }
            builder.pop();
            builder.comment("Settings for in-world growth of crystals.").push("inWorldCrystalGrowth");
            this.improvedFluidTag = builder.comment("A fluid tag that identifies fluids that improve crystal growth speed. Does not affect growth with water/lava.").define("improvedFluidTag", (Object)"");
            this.improvedFluidMultiplier = builder.comment("The speed multiplier to use when the crystals are submerged in the improved fluid.").defineInRange("improvedFluidMultiplier", 2.0, 1.0, 10.0);
            builder.pop();
        }
    }
}

