/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.waila.tile;

import appeng.api.networking.IGridNode;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.parts.IPart;
import appeng.blockentity.AEBaseBlockEntity;
import appeng.core.definitions.AEItems;
import appeng.integration.modules.waila.BaseDataProvider;
import appeng.integration.modules.waila.part.IPartDataProvider;
import appeng.me.InWorldGridNode;
import appeng.me.helpers.IGridConnectedBlockEntity;
import appeng.me.service.TickManagerService;
import appeng.parts.AEBasePart;
import appeng.util.Platform;
import java.util.ArrayList;
import mcp.mobius.waila.api.BlockAccessor;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.config.IPluginConfig;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class DebugDataProvider
extends BaseDataProvider
implements IPartDataProvider {
    private static final String TAG_MAIN_NODE = "debugMainNode";
    private static final String TAG_EXTERNAL_NODE = "debugExposedNode";
    private static final String TAG_TICK_TIME = "tickTime";
    private static final String TAG_TICK_SLEEPING = "tickSleeping";
    private static final String TAG_TICK_ALERTABLE = "tickAlertable";
    private static final String TAG_TICK_AWAKE = "tickAwake";
    private static final String TAG_TICK_QUEUED = "tickQueued";
    private static final String TAG_TICK_CURRENT_RATE = "tickCurrentRate";
    private static final String TAG_TICK_LAST_TICK = "tickLastTick";
    private static final String TAG_NODE_EXPOSED = "exposedSides";

    @Override
    public void appendBodyTooltip(IPart part, CompoundTag partTag, ITooltip tooltip) {
        DebugDataProvider.addToTooltip(partTag, tooltip);
    }

    @Override
    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        if (!DebugDataProvider.isVisible(accessor.getPlayer())) {
            return;
        }
        DebugDataProvider.addBlockEntityRotation(tooltip, accessor);
        DebugDataProvider.addToTooltip(accessor.getServerData(), tooltip);
    }

    private static void addBlockEntityRotation(ITooltip tooltip, BlockAccessor accessor) {
        AEBaseBlockEntity be;
        BlockEntity blockEntity = accessor.getBlockEntity();
        if (blockEntity instanceof AEBaseBlockEntity && (be = (AEBaseBlockEntity)blockEntity).canBeRotated()) {
            Direction up = be.getUp();
            Direction forward = be.getForward();
            tooltip.add((Component)new TextComponent("").m_7220_((Component)new TextComponent("Up: ").m_130940_(ChatFormatting.WHITE)).m_7220_((Component)new TextComponent(up.name())).m_7220_((Component)new TextComponent(" Forward: ").m_130940_(ChatFormatting.WHITE)).m_7220_((Component)new TextComponent(forward.name())));
        }
    }

    private static void addToTooltip(CompoundTag serverData, ITooltip tooltip) {
        boolean hasMainNode = serverData.m_128425_(TAG_MAIN_NODE, 10);
        boolean hasExternalNode = serverData.m_128425_(TAG_EXTERNAL_NODE, 10);
        if (hasMainNode) {
            if (hasExternalNode) {
                tooltip.add((Component)new TextComponent("Main Node").m_130940_(ChatFormatting.ITALIC));
            }
            DebugDataProvider.addNodeToTooltip(serverData.m_128469_(TAG_MAIN_NODE), tooltip);
        }
        if (hasExternalNode) {
            if (hasMainNode) {
                tooltip.add((Component)new TextComponent("External Node").m_130940_(ChatFormatting.ITALIC));
            }
            DebugDataProvider.addNodeToTooltip(serverData.m_128469_(TAG_EXTERNAL_NODE), tooltip);
        }
    }

    private static void addNodeToTooltip(CompoundTag tag, ITooltip tooltip) {
        long[] tickTimes;
        if (tag.m_128425_(TAG_TICK_TIME, 12) && (tickTimes = tag.m_128467_(TAG_TICK_TIME)).length == 3) {
            long avg = tickTimes[0];
            long max = tickTimes[1];
            long sum = tickTimes[2];
            tooltip.add((Component)new TextComponent("").m_7220_((Component)new TextComponent("Tick Time: ").m_130940_(ChatFormatting.WHITE)).m_7220_((Component)new TextComponent("Avg: ").m_130940_(ChatFormatting.ITALIC)).m_7220_((Component)new TextComponent(Platform.formatTimeMeasurement(avg)).m_130940_(ChatFormatting.WHITE)).m_7220_((Component)new TextComponent(" Max: ").m_130940_(ChatFormatting.ITALIC)).m_7220_((Component)new TextComponent(Platform.formatTimeMeasurement(max)).m_130940_(ChatFormatting.WHITE)).m_7220_((Component)new TextComponent(" Sum: ").m_130940_(ChatFormatting.ITALIC)).m_7220_((Component)new TextComponent(Platform.formatTimeMeasurement(sum)).m_130940_(ChatFormatting.WHITE)));
        }
        if (tag.m_128441_(TAG_TICK_QUEUED)) {
            ArrayList<String> status = new ArrayList<String>();
            if (tag.m_128471_(TAG_TICK_SLEEPING)) {
                status.add("Sleeping");
            }
            if (tag.m_128471_(TAG_TICK_ALERTABLE)) {
                status.add("Alertable");
            }
            if (tag.m_128471_(TAG_TICK_AWAKE)) {
                status.add("Awake");
            }
            if (tag.m_128471_(TAG_TICK_QUEUED)) {
                status.add("Queued");
            }
            tooltip.add((Component)new TextComponent("").m_7220_((Component)new TextComponent("Tick Status: ").m_130940_(ChatFormatting.WHITE)).m_130946_(String.join((CharSequence)", ", status)));
            tooltip.add((Component)new TextComponent("").m_7220_((Component)new TextComponent("Tick Rate: ").m_130940_(ChatFormatting.WHITE)).m_130946_(String.valueOf(tag.m_128451_(TAG_TICK_CURRENT_RATE))).m_7220_((Component)new TextComponent(" Last: ").m_130940_(ChatFormatting.WHITE)).m_130946_(tag.m_128451_(TAG_TICK_LAST_TICK) + " ticks ago"));
        }
        if (tag.m_128425_(TAG_NODE_EXPOSED, 3)) {
            int exposedSides = tag.m_128451_(TAG_NODE_EXPOSED);
            MutableComponent line = new TextComponent("Node Exposed: ").m_130940_(ChatFormatting.WHITE);
            for (Direction value : Direction.values()) {
                TextComponent sideText = new TextComponent(value.name().substring(0, 1));
                if ((exposedSides & 1 << value.ordinal()) == 0) {
                    sideText.m_130940_(ChatFormatting.GRAY);
                } else {
                    sideText.m_130940_(ChatFormatting.GREEN);
                }
                line.m_7220_((Component)sideText);
            }
            tooltip.add((Component)line);
        }
    }

    @Override
    public void appendServerData(ServerPlayer player, IPart part, CompoundTag partTag) {
        if (DebugDataProvider.isVisible((Player)player) && part instanceof AEBasePart) {
            AEBasePart basePart = (AEBasePart)part;
            DebugDataProvider.addServerDataMainNode(partTag, basePart.getMainNode());
            CompoundTag externalNodeTag = DebugDataProvider.toServerData(basePart.getExternalFacingNode());
            if (externalNodeTag != null) {
                partTag.m_128365_(TAG_EXTERNAL_NODE, (Tag)externalNodeTag);
            }
        }
    }

    @Override
    public void appendServerData(CompoundTag tag, ServerPlayer player, Level level, BlockEntity blockEntity, boolean showDetails) {
        if (DebugDataProvider.isVisible((Player)player) && blockEntity instanceof IGridConnectedBlockEntity) {
            IGridConnectedBlockEntity gridConnected = (IGridConnectedBlockEntity)blockEntity;
            DebugDataProvider.addServerDataMainNode(tag, gridConnected.getMainNode());
        }
    }

    private static void addServerDataMainNode(CompoundTag tag, IManagedGridNode managedGridNode) {
        CompoundTag nodeTag;
        IGridNode node = managedGridNode.getNode();
        if (node != null && (nodeTag = DebugDataProvider.toServerData(managedGridNode.getNode())) != null) {
            tag.m_128365_(TAG_MAIN_NODE, (Tag)nodeTag);
        }
    }

    private static CompoundTag toServerData(IGridNode node) {
        if (node == null) {
            return null;
        }
        CompoundTag tag = new CompoundTag();
        if (node.getService(IGridTickable.class) != null) {
            TickManagerService tickManager = (TickManagerService)node.getGrid().getTickManager();
            long avg = tickManager.getAverageTime(node);
            long max = tickManager.getMaximumTime(node);
            long sum = tickManager.getOverallTime(node);
            tag.m_128388_(TAG_TICK_TIME, new long[]{avg, max, sum});
            TickManagerService.NodeStatus status = tickManager.getStatus(node);
            tag.m_128379_(TAG_TICK_SLEEPING, status.sleeping());
            tag.m_128379_(TAG_TICK_ALERTABLE, status.alertable());
            tag.m_128379_(TAG_TICK_AWAKE, status.awake());
            tag.m_128379_(TAG_TICK_QUEUED, status.queued());
            tag.m_128405_(TAG_TICK_CURRENT_RATE, status.currentRate());
            tag.m_128356_(TAG_TICK_LAST_TICK, status.lastTick());
        }
        if (node instanceof InWorldGridNode) {
            int exposedSides = 0;
            for (Direction value : Direction.values()) {
                if (!node.isExposedOnSide(value)) continue;
                exposedSides |= 1 << value.ordinal();
            }
            tag.m_128405_(TAG_NODE_EXPOSED, exposedSides);
        }
        return tag;
    }

    private static boolean isVisible(Player player) {
        return AEItems.DEBUG_CARD.isSameAs(player.m_21120_(InteractionHand.OFF_HAND)) || AEItems.DEBUG_CARD.isSameAs(player.m_21120_(InteractionHand.MAIN_HAND));
    }
}

