/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.forge.client;

import com.mojang.math.Matrix4f;
import com.mojang.math.Transformation;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.blay09.mods.balm.forge.client.rendering.ForgeBalmModels;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.ForgeModelBakery;
import net.minecraftforge.client.model.SimpleModelState;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class CachedDynamicModel
implements BakedModel {
    private final Map<String, BakedModel> cache = new HashMap<String, BakedModel>();
    private final Map<ResourceLocation, BakedModel> baseModelCache = new HashMap<ResourceLocation, BakedModel>();
    private final ModelBakery modelBakery;
    private final Function<BlockState, ResourceLocation> baseModelFunction;
    private final List<Pair<Predicate<BlockState>, BakedModel>> parts;
    private final Function<BlockState, Map<String, String>> textureMapFunction;
    private final BiConsumer<BlockState, Matrix4f> transformFunction;
    private final ResourceLocation location;
    private TextureAtlasSprite particleTexture;

    public CachedDynamicModel(ModelBakery modelBakery, Function<BlockState, ResourceLocation> baseModelFunction, @Nullable List<Pair<Predicate<BlockState>, BakedModel>> parts, @Nullable Function<BlockState, Map<String, String>> textureMapFunction, @Nullable BiConsumer<BlockState, Matrix4f> transformFunction, ResourceLocation location) {
        this.modelBakery = modelBakery;
        this.baseModelFunction = baseModelFunction;
        this.parts = parts;
        this.textureMapFunction = textureMapFunction;
        this.transformFunction = transformFunction;
        this.location = location;
    }

    public List<BakedQuad> m_6840_(@Nullable BlockState state, @Nullable Direction side, Random rand) {
        if (state != null) {
            Matrix4f transform = BlockModelRotation.X0_Y0.m_6189_().m_121104_();
            String stateString = state.toString();
            BakedModel bakedModel = this.cache.get(stateString);
            if (bakedModel == null) {
                if (this.transformFunction != null) {
                    this.transformFunction.accept(state, transform);
                }
                SimpleModelState modelTransform = new SimpleModelState(new Transformation(transform));
                ResourceLocation baseModelLocation = this.baseModelFunction.apply(state);
                if (this.textureMapFunction != null && !this.baseModelCache.containsKey(baseModelLocation)) {
                    UnbakedModel baseModel = ForgeModelBakery.instance().getModelOrMissing(baseModelLocation);
                    BakedModel bakedBaseModel = baseModel.m_7611_(this.modelBakery, ForgeModelBakery.defaultTextureGetter(), (ModelState)modelTransform, baseModelLocation);
                    this.baseModelCache.put(baseModelLocation, bakedBaseModel);
                }
                UnbakedModel retexturedBaseModel = this.textureMapFunction != null ? ForgeBalmModels.retexture(this.modelBakery, baseModelLocation, this.textureMapFunction.apply(state)) : ForgeModelBakery.instance().getModelOrMissing(baseModelLocation);
                bakedModel = retexturedBaseModel.m_7611_(this.modelBakery, ForgeModelBakery.defaultTextureGetter(), (ModelState)modelTransform, this.location);
                this.cache.put(stateString, bakedModel);
                if (this.particleTexture == null && bakedModel != null) {
                    this.particleTexture = bakedModel.m_6160_();
                }
            }
            return bakedModel != null ? bakedModel.m_6840_(state, side, rand) : Collections.emptyList();
        }
        return Collections.emptyList();
    }

    public boolean m_7541_() {
        return true;
    }

    public boolean m_7539_() {
        return true;
    }

    public boolean m_7547_() {
        return false;
    }

    public boolean m_7521_() {
        return false;
    }

    public TextureAtlasSprite m_6160_() {
        return this.particleTexture != null ? this.particleTexture : ForgeModelBakery.White.instance();
    }

    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }
}

