/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.blocks;

import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Tables;
import com.google.common.collect.TreeBasedTable;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.shapes.VoxelShape;
import thelm.jaopca.api.blocks.IBlockFormSettings;
import thelm.jaopca.api.blocks.IBlockFormType;
import thelm.jaopca.api.blocks.IBlockInfo;
import thelm.jaopca.api.blocks.IMaterialFormBlock;
import thelm.jaopca.api.blocks.IMaterialFormBlockItem;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.blocks.BlockFormSettings;
import thelm.jaopca.blocks.BlockInfo;
import thelm.jaopca.custom.json.BlockFormSettingsDeserializer;
import thelm.jaopca.custom.json.MaterialMappedFunctionDeserializer;
import thelm.jaopca.custom.json.VoxelShapeDeserializer;
import thelm.jaopca.custom.utils.BlockDeserializationHelper;
import thelm.jaopca.data.DataInjector;
import thelm.jaopca.forms.FormTypeHandler;
import thelm.jaopca.registries.RegistryHandler;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

public class BlockFormType
implements IBlockFormType {
    public static final BlockFormType INSTANCE = new BlockFormType();
    private static final TreeSet<IForm> FORMS = new TreeSet();
    private static final TreeBasedTable<IForm, IMaterial, java.util.function.Supplier<IMaterialFormBlock>> BLOCKS = TreeBasedTable.create();
    private static final TreeBasedTable<IForm, IMaterial, java.util.function.Supplier<IMaterialFormBlockItem>> BLOCK_ITEMS = TreeBasedTable.create();
    private static final TreeBasedTable<IForm, IMaterial, IBlockInfo> BLOCK_INFOS = TreeBasedTable.create();
    public static final Type MATERIAL_FUNCTION_TYPE = new TypeToken<Function<IMaterial, Material>>(){}.getType();
    public static final Type SOUND_TYPE_FUNCTION_TYPE = new TypeToken<Function<IMaterial, SoundType>>(){}.getType();

    private BlockFormType() {
    }

    public static void init() {
        FormTypeHandler.registerFormType(INSTANCE);
    }

    @Override
    public String getName() {
        return "block";
    }

    @Override
    public void addForm(IForm form) {
        FORMS.add(form);
    }

    @Override
    public Set<IForm> getForms() {
        return Collections.unmodifiableNavigableSet(FORMS);
    }

    @Override
    public boolean shouldRegister(IForm form, IMaterial material) {
        ResourceLocation tagLocation = MiscHelper.INSTANCE.getTagLocation(form.getSecondaryName(), material.getName(), form.getTagSeparator());
        return !ApiImpl.INSTANCE.getItemTags().contains(tagLocation);
    }

    @Override
    public IBlockInfo getMaterialFormInfo(IForm form, IMaterial material) {
        IBlockInfo info = (IBlockInfo)BLOCK_INFOS.get((Object)form, (Object)material);
        if (info == null && FORMS.contains(form) && form.getMaterials().contains(material)) {
            info = new BlockInfo((IMaterialFormBlock)((java.util.function.Supplier)BLOCKS.get((Object)form, (Object)material)).get(), (IMaterialFormBlockItem)((java.util.function.Supplier)BLOCK_ITEMS.get((Object)form, (Object)material)).get());
            BLOCK_INFOS.put((Object)form, (Object)material, (Object)info);
        }
        return info;
    }

    @Override
    public IBlockFormSettings getNewSettings() {
        return new BlockFormSettings();
    }

    @Override
    public GsonBuilder configureGsonBuilder(GsonBuilder builder) {
        return builder.registerTypeAdapter(MATERIAL_FUNCTION_TYPE, new MaterialMappedFunctionDeserializer<Material>(BlockDeserializationHelper.INSTANCE::getBlockMaterial, BlockDeserializationHelper.INSTANCE::getBlockMaterialName)).registerTypeAdapter(SOUND_TYPE_FUNCTION_TYPE, new MaterialMappedFunctionDeserializer<SoundType>(BlockDeserializationHelper.INSTANCE::getSoundType, BlockDeserializationHelper.INSTANCE::getSoundTypeName)).registerTypeAdapter(VoxelShape.class, (Object)VoxelShapeDeserializer.INSTANCE);
    }

    @Override
    public IBlockFormSettings deserializeSettings(JsonElement jsonElement, JsonDeserializationContext context) {
        return BlockFormSettingsDeserializer.INSTANCE.deserialize(jsonElement, context);
    }

    public static void registerEntries() {
        MiscHelper helper = MiscHelper.INSTANCE;
        for (IForm form : FORMS) {
            IBlockFormSettings settings = (IBlockFormSettings)form.getSettings();
            String secondaryName = form.getSecondaryName();
            String tagSeparator = form.getTagSeparator();
            for (IMaterial material : form.getMaterials()) {
                String name = form.getName() + "." + material.getName();
                ResourceLocation registryName = new ResourceLocation("jaopca", name);
                ResourceLocation lootLocation = new ResourceLocation("jaopca", "blocks/" + name);
                String toolTag = settings.getHarvestToolTagFunction().apply(material);
                String tierTag = settings.getHarvestTierTagFunction().apply(material);
                Supplier materialFormBlock = Suppliers.memoize(() -> settings.getBlockCreator().create(form, material, settings));
                BLOCKS.put((Object)form, (Object)material, (Object)materialFormBlock);
                RegistryHandler.registerForgeRegistryEntry(Registry.f_122901_, name, () -> BlockFormType.lambda$registerEntries$1((java.util.function.Supplier)materialFormBlock));
                Supplier materialFormBlockItem = Suppliers.memoize(() -> BlockFormType.lambda$registerEntries$2(settings, (java.util.function.Supplier)materialFormBlock));
                BLOCK_ITEMS.put((Object)form, (Object)material, (Object)materialFormBlockItem);
                RegistryHandler.registerForgeRegistryEntry(Registry.f_122904_, name, () -> BlockFormType.lambda$registerEntries$3((java.util.function.Supplier)materialFormBlockItem));
                DataInjector.registerLootTable(lootLocation, () -> BlockFormType.lambda$registerEntries$4(settings, (java.util.function.Supplier)materialFormBlock));
                DataInjector.registerBlockTag(helper.createResourceLocation(secondaryName), registryName);
                DataInjector.registerBlockTag(helper.getTagLocation(secondaryName, material.getName(), tagSeparator), registryName);
                for (String alternativeName : material.getAlternativeNames()) {
                    DataInjector.registerBlockTag(helper.getTagLocation(secondaryName, alternativeName, tagSeparator), registryName);
                }
                DataInjector.registerBlockTag(new ResourceLocation(toolTag), registryName);
                if (!Strings.isNullOrEmpty((String)tierTag)) {
                    DataInjector.registerBlockTag(new ResourceLocation(tierTag), registryName);
                }
                DataInjector.registerItemTag(helper.createResourceLocation(secondaryName), registryName);
                DataInjector.registerItemTag(helper.getTagLocation(secondaryName, material.getName(), tagSeparator), registryName);
                for (String alternativeName : material.getAlternativeNames()) {
                    DataInjector.registerItemTag(helper.getTagLocation(secondaryName, alternativeName, tagSeparator), registryName);
                }
            }
        }
    }

    public static Collection<IMaterialFormBlock> getBlocks() {
        return Tables.transformValues(BLOCKS, java.util.function.Supplier::get).values();
    }

    public static Collection<IMaterialFormBlockItem> getBlockItems() {
        return Tables.transformValues(BLOCK_ITEMS, java.util.function.Supplier::get).values();
    }

    private static /* synthetic */ LootTable lambda$registerEntries$4(IBlockFormSettings settings, java.util.function.Supplier materialFormBlock) {
        return settings.getBlockLootTableCreator().create((IMaterialFormBlock)materialFormBlock.get(), settings);
    }

    private static /* synthetic */ BlockItem lambda$registerEntries$3(java.util.function.Supplier materialFormBlockItem) {
        return ((IMaterialFormBlockItem)materialFormBlockItem.get()).asBlockItem();
    }

    private static /* synthetic */ IMaterialFormBlockItem lambda$registerEntries$2(IBlockFormSettings settings, java.util.function.Supplier materialFormBlock) {
        return settings.getBlockItemCreator().create((IMaterialFormBlock)materialFormBlock.get(), settings);
    }

    private static /* synthetic */ Block lambda$registerEntries$1(java.util.function.Supplier materialFormBlock) {
        return ((IMaterialFormBlock)materialFormBlock.get()).asBlock();
    }
}

