/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.blocks;

import java.util.Optional;
import java.util.OptionalInt;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.crafting.RecipeType;
import thelm.jaopca.api.blocks.IBlockFormSettings;
import thelm.jaopca.api.blocks.IMaterialFormBlock;
import thelm.jaopca.api.blocks.IMaterialFormBlockItem;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.materialforms.IMaterialForm;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.items.ItemFormType;
import thelm.jaopca.utils.ApiImpl;

public class JAOPCABlockItem
extends BlockItem
implements IMaterialFormBlockItem {
    protected final IBlockFormSettings settings;
    protected OptionalInt itemStackLimit = OptionalInt.empty();
    protected Optional<Boolean> hasEffect = Optional.empty();
    protected Optional<Rarity> f_41369_ = Optional.empty();
    protected OptionalInt burnTime = OptionalInt.empty();

    public JAOPCABlockItem(IMaterialFormBlock block, IBlockFormSettings settings) {
        super(block.asBlock(), new Item.Properties().m_41491_(ItemFormType.getCreativeTab()));
        this.settings = settings;
    }

    @Override
    public IForm getForm() {
        return ((IMaterialForm)this.m_40614_()).getForm();
    }

    @Override
    public IMaterial getMaterial() {
        return ((IMaterialForm)this.m_40614_()).getMaterial();
    }

    public int getItemStackLimit(ItemStack stack) {
        if (!this.itemStackLimit.isPresent()) {
            this.itemStackLimit = OptionalInt.of(this.settings.getItemStackLimitFunction().applyAsInt(this.getMaterial()));
        }
        return this.itemStackLimit.getAsInt();
    }

    public boolean m_5812_(ItemStack stack) {
        if (!this.hasEffect.isPresent()) {
            this.hasEffect = Optional.of(this.settings.getHasEffectFunction().test(this.getMaterial()));
        }
        return this.hasEffect.get() != false || super.m_5812_(stack);
    }

    public Rarity m_41460_(ItemStack stack) {
        if (!this.f_41369_.isPresent()) {
            this.f_41369_ = Optional.of(this.settings.getDisplayRarityFunction().apply(this.getMaterial()));
        }
        return this.f_41369_.get();
    }

    public int getBurnTime(ItemStack itemStack, RecipeType<?> recipeType) {
        if (!this.burnTime.isPresent()) {
            this.burnTime = OptionalInt.of(this.settings.getBurnTimeFunction().applyAsInt(this.getMaterial()));
        }
        return this.burnTime.getAsInt();
    }

    public Component m_7626_(ItemStack stack) {
        return ApiImpl.INSTANCE.currentLocalizer().localizeMaterialForm("block.jaopca." + this.getForm().getName(), this.getMaterial(), this.m_5671_(stack));
    }
}

