/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.client.models;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.ForgeModelBakery;
import thelm.jaopca.api.blocks.IMaterialFormBlock;
import thelm.jaopca.api.blocks.IMaterialFormBlockItem;
import thelm.jaopca.api.fluids.IMaterialFormBucketItem;
import thelm.jaopca.api.fluids.IMaterialFormFluidBlock;
import thelm.jaopca.api.items.IMaterialFormItem;
import thelm.jaopca.blocks.BlockFormType;
import thelm.jaopca.fluids.FluidFormType;
import thelm.jaopca.items.ItemFormType;

public class ModelHandler {
    private static final Multimap<ResourceLocation, ResourceLocation> REMAPS = LinkedHashMultimap.create();

    public static void registerModels() {
        ModelResourceLocation defaultModelLocation;
        ModelResourceLocation modelLocation;
        ResourceLocation location;
        ResourceManager resourceManager = Minecraft.m_91087_().m_91098_();
        for (IMaterialFormBlock materialFormBlock : BlockFormType.getBlocks()) {
            Block block = materialFormBlock.asBlock();
            location = block.getRegistryName();
            if (resourceManager.m_7165_(location = new ResourceLocation(location.m_135827_(), "blockstates/" + location.m_135815_() + ".json"))) continue;
            block.m_49965_().m_61056_().forEach(state -> {
                String propertyMapString = BlockModelShaper.m_110887_((Map)state.m_61148_());
                ModelResourceLocation modelLocation = new ModelResourceLocation(block.getRegistryName(), propertyMapString);
                ModelResourceLocation defaultModelLocation = new ModelResourceLocation("jaopca:" + materialFormBlock.getMaterial().getModelType() + "/" + materialFormBlock.getForm().getName(), propertyMapString);
                ForgeModelBakery.addSpecialModel((ResourceLocation)defaultModelLocation);
                REMAPS.put((Object)defaultModelLocation, (Object)modelLocation);
            });
        }
        for (IMaterialFormBlockItem materialFormBlockItem : BlockFormType.getBlockItems()) {
            BlockItem blockItem = materialFormBlockItem.asBlockItem();
            location = blockItem.getRegistryName();
            if (resourceManager.m_7165_(location = new ResourceLocation(location.m_135827_(), "item/models/" + location.m_135815_() + ".json"))) continue;
            modelLocation = new ModelResourceLocation(blockItem.getRegistryName(), "inventory");
            defaultModelLocation = new ModelResourceLocation("jaopca:" + materialFormBlockItem.getMaterial().getModelType() + "/" + materialFormBlockItem.getForm().getName(), "inventory");
            ForgeModelBakery.addSpecialModel((ResourceLocation)defaultModelLocation);
            REMAPS.put((Object)defaultModelLocation, (Object)modelLocation);
        }
        for (IMaterialFormItem materialFormItem : ItemFormType.getItems()) {
            Item item = materialFormItem.asItem();
            location = item.getRegistryName();
            if (resourceManager.m_7165_(location = new ResourceLocation(location.m_135827_(), "item/models/" + location.m_135815_() + ".json"))) continue;
            modelLocation = new ModelResourceLocation(item.getRegistryName(), "inventory");
            defaultModelLocation = new ModelResourceLocation("jaopca:" + materialFormItem.getMaterial().getModelType() + "/" + materialFormItem.getForm().getName(), "inventory");
            ForgeModelBakery.addSpecialModel((ResourceLocation)defaultModelLocation);
            REMAPS.put((Object)defaultModelLocation, (Object)modelLocation);
        }
        for (IMaterialFormFluidBlock materialFormFluidBlock : FluidFormType.getFluidBlocks()) {
            Block fluidBlock = materialFormFluidBlock.asBlock();
            location = fluidBlock.getRegistryName();
            if (resourceManager.m_7165_(location = new ResourceLocation(location.m_135827_(), "blockstates/" + location.m_135815_() + ".json"))) continue;
            fluidBlock.m_49965_().m_61056_().forEach(state -> {
                String propertyMapString = BlockModelShaper.m_110887_((Map)state.m_61148_());
                ModelResourceLocation modelLocation = new ModelResourceLocation(fluidBlock.getRegistryName(), propertyMapString);
                ModelResourceLocation defaultModelLocation = new ModelResourceLocation("jaopca:" + materialFormFluidBlock.getMaterial().getModelType() + "/" + materialFormFluidBlock.getForm().getName(), propertyMapString);
                ForgeModelBakery.addSpecialModel((ResourceLocation)defaultModelLocation);
                REMAPS.put((Object)defaultModelLocation, (Object)modelLocation);
            });
        }
        for (IMaterialFormBucketItem materialFormBucketItem : FluidFormType.getBucketItems()) {
            Item bucketItem = materialFormBucketItem.asItem();
            location = bucketItem.getRegistryName();
            if (resourceManager.m_7165_(location = new ResourceLocation(location.m_135827_(), "item/models/" + location.m_135815_() + ".json"))) continue;
            modelLocation = new ModelResourceLocation(bucketItem.getRegistryName(), "inventory");
            defaultModelLocation = new ModelResourceLocation("jaopca:" + materialFormBucketItem.getMaterial().getModelType() + "/" + materialFormBucketItem.getForm().getName(), "inventory");
            ForgeModelBakery.addSpecialModel((ResourceLocation)defaultModelLocation);
            REMAPS.put((Object)defaultModelLocation, (Object)modelLocation);
        }
    }

    public static void remapModels(ModelBakeEvent event) {
        ResourceManager resourceManager = Minecraft.m_91087_().m_91098_();
        Map modelRegistry = event.getModelRegistry();
        BakedModel missingModel = (BakedModel)modelRegistry.get(ModelBakery.f_119230_);
        for (Map.Entry entry : REMAPS.asMap().entrySet()) {
            BakedModel defaultModel = modelRegistry.getOrDefault(entry.getKey(), missingModel);
            for (ResourceLocation modelLocation : (Collection)entry.getValue()) {
                modelRegistry.put(modelLocation, defaultModel);
            }
        }
    }
}

