/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.assemblylinemachines;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import thelm.jaopca.api.JAOPCAApi;
import thelm.jaopca.api.config.IDynamicSpecConfig;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.api.modules.JAOPCAModule;
import thelm.jaopca.compat.assemblylinemachines.AssemblyLineMachinesHelper;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

@JAOPCAModule(modDependencies={"assemblylinemachines"})
public class AssemblyLineMachinesCompatModule
implements IModule {
    private static final Set<String> TO_DUST_BLACKLIST = new TreeSet<String>(Arrays.asList("chromium", "coal", "copper", "diamond", "flerovium", "gold", "iron", "lapis", "netherite", "netherite_scrap", "titanium"));
    private static final Set<String> TO_PLATE_BLACKLIST = new TreeSet<String>(Arrays.asList("attuned_titanium", "chromium", "copper", "energized_gold", "flerovium", "gold", "iron", "mystium", "novasteel", "steel", "titanium"));
    private static Set<String> configToDustBlacklist = new TreeSet<String>();
    private static Set<String> configToPlateBlacklist = new TreeSet<String>();
    private static Set<String> configHammerToPlateBlacklist = new TreeSet<String>();

    @Override
    public String getName() {
        return "assemblylinemachines_compat";
    }

    @Override
    public Set<MaterialType> getMaterialTypes() {
        return EnumSet.allOf(MaterialType.class);
    }

    @Override
    public void defineModuleConfig(IModuleData moduleData, IDynamicSpecConfig config) {
        MiscHelper helper = MiscHelper.INSTANCE;
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.toDustMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have grinder to dust recipes added."), configToDustBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.toPlateMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have metal shaper to plate recipes added."), configToPlateBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.toDustMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have hammer to plate recipes added."), configHammerToPlateBlacklist);
    }

    @Override
    public void onCommonSetup(IModuleData moduleData, FMLCommonSetupEvent event) {
        ApiImpl api = ApiImpl.INSTANCE;
        AssemblyLineMachinesHelper helper = AssemblyLineMachinesHelper.INSTANCE;
        MiscHelper miscHelper = MiscHelper.INSTANCE;
        for (IMaterial material : moduleData.getMaterials()) {
            ResourceLocation plateLocation;
            ResourceLocation materialLocation;
            MaterialType type = material.getType();
            String name = material.getName();
            if (!(type.isDust() || TO_DUST_BLACKLIST.contains(name) || configToDustBlacklist.contains(name))) {
                materialLocation = miscHelper.getTagLocation(material.getType().getFormName(), material.getName());
                ResourceLocation dustLocation = miscHelper.getTagLocation("dusts", material.getName());
                if (((JAOPCAApi)api).getItemTags().contains(dustLocation)) {
                    helper.registerGrinderRecipe(new ResourceLocation("jaopca", "assemblylinemachines.material_to_dust." + material.getName()), materialLocation, dustLocation, 1, 5, 2, false, 0.0f);
                }
            }
            if (type.isIngot() && !TO_PLATE_BLACKLIST.contains(name) && !configToPlateBlacklist.contains(name)) {
                materialLocation = miscHelper.getTagLocation(material.getType().getFormName(), material.getName());
                plateLocation = miscHelper.getTagLocation("plates", material.getName());
                if (((JAOPCAApi)api).getItemTags().contains(plateLocation)) {
                    helper.registerMetalRecipe(new ResourceLocation("jaopca", "assemblylinemachines.material_to_plate_metal." + material.getName()), materialLocation, plateLocation, 1, 6);
                }
            }
            if (!type.isIngot() || TO_PLATE_BLACKLIST.contains(name) || configHammerToPlateBlacklist.contains(name)) continue;
            materialLocation = miscHelper.getTagLocation(material.getType().getFormName(), material.getName());
            plateLocation = miscHelper.getTagLocation("plates", material.getName());
            ResourceLocation hammerLocation = new ResourceLocation("assemblylinemachines:crafting/hammers");
            if (!((JAOPCAApi)api).getItemTags().contains(plateLocation)) continue;
            ((JAOPCAApi)api).registerShapelessRecipe(new ResourceLocation("jaopca", "assemblylinemachines.material_to_plate_hammer." + material.getName()), plateLocation, 1, materialLocation, hammerLocation);
        }
    }
}

