/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.kubejs.utils;

import com.google.common.collect.TreeBasedTable;
import dev.latvian.mods.kubejs.fluid.EmptyFluidStackJS;
import dev.latvian.mods.kubejs.fluid.FluidStackJS;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import thelm.jaopca.api.blocks.IBlockLike;
import thelm.jaopca.api.fluids.IFluidLike;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.materialforms.IMaterialFormInfo;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.compat.kubejs.utils.Form;
import thelm.jaopca.compat.kubejs.utils.Material;
import thelm.jaopca.utils.MiscHelper;

public class MaterialForm {
    private static final TreeBasedTable<IForm, IMaterial, MaterialForm> MATERIAL_FORM_WRAPPERS = TreeBasedTable.create();
    private final IMaterialFormInfo info;

    public static MaterialForm getMaterialFormWrapper(IForm form, IMaterial material) {
        MaterialForm materialForm = (MaterialForm)MATERIAL_FORM_WRAPPERS.get((Object)form, (Object)material);
        if (materialForm == null) {
            IMaterialFormInfo info = form.getType().getMaterialFormInfo(form, material);
            materialForm = new MaterialForm(info);
        }
        return materialForm;
    }

    private MaterialForm(IMaterialFormInfo info) {
        this.info = info;
    }

    public IMaterialFormInfo getInternal() {
        return this.info;
    }

    public Form getForm() {
        return Form.getFormWrapper(this.info.getMaterialForm().getForm());
    }

    public Material getMaterial() {
        return Material.getMaterialWrapper(this.info.getMaterialForm().getMaterial());
    }

    public String asTag() {
        return MiscHelper.INSTANCE.getTagLocation(this.info.getMaterialForm().getForm().getSecondaryName(), this.info.getMaterialForm().getMaterial().getName(), this.info.getMaterialForm().getForm().getTagSeparator()).toString();
    }

    public ItemStackJS asItemStack(int count) {
        return ItemStackJS.of((Object)this.info);
    }

    public ItemStackJS asItemStack() {
        return this.asItemStack(1);
    }

    public FluidStackJS asFluidStack(int amount) {
        if (!(this.info instanceof IFluidLike)) {
            return EmptyFluidStackJS.INSTANCE;
        }
        return FluidStackJS.of((Object)((IFluidLike)((Object)this.info)).asFluid(), (long)amount, null);
    }

    public Block asBlock() {
        if (!(this.info instanceof IBlockLike)) {
            return null;
        }
        return ((IBlockLike)((Object)this.info)).asBlock();
    }

    public BlockState asBlockState() {
        if (!(this.info instanceof IBlockLike)) {
            return null;
        }
        return ((IBlockLike)((Object)this.info)).asBlock().m_49966_();
    }
}

