/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.tconstruct;

import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.ToIntFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import slimeknights.tconstruct.library.recipe.melting.IMeltingRecipe;
import thelm.jaopca.api.JAOPCAApi;
import thelm.jaopca.api.config.IDynamicSpecConfig;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.ingredients.CompoundIngredientObject;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.api.modules.JAOPCAModule;
import thelm.jaopca.compat.tconstruct.TConstructHelper;
import thelm.jaopca.fluids.FluidFormType;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

@JAOPCAModule(modDependencies={"tconstruct"})
public class TConstructModule
implements IModule {
    private static final Set<String> BLACKLIST = new TreeSet<String>(Arrays.asList("aluminum", "aluminium", "amethyst", "cobalt", "copper", "debris", "diamond", "emerald", "gold", "iron", "lead", "netherite", "netherite_scrap", "nickel", "osmium", "platinum", "quartz", "silver", "tin", "tungsten", "uranium", "zinc"));
    private static boolean jaopcaOnly = true;

    @Override
    public String getName() {
        return "tconstruct";
    }

    @Override
    public Multimap<Integer, String> getModuleDependencies() {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        builder.put((Object)0, (Object)"molten");
        builder.put((Object)1, (Object)"molten");
        return builder.build();
    }

    @Override
    public Set<MaterialType> getMaterialTypes() {
        return EnumSet.of(MaterialType.INGOT, MaterialType.INGOT_LEGACY, MaterialType.GEM, MaterialType.CRYSTAL);
    }

    @Override
    public Set<String> getDefaultMaterialBlacklist() {
        return BLACKLIST;
    }

    @Override
    public void defineModuleConfig(IModuleData moduleData, IDynamicSpecConfig config) {
        jaopcaOnly = config.getDefinedBoolean("recipes.jaopcaOnly", jaopcaOnly, "Should the module only add recipes for materials with JAOPCA molten fluids.");
    }

    @Override
    public void onCommonSetup(IModuleData moduleData, FMLCommonSetupEvent event) {
        ApiImpl api = ApiImpl.INSTANCE;
        TConstructHelper helper = TConstructHelper.INSTANCE;
        MiscHelper miscHelper = MiscHelper.INSTANCE;
        FluidFormType fluidFormType = FluidFormType.INSTANCE;
        IForm moltenForm = ((JAOPCAApi)api).getForm("molten");
        Set<IMaterial> moltenMaterials = moltenForm.getMaterials();
        ResourceLocation metalTooltipLocation = new ResourceLocation("tconstruct:tooltips/metal");
        ResourceLocation gemTooltipLocation = new ResourceLocation("tconstruct:tooltips/gem_large");
        ResourceLocation sparseOreLocation = new ResourceLocation("forge:ore_rates/sparse");
        ResourceLocation denseOreLocation = new ResourceLocation("forge:ore_rates/dense");
        ToIntFunction<FluidStack> tempFunction = stack -> stack.getFluid().getAttributes().getTemperature(stack) - 300;
        for (IMaterial material : moltenMaterials) {
            ((JAOPCAApi)api).registerFluidTag(material.getType().isIngot() ? metalTooltipLocation : gemTooltipLocation, fluidFormType.getMaterialFormInfo(moltenForm, material).asFluid());
        }
        for (IMaterial material : moduleData.getMaterials()) {
            int rate;
            if (jaopcaOnly && !moltenMaterials.contains(material)) continue;
            ResourceLocation oreLocation = miscHelper.getTagLocation("ores", material.getName());
            ResourceLocation moltenLocation = miscHelper.getTagLocation("molten", material.getName(), "_");
            ResourceLocation extraMoltenLocation = miscHelper.getTagLocation("molten", material.getExtra(1).getName(), "_");
            boolean isIngot = material.getType().isIngot();
            boolean isByIngot = material.getExtra(1).getType().isIngot();
            int baseAmount = isIngot ? 90 : 100;
            int baseByAmount = isByIngot ? 90 : 100;
            int n = rate = isIngot ? 0 : 1;
            if (material.hasExtra(1)) {
                helper.registerOreMeltingRecipe(new ResourceLocation("jaopca", "tconstruct.ore_to_molten_singular." + material.getName()), CompoundIngredientObject.difference(oreLocation, sparseOreLocation, denseOreLocation), (Object)moltenLocation, isIngot ? baseAmount * 2 : baseAmount, rate, tempFunction, this.getMeltTimeFunction(isIngot ? 2.5f : 1.5f), extraMoltenLocation, isByIngot ? baseByAmount * 2 : baseByAmount);
                helper.registerOreMeltingRecipe(new ResourceLocation("jaopca", "tconstruct.ore_to_molten_sparse." + material.getName()), CompoundIngredientObject.intersection(oreLocation, sparseOreLocation), (Object)moltenLocation, isIngot ? baseAmount : baseAmount / 2, rate, tempFunction, this.getMeltTimeFunction(isIngot ? 1.5f : 1.0f), extraMoltenLocation, isByIngot ? baseByAmount : baseByAmount / 2);
                helper.registerOreMeltingRecipe(new ResourceLocation("jaopca", "tconstruct.ore_to_molten_dense." + material.getName()), CompoundIngredientObject.intersection(oreLocation, denseOreLocation), (Object)moltenLocation, isIngot ? baseAmount * 6 : baseAmount * 3, rate, tempFunction, this.getMeltTimeFunction(4.5f), extraMoltenLocation, isByIngot ? baseByAmount * 6 : baseByAmount * 3);
            } else {
                helper.registerOreMeltingRecipe(new ResourceLocation("jaopca", "tconstruct.ore_to_molten_singular." + material.getName()), CompoundIngredientObject.difference(oreLocation, sparseOreLocation, denseOreLocation), (Object)moltenLocation, isIngot ? baseAmount * 2 : baseAmount, rate, tempFunction, this.getMeltTimeFunction(isIngot ? 2.5f : 1.5f), new Object[0]);
                helper.registerOreMeltingRecipe(new ResourceLocation("jaopca", "tconstruct.ore_to_molten_sparse." + material.getName()), CompoundIngredientObject.intersection(oreLocation, sparseOreLocation), (Object)moltenLocation, isIngot ? baseAmount : baseAmount / 2, rate, tempFunction, this.getMeltTimeFunction(isIngot ? 1.5f : 1.0f), new Object[0]);
                helper.registerOreMeltingRecipe(new ResourceLocation("jaopca", "tconstruct.ore_to_molten_dense." + material.getName()), CompoundIngredientObject.intersection(oreLocation, denseOreLocation), (Object)moltenLocation, isIngot ? baseAmount * 6 : baseAmount * 3, rate, tempFunction, this.getMeltTimeFunction(4.5f), new Object[0]);
            }
            if (material.getType() != MaterialType.INGOT) continue;
            ResourceLocation rawMaterialLocation = miscHelper.getTagLocation("raw_materials", material.getName());
            ResourceLocation rawStorageBlockLocation = miscHelper.getTagLocation("storage_blocks/raw", material.getName(), "_");
            if (material.hasExtra(1)) {
                helper.registerOreMeltingRecipe(new ResourceLocation("jaopca", "tconstruct.raw_material_to_molten." + material.getName()), rawMaterialLocation, (Object)moltenLocation, baseAmount, 0, tempFunction, this.getMeltTimeFunction(1.5f), extraMoltenLocation, isByIngot ? baseByAmount : baseByAmount / 2);
            } else {
                helper.registerOreMeltingRecipe(new ResourceLocation("jaopca", "tconstruct.raw_material_to_molten." + material.getName()), rawMaterialLocation, (Object)moltenLocation, baseAmount, 0, tempFunction, this.getMeltTimeFunction(1.5f), new Object[0]);
            }
            if (!((JAOPCAApi)api).getItemTags().contains(rawStorageBlockLocation)) continue;
            if (material.hasExtra(1)) {
                helper.registerOreMeltingRecipe(new ResourceLocation("jaopca", "tconstruct.raw_storage_block_to_molten." + material.getName()), rawStorageBlockLocation, (Object)moltenLocation, baseAmount * 9, 0, tempFunction, this.getMeltTimeFunction(6.0f), extraMoltenLocation, isByIngot ? baseAmount * 9 : baseAmount * 9 / 2);
                continue;
            }
            helper.registerOreMeltingRecipe(new ResourceLocation("jaopca", "tconstruct.raw_storage_block_to_molten." + material.getName()), rawStorageBlockLocation, (Object)moltenLocation, baseAmount * 9, 0, tempFunction, this.getMeltTimeFunction(6.0f), new Object[0]);
        }
    }

    public ToIntFunction<FluidStack> getMeltTimeFunction(float timeFactor) {
        return stack -> IMeltingRecipe.calcTime((int)(stack.getFluid().getAttributes().getTemperature(stack) - 300), (float)timeFactor);
    }

    static {
        if (ModList.get().isLoaded("allthemodium")) {
            Collections.addAll(BLACKLIST, "allthemodium", "unobtainium", "vibranium");
        }
        if (ModList.get().isLoaded("materialis")) {
            Collections.addAll(BLACKLIST, "cloggrum", "froststeel", "iesnium", "quicksilver", "regalium", "starmetal", "utherium");
        }
        if (ModList.get().isLoaded("bettercompat")) {
            Collections.addAll(BLACKLIST, "black_opal", "certus_quartz", "moonstone", "thallasium");
        }
        if (ModList.get().isLoaded("natureminerals")) {
            Collections.addAll(BLACKLIST, "astrite", "kunzite", "stibnite", "uvarovite");
        }
        if (ModList.get().isLoaded("taiga")) {
            Collections.addAll(BLACKLIST, "abyssum", "aurorium", "dilithium", "duranite", "eezo", "jauxum", "karmesine", "osram", "ovium", "palladium", "prometheum", "tiberium", "uru", "valyrium", "vibranium");
        }
    }
}

