/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.thermalexpansion.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.IntersectionIngredient;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeSerializer;
import thelm.jaopca.ingredients.EmptyIngredient;
import thelm.jaopca.utils.MiscHelper;

public class SmelterRecycleRecipeSerializer
implements IRecipeSerializer {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object[] input;
    public final Object[] output;
    public final int energy;
    public final float experience;

    public SmelterRecycleRecipeSerializer(ResourceLocation key, Object[] input, Object[] output, int energy, float experience) {
        this.key = Objects.requireNonNull(key);
        this.input = input;
        this.output = output;
        this.energy = energy;
        this.experience = experience;
    }

    @Override
    public JsonElement get() {
        ArrayList<Pair> inputs = new ArrayList<Pair>();
        int i = 0;
        while (i < this.input.length) {
            Ingredient ing;
            Object in = this.input[i];
            Integer count = 1;
            if (++i < this.output.length && this.output[i] instanceof Integer) {
                count = (Integer)this.output[i];
                ++i;
            }
            if ((ing = MiscHelper.INSTANCE.getIngredient(in)) == EmptyIngredient.INSTANCE) {
                throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + in);
            }
            inputs.add(Pair.of((Object)ing, (Object)count));
        }
        if (inputs.isEmpty()) {
            throw new IllegalArgumentException("Empty ingredients in recipe " + this.key + ": " + Arrays.toString(this.input));
        }
        ArrayList<Pair> outputs = new ArrayList<Pair>();
        i = 0;
        while (i < this.output.length) {
            ItemStack stack;
            Object out = this.output[i];
            Integer count = 1;
            if (++i < this.output.length && this.output[i] instanceof Integer) {
                count = (Integer)this.output[i];
                ++i;
            }
            Object chance = Float.valueOf(-1.0f);
            if (i < this.output.length && this.output[i] instanceof Float) {
                chance = (Float)this.output[i];
                ++i;
            }
            if ((stack = MiscHelper.INSTANCE.getItemStack(out, count)).m_41619_()) {
                LOGGER.warn("Empty output in recipe {}: {}", (Object)this.key, out);
                continue;
            }
            outputs.add(Pair.of((Object)stack, (Object)chance));
        }
        if (outputs.isEmpty()) {
            throw new IllegalArgumentException("Empty outputs in recipe " + this.key + ": " + Arrays.toString(this.output));
        }
        JsonObject json = new JsonObject();
        json.addProperty("type", "thermal:smelter_recycle");
        JsonArray ingsJson = new JsonArray();
        for (Pair in : inputs) {
            JsonObject ingJson = IntersectionIngredient.of((Ingredient[])new Ingredient[]{(Ingredient)in.getLeft()}).m_43942_().getAsJsonObject();
            ingJson.addProperty("count", (Number)in.getRight());
            ingsJson.add((JsonElement)ingJson);
        }
        json.add("ingredients", (JsonElement)ingsJson);
        JsonArray resultJson = new JsonArray();
        for (Pair out : outputs) {
            JsonObject itemResultJson = MiscHelper.INSTANCE.serializeItemStack((ItemStack)out.getLeft());
            itemResultJson.addProperty("chance", (Number)out.getRight());
            resultJson.add((JsonElement)itemResultJson);
        }
        json.add("result", (JsonElement)resultJson);
        json.addProperty("energy", (Number)this.energy);
        json.addProperty("experience", (Number)Float.valueOf(this.experience));
        return json;
    }
}

