/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.fluids;

import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;
import thelm.jaopca.api.fluids.IFluidFormSettings;
import thelm.jaopca.api.fluids.IMaterialFormFluid;
import thelm.jaopca.utils.ApiImpl;

public class JAOPCAFluidAttributes
extends FluidAttributes {
    private final IMaterialFormFluid fluid;
    private final IFluidFormSettings settings;

    public JAOPCAFluidAttributes(IMaterialFormFluid fluid, IFluidFormSettings settings) {
        super(FluidAttributes.builder((ResourceLocation)new ResourceLocation(fluid.asFluid().getRegistryName().m_135827_(), "fluid/" + fluid.getMaterial().getModelType() + "/" + fluid.getForm().getName() + "_still"), (ResourceLocation)new ResourceLocation(fluid.asFluid().getRegistryName().m_135827_(), "fluid/" + fluid.getMaterial().getModelType() + "/" + fluid.getForm().getName() + "_flow")).sound(settings.getFillSoundSupplier().get(), settings.getEmptySoundSupplier().get()).luminosity(settings.getLightValueFunction().applyAsInt(fluid.getMaterial())).density(settings.getDensityFunction().applyAsInt(fluid.getMaterial())).viscosity(settings.getViscosityFunction().applyAsInt(fluid.getMaterial())).temperature(settings.getTemperatureFunction().applyAsInt(fluid.getMaterial())).rarity(settings.getDisplayRarityFunction().apply(fluid.getMaterial())), fluid.asFluid());
        this.fluid = fluid;
        this.settings = settings;
    }

    public int getColor() {
        return this.fluid.getMaterial().getColor();
    }

    public FluidState getStateForPlacement(BlockAndTintGetter world, BlockPos pos, FluidStack stack) {
        return this.fluid.getSourceState();
    }

    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation getStillTexture() {
        if (Minecraft.m_91087_().m_91098_().m_7165_(new ResourceLocation(this.fluid.asFluid().getRegistryName().m_135827_(), "textures/fluid/" + this.fluid.asFluid().getRegistryName().m_135815_() + "_still.png"))) {
            return new ResourceLocation(this.fluid.asFluid().getRegistryName().m_135827_(), "fluid/" + this.fluid.asFluid().getRegistryName().m_135815_() + "_still");
        }
        return super.getStillTexture();
    }

    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation getFlowingTexture() {
        if (Minecraft.m_91087_().m_91098_().m_7165_(new ResourceLocation(this.fluid.asFluid().getRegistryName().m_135827_(), "textures/fluid/" + this.fluid.asFluid().getRegistryName().m_135815_() + "_flow.png"))) {
            return new ResourceLocation(this.fluid.asFluid().getRegistryName().m_135827_(), "fluid/" + this.fluid.asFluid().getRegistryName().m_135815_() + "_flow");
        }
        return super.getFlowingTexture();
    }

    public Component getDisplayName(FluidStack stack) {
        return ApiImpl.INSTANCE.currentLocalizer().localizeMaterialForm("fluid.jaopca." + this.fluid.getForm().getName(), this.fluid.getMaterial(), this.getTranslationKey());
    }
}

