/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.localization;

import java.util.Objects;
import java.util.TreeMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.LanguageInfo;
import net.minecraftforge.fml.DistExecutor;
import thelm.jaopca.api.localization.ILocalizer;
import thelm.jaopca.localization.LocalizerDefault;

public class LocalizationHandler {
    private static final TreeMap<String, ILocalizer> LOCALIZERS = new TreeMap();

    public static void registerLocalizer(ILocalizer localizer, String ... languages) {
        Objects.requireNonNull(localizer);
        for (String language : Objects.requireNonNull(languages)) {
            LOCALIZERS.put(language, localizer);
        }
    }

    public static ILocalizer getCurrentLocalizer() {
        return LOCALIZERS.computeIfAbsent(LocalizationHandler.getLanguage(), key -> LocalizerDefault.INSTANCE);
    }

    public static String getLanguage() {
        return (String)DistExecutor.runForDist(() -> () -> {
            Minecraft mc = Minecraft.m_91087_();
            if (mc != null) {
                LanguageInfo lang = mc.m_91102_().m_118983_();
                if (lang != null) {
                    return lang.getCode();
                }
                return mc.f_91066_.f_92075_;
            }
            return "en_us";
        }, () -> () -> "en_us");
    }
}

