/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import javax.annotation.Nonnull;
import mekanism.client.gui.GuiConfigurableTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.custom.GuiFrequencySelector;
import mekanism.client.gui.element.tab.GuiEnergyTab;
import mekanism.client.gui.element.tab.GuiHeatTab;
import mekanism.common.MekanismLang;
import mekanism.common.content.entangloporter.InventoryFrequency;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.tile.TileEntityQuantumEntangloporter;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UnitDisplayUtils;
import mekanism.common.util.text.EnergyDisplay;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;

public class GuiQuantumEntangloporter
extends GuiConfigurableTile<TileEntityQuantumEntangloporter, MekanismTileContainer<TileEntityQuantumEntangloporter>>
implements GuiFrequencySelector.IGuiFrequencySelector<InventoryFrequency>,
GuiFrequencySelector.ITileGuiFrequencySelector<InventoryFrequency, TileEntityQuantumEntangloporter> {
    public GuiQuantumEntangloporter(MekanismTileContainer<TileEntityQuantumEntangloporter> container, Inventory inv, Component title) {
        super(container, inv, title);
        this.f_97727_ += 74;
        this.f_97729_ = 4;
        this.f_97731_ = this.f_97727_ - 93;
        this.dynamicSlots = true;
    }

    @Override
    protected void addGuiElements() {
        super.addGuiElements();
        this.addRenderableWidget(new GuiFrequencySelector(this, 14));
        this.addRenderableWidget(new GuiEnergyTab((IGuiWrapper)this, () -> {
            InventoryFrequency frequency = (InventoryFrequency)this.getFrequency();
            EnergyDisplay storing = frequency == null ? EnergyDisplay.ZERO : EnergyDisplay.of(frequency.storedEnergy);
            EnergyDisplay rate = EnergyDisplay.of(((TileEntityQuantumEntangloporter)this.tile).getInputRate());
            return List.of(MekanismLang.STORING.translate(storing), MekanismLang.MATRIX_INPUT_RATE.translate(rate));
        }));
        this.addRenderableWidget(new GuiHeatTab(this, () -> {
            Component transfer = MekanismUtils.getTemperatureDisplay(((TileEntityQuantumEntangloporter)this.tile).getLastTransferLoss(), UnitDisplayUtils.TemperatureUnit.KELVIN, false);
            Component environment = MekanismUtils.getTemperatureDisplay(((TileEntityQuantumEntangloporter)this.tile).getLastEnvironmentLoss(), UnitDisplayUtils.TemperatureUnit.KELVIN, false);
            return List.of(MekanismLang.TRANSFERRED_RATE.translate(transfer), MekanismLang.DISSIPATED_RATE.translate(environment));
        }));
    }

    @Override
    protected void drawForegroundText(@Nonnull PoseStack matrix, int mouseX, int mouseY) {
        this.renderTitleText(matrix);
        this.drawString(matrix, this.f_169604_, this.f_97730_, this.f_97731_, this.titleTextColor());
        super.drawForegroundText(matrix, mouseX, mouseY);
    }

    @Override
    public FrequencyType<InventoryFrequency> getFrequencyType() {
        return FrequencyType.INVENTORY;
    }
}

