/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.bar;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.merged.MergedChemicalTank;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.bar.GuiBar;
import mekanism.client.gui.element.bar.GuiChemicalBar;
import mekanism.client.jei.interfaces.IJEIIngredientHelper;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.chemical.dynamic.IGasTracker;
import mekanism.common.capabilities.chemical.dynamic.IInfusionTracker;
import mekanism.common.capabilities.chemical.dynamic.IPigmentTracker;
import mekanism.common.capabilities.chemical.dynamic.ISlurryTracker;
import mekanism.common.util.text.TextUtils;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.network.chat.Component;

public class GuiMergedChemicalBar<HANDLER extends IGasTracker & IInfusionTracker & ISlurryTracker>
extends GuiBar<GuiBar.IBarInfoHandler>
implements IJEIIngredientHelper {
    private final MergedChemicalTank chemicalTank;
    private final GuiChemicalBar<Gas, GasStack> gasBar;
    private final GuiChemicalBar<InfuseType, InfusionStack> infusionBar;
    private final GuiChemicalBar<Pigment, PigmentStack> pigmentBar;
    private final GuiChemicalBar<Slurry, SlurryStack> slurryBar;

    public GuiMergedChemicalBar(IGuiWrapper gui, HANDLER handler, final MergedChemicalTank chemicalTank, int x, int y, int width, int height, boolean horizontal) {
        super(TextureAtlas.f_118259_, gui, new GuiBar.IBarInfoHandler(){

            @Nullable
            private IChemicalTank<?, ?> getCurrentTank() {
                MergedChemicalTank.Current current = chemicalTank.getCurrent();
                if (current == MergedChemicalTank.Current.EMPTY) {
                    return null;
                }
                if (current == MergedChemicalTank.Current.GAS) {
                    return chemicalTank.getGasTank();
                }
                if (current == MergedChemicalTank.Current.INFUSION) {
                    return chemicalTank.getInfusionTank();
                }
                if (current == MergedChemicalTank.Current.PIGMENT) {
                    return chemicalTank.getPigmentTank();
                }
                if (current == MergedChemicalTank.Current.SLURRY) {
                    return chemicalTank.getSlurryTank();
                }
                throw new IllegalStateException("Unknown current type");
            }

            @Override
            public Component getTooltip() {
                IChemicalTank<?, ?> currentTank = this.getCurrentTank();
                if (currentTank == null) {
                    return MekanismLang.EMPTY.translate(new Object[0]);
                }
                if (currentTank.getStored() == Long.MAX_VALUE) {
                    return MekanismLang.GENERIC_STORED.translate(currentTank.getType(), MekanismLang.INFINITE);
                }
                return MekanismLang.GENERIC_STORED_MB.translate(currentTank.getType(), TextUtils.format(currentTank.getStored()));
            }

            @Override
            public double getLevel() {
                IChemicalTank<?, ?> currentTank = this.getCurrentTank();
                return currentTank == null ? 0.0 : (double)currentTank.getStored() / (double)currentTank.getCapacity();
            }
        }, x, y, width, height, horizontal);
        this.chemicalTank = chemicalTank;
        this.gasBar = this.addPositionOnlyChild(new GuiChemicalBar(gui, GuiChemicalBar.getProvider(this.chemicalTank.getGasTank(), handler.getGasTanks(null)), x, y, width, height, horizontal));
        this.infusionBar = this.addPositionOnlyChild(new GuiChemicalBar(gui, GuiChemicalBar.getProvider(this.chemicalTank.getInfusionTank(), ((IInfusionTracker)handler).getInfusionTanks(null)), x, y, width, height, horizontal));
        this.pigmentBar = this.addPositionOnlyChild(new GuiChemicalBar(gui, GuiChemicalBar.getProvider(this.chemicalTank.getPigmentTank(), ((IPigmentTracker)handler).getPigmentTanks(null)), x, y, width, height, horizontal));
        this.slurryBar = this.addPositionOnlyChild(new GuiChemicalBar(gui, GuiChemicalBar.getProvider(this.chemicalTank.getSlurryTank(), ((ISlurryTracker)handler).getSlurryTanks(null)), x, y, width, height, horizontal));
    }

    @Override
    public void m_7428_(@Nonnull PoseStack matrix, int mouseX, int mouseY) {
        GuiChemicalBar<?, ?> currentBar = this.getCurrentBarNoFallback();
        if (currentBar == null) {
            super.m_7428_(matrix, mouseX, mouseY);
        } else {
            currentBar.m_7428_(matrix, mouseX, mouseY);
        }
    }

    @Override
    void drawContentsChecked(@Nonnull PoseStack matrix, int mouseX, int mouseY, float partialTicks, double handlerLevel, boolean warning) {
        GuiChemicalBar<?, ?> currentBar = this.getCurrentBarNoFallback();
        if (currentBar != null) {
            currentBar.drawContentsChecked(matrix, mouseX, mouseY, partialTicks, handlerLevel, warning);
        }
    }

    @Override
    protected void renderBarOverlay(PoseStack matrix, int mouseX, int mouseY, float partialTicks, double handlerLevel) {
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        GuiChemicalBar<?, ?> currentBar = this.getCurrentBarNoFallback();
        if (currentBar == null) {
            return this.gasBar.m_6375_(mouseX, mouseY, button) | this.infusionBar.m_6375_(mouseX, mouseY, button) | this.pigmentBar.m_6375_(mouseX, mouseY, button) | this.slurryBar.m_6375_(mouseX, mouseY, button);
        }
        return currentBar.m_6375_(mouseX, mouseY, button);
    }

    @Override
    @Nullable
    public Object getIngredient(double mouseX, double mouseY) {
        GuiChemicalBar<?, ?> currentBar = this.getCurrentBarNoFallback();
        return currentBar == null ? null : currentBar.getIngredient(mouseX, mouseY);
    }

    @Nullable
    private GuiChemicalBar<?, ?> getCurrentBarNoFallback() {
        return switch (this.chemicalTank.getCurrent()) {
            case MergedChemicalTank.Current.GAS -> this.gasBar;
            case MergedChemicalTank.Current.INFUSION -> this.infusionBar;
            case MergedChemicalTank.Current.PIGMENT -> this.pigmentBar;
            case MergedChemicalTank.Current.SLURRY -> this.slurryBar;
            default -> null;
        };
    }
}

