/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.window;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.GuiUtils;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiElementHolder;
import mekanism.client.gui.element.button.TranslationButton;
import mekanism.client.gui.element.text.BackgroundType;
import mekanism.client.gui.element.text.GuiTextField;
import mekanism.client.gui.element.window.GuiWindow;
import mekanism.common.MekanismLang;
import mekanism.common.inventory.container.SelectedWindowData;
import mekanism.common.lib.Color;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.text.InputValidator;
import mekanism.common.util.text.TextUtils;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class GuiColorWindow
extends GuiWindow {
    private static final ResourceLocation HUE_PICKER = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "color_picker.png");
    private final GuiTextField textField;
    private final GuiShadePicker shadePicker;
    private final GuiHuePicker huePicker;
    private float hue;
    private float saturation = 0.5f;
    private float value = 0.5f;
    private static final int S_TILES = 10;
    private static final int V_TILES = 10;

    public GuiColorWindow(IGuiWrapper gui, int x, int y, Consumer<Color> callback) {
        super(gui, x, y, 160, 140, SelectedWindowData.WindowType.COLOR);
        this.interactionStrategy = GuiWindow.InteractionStrategy.NONE;
        this.addChild(new GuiElementHolder(gui, this.relativeX + 6, this.relativeY + 17, 43, 82));
        this.addChild(new GuiColorView(gui, this.relativeX + 7, this.relativeY + 18, 41, 80));
        this.addChild(new GuiElementHolder(gui, this.relativeX + 52, this.relativeY + 17, 102, 82));
        this.shadePicker = this.addChild(new GuiShadePicker(gui, this.relativeX + 53, this.relativeY + 18, 100, 80));
        this.addChild(new GuiElementHolder(gui, this.relativeX + 6, this.relativeY + 103, 148, 10));
        this.huePicker = this.addChild(new GuiHuePicker(gui, this.relativeX + 7, this.relativeY + 104, 146, 8));
        this.textField = this.addChild(new GuiTextField(gui, this.relativeX + 30, this.relativeY + this.getButtonHeight() - 20, 67, 12));
        this.textField.setMaxLength(11);
        this.textField.setInputValidator(InputValidator.DIGIT.or(c -> c == ','));
        this.textField.setBackground(BackgroundType.ELEMENT_HOLDER);
        this.addChild(new TranslationButton(gui, this.relativeX + 100, this.relativeY + this.getButtonHeight() - 21, 54, 14, MekanismLang.BUTTON_CONFIRM, () -> {
            callback.accept(this.getColor());
            this.close();
        }));
        this.setColor(Color.rgbi(128, 70, 70));
    }

    public Color getColor() {
        return Color.hsv(this.hue, this.saturation, this.value);
    }

    public void setColor(Color color) {
        this.setFromColor(color);
        this.updateTextFromColor();
    }

    @Override
    public void renderForeground(PoseStack matrix, int mouseX, int mouseY) {
        super.renderForeground(matrix, mouseX, mouseY);
        this.drawTitleText(matrix, (Component)MekanismLang.COLOR_PICKER.translate(new Object[0]), 6.0f);
        this.drawTextScaledBound(matrix, (Component)MekanismLang.RGB.translate(new Object[0]), this.relativeX + 7, (float)(this.relativeY + this.getButtonHeight()) - 17.5f, this.titleTextColor(), 20.0f);
    }

    private void drawTiledGradient(PoseStack matrix, int x, int y, int width, int height) {
        int tileWidth = Math.round((float)width / 10.0f);
        int tileHeight = Math.round((float)height / 10.0f);
        for (int i = 0; i < 10; ++i) {
            float minV = (float)i / 10.0f;
            float maxV = (float)(i + 1) / 10.0f;
            for (int j = 0; j < 10; ++j) {
                float minS = (float)j / 10.0f;
                float maxS = (float)(j + 1) / 10.0f;
                Color tl = Color.hsv(this.hue, minS, maxV);
                Color tr = Color.hsv(this.hue, maxS, maxV);
                Color bl = Color.hsv(this.hue, minS, minV);
                Color br = Color.hsv(this.hue, maxS, minV);
                this.drawGradient(matrix, x + j * tileWidth, y + (10 - i - 1) * tileHeight, tileWidth, tileHeight, tl, tr, bl, br);
            }
        }
    }

    private void drawGradient(PoseStack matrix, int x, int y, int width, int height, Color tl, Color tr, Color bl, Color br) {
        RenderSystem.m_69472_();
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
        Matrix4f matrix4f = matrix.m_85850_().m_85861_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        buffer.m_85982_(matrix4f, (float)x, (float)(y + height), 0.0f).m_85950_(bl.rf(), bl.gf(), bl.bf(), bl.af()).m_5752_();
        buffer.m_85982_(matrix4f, (float)(x + width), (float)(y + height), 0.0f).m_85950_(br.rf(), br.gf(), br.bf(), br.af()).m_5752_();
        buffer.m_85982_(matrix4f, (float)(x + width), (float)y, 0.0f).m_85950_(tr.rf(), tr.gf(), tr.bf(), tr.af()).m_5752_();
        buffer.m_85982_(matrix4f, (float)x, (float)y, 0.0f).m_85950_(tl.rf(), tl.gf(), tl.bf(), tl.af()).m_5752_();
        buffer.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)buffer);
        RenderSystem.m_69461_();
        RenderSystem.m_69493_();
    }

    private void updateTextFromColor() {
        int[] rgb = this.getColor().rgbArray();
        this.textField.setText(rgb[0] + "," + rgb[1] + "," + rgb[2]);
    }

    private void setFromColor(Color c) {
        double[] hsv = c.hsvArray();
        this.hue = (float)hsv[0];
        this.saturation = (float)hsv[1];
        this.value = (float)hsv[2];
    }

    private void updateColorFromText() {
        String[] split = this.textField.getText().split(",");
        if (split.length == 3) {
            try {
                int r = Integer.parseInt(split[0]);
                int g = Integer.parseInt(split[1]);
                int b = Integer.parseInt(split[2]);
                if (!(this.byteCheck(r) && this.byteCheck(g) && this.byteCheck(b))) {
                    return;
                }
                this.setFromColor(Color.rgbi(r, g, b));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private boolean byteCheck(int val) {
        return val >= 0 && val <= 255;
    }

    private void drawColorBar(PoseStack matrix, int x, int y, int width, int height) {
        for (int i = 0; i < width; ++i) {
            GuiUtils.fill(matrix, x + i, y, 1, height, Color.hsv((float)i / (float)width * 360.0f, 1.0, 1.0).argb());
        }
    }

    @Override
    public boolean m_5534_(char c, int keyCode) {
        boolean ret = super.m_5534_(c, keyCode);
        this.updateColorFromText();
        return ret;
    }

    @Override
    public void m_7691_(double mouseX, double mouseY) {
        super.m_7691_(mouseX, mouseY);
        this.huePicker.isDragging = false;
        this.shadePicker.isDragging = false;
    }

    public class GuiColorView
    extends GuiElement {
        public GuiColorView(IGuiWrapper gui, int x, int y, int width, int height) {
            super(gui, x, y, width, height);
        }

        @Override
        public void m_7428_(@Nonnull PoseStack matrix, int mouseX, int mouseY) {
            super.m_7428_(matrix, mouseX, mouseY);
            MutableComponent hex = MekanismLang.GENERIC_HEX.translateColored(EnumColor.GRAY, TextUtils.hex(false, 3, GuiColorWindow.this.getColor().rgb()));
            this.displayTooltips(matrix, mouseX, mouseY, new Component[]{hex});
        }

        @Override
        public void drawBackground(@Nonnull PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
            super.drawBackground(matrix, mouseX, mouseY, partialTicks);
            Color c = Color.hsv(GuiColorWindow.this.hue, GuiColorWindow.this.saturation, GuiColorWindow.this.value);
            GuiUtils.fill(matrix, this.getButtonX(), this.getButtonY(), this.getButtonWidth(), this.getButtonHeight(), c.argb());
        }
    }

    public class GuiShadePicker
    extends GuiElement {
        private boolean isDragging;

        public GuiShadePicker(IGuiWrapper gui, int x, int y, int width, int height) {
            super(gui, x, y, width, height);
        }

        @Override
        public void renderBackgroundOverlay(PoseStack matrix, int mouseX, int mouseY) {
            super.renderBackgroundOverlay(matrix, mouseX, mouseY);
            GuiColorWindow.this.drawTiledGradient(matrix, this.getButtonX(), this.getButtonY(), this.getButtonWidth(), this.getButtonHeight());
            int posX = this.getButtonX() + Math.round(GuiColorWindow.this.saturation * (float)this.getButtonWidth()) - 2;
            int posY = this.getButtonY() + Math.round((1.0f - GuiColorWindow.this.value) * (float)this.getButtonHeight()) - 2;
            GuiUtils.drawOutline(matrix, posX, posY, 5, 5, -1);
            GuiUtils.fill(matrix, posX + 1, posY + 1, 3, 3, GuiColorWindow.this.getColor().argb());
        }

        public void m_5716_(double mouseX, double mouseY) {
            if (this.m_93680_(mouseX, mouseY)) {
                this.set(mouseX, mouseY);
                this.isDragging = true;
            }
        }

        @Override
        public void m_7212_(double mouseX, double mouseY, double mouseXOld, double mouseYOld) {
            super.m_7212_(mouseX, mouseY, mouseXOld, mouseYOld);
            if (this.isDragging) {
                this.set(mouseX, mouseY);
            }
        }

        private void set(double mouseX, double mouseY) {
            float newS = (float)(mouseX - (double)this.getButtonX()) / (float)this.getButtonWidth();
            GuiColorWindow.this.saturation = Math.min(1.0f, Math.max(newS, 0.0f));
            float newV = (float)(mouseY - (double)this.getButtonY()) / (float)this.getButtonHeight();
            GuiColorWindow.this.value = 1.0f - Math.min(1.0f, Math.max(newV, 0.0f));
            GuiColorWindow.this.updateTextFromColor();
        }
    }

    public class GuiHuePicker
    extends GuiElement {
        private boolean isDragging;

        public GuiHuePicker(IGuiWrapper gui, int x, int y, int width, int height) {
            super(gui, x, y, width, height);
        }

        @Override
        public void renderBackgroundOverlay(PoseStack matrix, int mouseX, int mouseY) {
            super.renderBackgroundOverlay(matrix, mouseX, mouseY);
            GuiColorWindow.this.drawColorBar(matrix, this.getButtonX(), this.getButtonY(), this.getButtonWidth(), this.getButtonHeight());
            RenderSystem.m_157456_((int)0, (ResourceLocation)HUE_PICKER);
            int posX = Math.round(GuiColorWindow.this.hue / 360.0f * (float)(this.getButtonWidth() - 3));
            GuiHuePicker.m_93133_((PoseStack)matrix, (int)(this.getButtonX() - 2 + posX), (int)(this.getButtonY() - 2), (float)0.0f, (float)0.0f, (int)7, (int)12, (int)12, (int)12);
            GuiUtils.fill(matrix, this.getButtonX() + posX, this.getButtonY(), 3, 8, Color.hsv(GuiColorWindow.this.hue, 1.0, 1.0).argb());
        }

        public void m_5716_(double mouseX, double mouseY) {
            if (this.m_93680_(mouseX, mouseY)) {
                this.set(mouseX, mouseY);
                this.isDragging = true;
            }
        }

        @Override
        public void m_7212_(double mouseX, double mouseY, double mouseXOld, double mouseYOld) {
            super.m_7212_(mouseX, mouseY, mouseXOld, mouseYOld);
            if (this.isDragging) {
                this.set(mouseX, mouseY);
            }
        }

        private void set(double mouseX, double mouseY) {
            float val = (float)(mouseX - (double)this.getButtonX()) / (float)this.getButtonWidth();
            GuiColorWindow.this.hue = Math.min(1.0f, Math.max(val, 0.0f)) * 360.0f;
            GuiColorWindow.this.updateTextFromColor();
        }
    }
}

