/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.window.filter.transporter;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.BiConsumer;
import java.util.function.BooleanSupplier;
import java.util.function.UnaryOperator;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.button.ColorButton;
import mekanism.client.gui.element.button.MekanismImageButton;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.gui.element.text.GuiTextField;
import mekanism.client.gui.element.window.filter.GuiFilterHelper;
import mekanism.client.gui.element.window.filter.transporter.GuiSorterFilerSelect;
import mekanism.client.render.IFancyFontRenderer;
import mekanism.common.MekanismLang;
import mekanism.common.content.transporter.SorterFilter;
import mekanism.common.tile.TileEntityLogisticalSorter;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.TransporterUtils;
import mekanism.common.util.text.BooleanStateDisplay;
import mekanism.common.util.text.InputValidator;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public interface GuiSorterFilterHelper
extends GuiFilterHelper<TileEntityLogisticalSorter>,
IFancyFontRenderer {
    default public void addSorterDefaults(IGuiWrapper gui, SorterFilter<?> filter, int slotOffset, UnaryOperator<GuiElement> childAdder, BooleanSupplier singleItem, BiConsumer<GuiTextField, GuiTextField> rangeSetter) {
        int relativeX = this.getRelativeX();
        int relativeY = this.getRelativeY();
        int slotX = relativeX + 7;
        int colorSlotY = relativeY + slotOffset + 25;
        childAdder.apply(new GuiSlot(SlotType.NORMAL, gui, slotX, colorSlotY));
        childAdder.apply(new ColorButton(gui, slotX + 1, colorSlotY + 1, 16, 16, () -> filter.color, () -> {
            filter.color = Screen.m_96638_() ? null : TransporterUtils.increment(filter.color);
        }, () -> {
            filter.color = TransporterUtils.decrement(filter.color);
        }));
        childAdder.apply(new MekanismImageButton(gui, relativeX + 148, relativeY + 18, 11, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_BUTTON, "default.png"), () -> {
            filter.allowDefault = !filter.allowDefault;
        }, (onHover, matrix, mouseX, mouseY) -> gui.displayTooltips(matrix, mouseX, mouseY, new Component[]{MekanismLang.FILTER_ALLOW_DEFAULT.translate(new Object[0])})));
        GuiTextField minField = new GuiTextField(gui, relativeX + 169, relativeY + 31, 20, 11);
        minField.setMaxLength(2);
        minField.setInputValidator(InputValidator.DIGIT);
        minField.setText("" + filter.min);
        childAdder.apply(minField);
        GuiTextField maxField = new GuiTextField(gui, relativeX + 169, relativeY + 43, 20, 11);
        maxField.setMaxLength(2);
        maxField.setInputValidator(InputValidator.DIGIT);
        maxField.setText("" + filter.max);
        childAdder.apply(maxField);
        rangeSetter.accept(minField, maxField);
        childAdder.apply(new MekanismImageButton(gui, relativeX + 148, relativeY + 56, 11, 14, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_BUTTON, "silk_touch.png"), () -> {
            filter.sizeMode = !filter.sizeMode;
        }, (onHover, matrix, mouseX, mouseY) -> {
            if (singleItem.getAsBoolean() && filter.sizeMode) {
                gui.displayTooltips(matrix, mouseX, mouseY, new Component[]{MekanismLang.SORTER_SIZE_MODE_CONFLICT.translate(new Object[0])});
            } else {
                gui.displayTooltips(matrix, mouseX, mouseY, new Component[]{MekanismLang.SORTER_SIZE_MODE.translate(new Object[0])});
            }
        }));
    }

    default public GuiSorterFilerSelect getFilterSelect(IGuiWrapper gui, TileEntityLogisticalSorter tile) {
        return new GuiSorterFilerSelect(gui, tile);
    }

    default public void renderSorterForeground(PoseStack matrix, SorterFilter<?> filter, boolean singleItem) {
        int relativeX = this.getRelativeX();
        int relativeY = this.getRelativeY();
        this.drawString(matrix, BooleanStateDisplay.OnOff.of(filter.allowDefault).getTextComponent(), relativeX + 161, relativeY + 20, this.titleTextColor());
        this.drawString(matrix, (Component)MekanismLang.MIN.translate(""), relativeX + 148, relativeY + 32, this.titleTextColor());
        this.drawString(matrix, (Component)MekanismLang.MAX.translate(""), relativeX + 148, relativeY + 44, this.titleTextColor());
        if (singleItem && filter.sizeMode) {
            this.drawString(matrix, (Component)MekanismLang.SORTER_FILTER_SIZE_MODE.translateColored(EnumColor.RED, BooleanStateDisplay.OnOff.of(true)), relativeX + 161, relativeY + 58, this.titleTextColor());
        } else {
            this.drawString(matrix, BooleanStateDisplay.OnOff.of(filter.sizeMode).getTextComponent(), relativeX + 161, relativeY + 58, this.titleTextColor());
        }
    }
}

