/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nonnull;
import mekanism.client.model.MekanismJavaModel;
import mekanism.client.model.ModelPartData;
import mekanism.client.render.MekanismRenderType;
import mekanism.common.Mekanism;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;

public class ModelIndustrialAlarm
extends MekanismJavaModel {
    public static final ModelLayerLocation ALARM_LAYER = new ModelLayerLocation(Mekanism.rl("industrial_alarm"), "main");
    private static final ResourceLocation TEXTURE = MekanismUtils.getResource(MekanismUtils.ResourceType.RENDER, "industrial_alarm.png");
    private static final ResourceLocation TEXTURE_ACTIVE = MekanismUtils.getResource(MekanismUtils.ResourceType.RENDER, "industrial_alarm_active.png");
    private static final ModelPartData BASE = new ModelPartData("base", CubeListBuilder.m_171558_().m_171514_(0, 9).m_171481_(-3.0f, 0.0f, -3.0f, 6.0f, 1.0f, 6.0f));
    private static final ModelPartData BULB = new ModelPartData("bulb", CubeListBuilder.m_171558_().m_171514_(16, 0).m_171481_(-1.0f, 1.0f, -1.0f, 2.0f, 3.0f, 2.0f));
    private static final ModelPartData LIGHT_BOX = new ModelPartData("light_box", CubeListBuilder.m_171558_().m_171481_(-2.0f, 1.0f, -2.0f, 4.0f, 4.0f, 4.0f));
    private static final ModelPartData AURA = new ModelPartData("aura", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171481_(-6.0f, 2.0f, -1.0f, 12.0f, 1.0f, 2.0f));
    private final RenderType RENDER_TYPE = MekanismRenderType.standard(TEXTURE);
    private final RenderType RENDER_TYPE_ACTIVE = MekanismRenderType.standard(TEXTURE_ACTIVE);
    private final ModelPart base;
    private final ModelPart bulb;
    private final ModelPart lightBox;
    private final ModelPart aura;

    public static LayerDefinition createLayerDefinition() {
        return ModelIndustrialAlarm.createLayerDefinition(64, 64, BASE, BULB, LIGHT_BOX, AURA);
    }

    public ModelIndustrialAlarm(EntityModelSet entityModelSet) {
        super(RenderType::m_110446_);
        ModelPart root = entityModelSet.m_171103_(ALARM_LAYER);
        this.base = BASE.getFromRoot(root);
        this.bulb = BULB.getFromRoot(root);
        this.lightBox = LIGHT_BOX.getFromRoot(root);
        this.aura = AURA.getFromRoot(root);
    }

    public void render(@Nonnull PoseStack matrix, @Nonnull MultiBufferSource renderer, int light, int overlayLight, boolean active, float rotation, boolean renderBase, boolean hasEffect) {
        this.render(matrix, ModelIndustrialAlarm.getVertexConsumer(renderer, active ? this.RENDER_TYPE_ACTIVE : this.RENDER_TYPE, hasEffect), light, overlayLight, 1.0f, 1.0f, 1.0f, 1.0f, active, rotation, renderBase);
    }

    public void m_7695_(@Nonnull PoseStack matrix, @Nonnull VertexConsumer vertexBuilder, int light, int overlayLight, float red, float green, float blue, float alpha) {
        this.render(matrix, vertexBuilder, light, overlayLight, red, green, blue, alpha, false, 0.0f, false);
    }

    private void render(@Nonnull PoseStack matrix, @Nonnull VertexConsumer vertexBuilder, int light, int overlayLight, float red, float green, float blue, float alpha, boolean active, float rotation, boolean renderBase) {
        if (renderBase) {
            this.base.m_104306_(matrix, vertexBuilder, light, overlayLight, red, green, blue, alpha);
        }
        if (active) {
            ModelIndustrialAlarm.setRotation(this.aura, 0.0f, (float)Math.toRadians(rotation), 0.0f);
            ModelIndustrialAlarm.setRotation(this.bulb, 0.0f, (float)Math.toRadians(rotation), 0.0f);
        } else {
            ModelIndustrialAlarm.setRotation(this.aura, 0.0f, 0.0f, 0.0f);
            ModelIndustrialAlarm.setRotation(this.bulb, 0.0f, 0.0f, 0.0f);
        }
        float bulbAlpha = 0.3f + Math.abs(rotation * 2.0f % 360.0f - 180.0f) / 180.0f * 0.7f;
        this.bulb.m_104306_(matrix, vertexBuilder, active ? 0xF000F0 : light, overlayLight, red, green, blue, bulbAlpha);
        this.lightBox.m_104306_(matrix, vertexBuilder, active ? 0xF000F0 : light, overlayLight, red, green, blue, alpha);
        if (!renderBase) {
            this.aura.m_104306_(matrix, vertexBuilder, 0xF000F0, overlayLight, red, green, blue, bulbAlpha);
        }
    }
}

