/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.transmitter;

import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.text.EnumColor;
import mekanism.client.model.ModelTransporterBox;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.RenderResizableCuboid;
import mekanism.client.render.transmitter.RenderTransmitterBase;
import mekanism.common.content.network.transmitter.DiversionTransporter;
import mekanism.common.content.network.transmitter.LogisticalTransporterBase;
import mekanism.common.content.transporter.TransporterStack;
import mekanism.common.item.ItemConfigurator;
import mekanism.common.lib.inventory.HashedItem;
import mekanism.common.tile.transmitter.TileEntityLogisticalTransporterBase;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.TransporterUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

@ParametersAreNonnullByDefault
public class RenderLogisticalTransporter
extends RenderTransmitterBase<TileEntityLogisticalTransporterBase> {
    private static final Map<Direction, MekanismRenderer.Model3D> cachedOverlays = new EnumMap<Direction, MekanismRenderer.Model3D>(Direction.class);
    private static MekanismRenderer.Model3D.SpriteInfo gunpowderIcon;
    private static MekanismRenderer.Model3D.SpriteInfo torchOffIcon;
    private static MekanismRenderer.Model3D.SpriteInfo torchOnIcon;
    private final ModelTransporterBox modelBox;
    private final LazyItemRenderer itemRenderer = new LazyItemRenderer();

    public RenderLogisticalTransporter(BlockEntityRendererProvider.Context context) {
        super(context);
        this.modelBox = new ModelTransporterBox(context.m_173585_());
    }

    public static void onStitch(TextureAtlas map) {
        cachedOverlays.clear();
        gunpowderIcon = new MekanismRenderer.Model3D.SpriteInfo(map.m_118316_(new ResourceLocation("minecraft", "item/gunpowder")), 16);
        torchOffIcon = new MekanismRenderer.Model3D.SpriteInfo(map.m_118316_(new ResourceLocation("minecraft", "block/redstone_torch_off")), 16);
        torchOnIcon = new MekanismRenderer.Model3D.SpriteInfo(map.m_118316_(new ResourceLocation("minecraft", "block/redstone_torch")), 16);
    }

    @Override
    protected void render(TileEntityLogisticalTransporterBase tile, float partialTick, PoseStack matrix, MultiBufferSource renderer, int light, int overlayLight, ProfilerFiller profiler) {
        LogisticalTransporterBase transporter = tile.getTransmitter();
        Collection<TransporterStack> inTransit = transporter.getTransit();
        BlockPos pos = tile.m_58899_();
        if (!inTransit.isEmpty()) {
            matrix.m_85836_();
            this.itemRenderer.init(tile.m_58904_(), pos);
            float partial = partialTick * (float)transporter.tier.getSpeed();
            Collection<TransporterStack> reducedTransit = this.getReducedTransit(inTransit);
            for (TransporterStack stack : reducedTransit) {
                float[] stackPos = TransporterUtils.getStackPosition(transporter, stack, partial);
                matrix.m_85836_();
                matrix.m_85837_((double)stackPos[0], (double)stackPos[1], (double)stackPos[2]);
                matrix.m_85841_(0.75f, 0.75f, 0.75f);
                this.itemRenderer.renderAsStack(matrix, renderer, stack.itemStack);
                matrix.m_85849_();
                if (stack.color == null) continue;
                this.modelBox.render(matrix, renderer, 0xF000F0, overlayLight, stackPos[0], stackPos[1], stackPos[2], stack.color);
            }
            matrix.m_85849_();
        }
        if (transporter instanceof DiversionTransporter) {
            BlockHitResult rayTraceResult;
            DiversionTransporter diversionTransporter = (DiversionTransporter)transporter;
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            ItemStack itemStack = player.m_150109_().m_36056_();
            if (!itemStack.m_41619_() && itemStack.m_41720_() instanceof ItemConfigurator && !(rayTraceResult = MekanismUtils.rayTrace((Player)player)).m_6662_().equals((Object)HitResult.Type.MISS) && rayTraceResult.m_82425_().equals((Object)pos)) {
                Direction side = tile.getSideLookingAt((Player)player, rayTraceResult.m_82434_());
                matrix.m_85836_();
                matrix.m_85841_(0.5f, 0.5f, 0.5f);
                matrix.m_85837_(0.5, 0.5, 0.5);
                MekanismRenderer.renderObject(this.getOverlayModel(diversionTransporter, side), matrix, renderer.m_6299_(Sheets.m_110792_()), MekanismRenderer.getColorARGB(255, 255, 255, 0.8f), 0xF000F0, overlayLight, RenderResizableCuboid.FaceDisplay.FRONT);
                matrix.m_85849_();
            }
        }
    }

    @Override
    protected String getProfilerSection() {
        return "logisticalTransporter";
    }

    private Collection<TransporterStack> getReducedTransit(Collection<TransporterStack> inTransit) {
        ArrayList<TransporterStack> reducedTransit = new ArrayList<TransporterStack>();
        ObjectOpenHashSet information = new ObjectOpenHashSet();
        for (TransporterStack stack : inTransit) {
            if (stack == null || stack.itemStack.m_41619_() || !information.add(new TransportInformation(stack))) continue;
            reducedTransit.add(stack);
        }
        return reducedTransit;
    }

    private MekanismRenderer.Model3D getOverlayModel(DiversionTransporter transporter, Direction side) {
        MekanismRenderer.Model3D model = cachedOverlays.computeIfAbsent(side, face -> {
            MekanismRenderer.Model3D m = new MekanismRenderer.Model3D();
            MekanismRenderer.prepSingleFaceModelSize(m, face);
            for (Direction direction : EnumUtils.DIRECTIONS) {
                m.setSideRender(direction, direction == face);
            }
            return m;
        });
        MekanismRenderer.Model3D.SpriteInfo icon = switch (transporter.modes[side.ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case DiversionTransporter.DiversionControl.DISABLED -> gunpowderIcon;
            case DiversionTransporter.DiversionControl.HIGH -> torchOnIcon;
            case DiversionTransporter.DiversionControl.LOW -> torchOffIcon;
        };
        model.setTexture(side, icon);
        return model;
    }

    private static class LazyItemRenderer {
        @Nullable
        private ItemEntity entityItem;
        @Nullable
        private EntityRenderer<? super ItemEntity> renderer;

        private LazyItemRenderer() {
        }

        public void init(Level world, BlockPos pos) {
            if (this.entityItem == null) {
                this.entityItem = new ItemEntity(EntityType.f_20461_, world);
            } else {
                this.entityItem.f_19853_ = world;
            }
            this.entityItem.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
            this.entityItem.f_31985_ = 0;
        }

        private void renderAsStack(PoseStack matrix, MultiBufferSource buffer, ItemStack stack) {
            if (this.entityItem != null) {
                if (this.renderer == null) {
                    this.renderer = Minecraft.m_91087_().m_91290_().m_114382_((Entity)this.entityItem);
                }
                this.entityItem.m_32045_(stack);
                this.renderer.m_7392_((Entity)this.entityItem, 0.0f, 0.0f, matrix, buffer, 0xF000F0);
            }
        }
    }

    private static class TransportInformation {
        @Nullable
        private final EnumColor color;
        private final HashedItem item;
        private final int progress;

        private TransportInformation(TransporterStack transporterStack) {
            this.progress = transporterStack.progress;
            this.color = transporterStack.color;
            this.item = HashedItem.create(transporterStack.itemStack);
        }

        public int hashCode() {
            int code = 1;
            code = 31 * code + this.progress;
            code = 31 * code + this.item.hashCode();
            if (this.color != null) {
                code = 31 * code + this.color.hashCode();
            }
            return code;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof TransportInformation)) return false;
            TransportInformation other = (TransportInformation)obj;
            if (this.progress != other.progress) return false;
            if (this.color != other.color) return false;
            if (!this.item.equals(other.item)) return false;
            return true;
        }
    }
}

