/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.gear;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import mekanism.api.MekanismAPI;
import mekanism.api.gear.EnchantmentBasedModule;
import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IHUDElement;
import mekanism.api.gear.IModule;
import mekanism.api.gear.ModuleData;
import mekanism.api.providers.IModuleDataProvider;
import mekanism.api.text.EnumColor;
import mekanism.api.text.TextComponentUtil;
import mekanism.common.MekanismLang;
import mekanism.common.content.gear.Module;
import mekanism.common.content.gear.ModuleHelper;
import mekanism.common.item.interfaces.IItemHUDProvider;
import mekanism.common.util.ItemDataUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public interface IModuleContainerItem
extends IItemHUDProvider {
    default public List<Module<?>> getModules(ItemStack stack) {
        return ModuleHelper.INSTANCE.loadAll(stack);
    }

    @Nullable
    default public <MODULE extends ICustomModule<MODULE>> IModule<MODULE> getModule(ItemStack stack, IModuleDataProvider<MODULE> typeProvider) {
        return MekanismAPI.getModuleHelper().load(stack, typeProvider);
    }

    default public void addModuleDetails(ItemStack stack, List<Component> tooltip) {
        for (Module<?> module : this.getModules(stack)) {
            ModuleData<?> data = module.getData();
            if (module.getInstalledCount() > 1) {
                TranslatableComponent amount = MekanismLang.GENERIC_FRACTION.translate(module.getInstalledCount(), data.getMaxStackSize());
                tooltip.add((Component)MekanismLang.GENERIC_WITH_PARENTHESIS.translateColored(EnumColor.GRAY, data, amount));
                continue;
            }
            tooltip.add((Component)TextComponentUtil.build(EnumColor.GRAY, data));
        }
    }

    default public boolean hasModule(ItemStack stack, IModuleDataProvider<?> type) {
        CompoundTag modules = ItemDataUtils.getCompound(stack, "modules");
        return modules.m_128425_(type.getRegistryName().toString(), 10);
    }

    default public boolean isModuleEnabled(ItemStack stack, IModuleDataProvider<?> type) {
        IModule<?> module = this.getModule(stack, type);
        return module != null && module.isEnabled();
    }

    default public void removeModule(ItemStack stack, ModuleData<?> type) {
        IModule module = ModuleHelper.INSTANCE.load(stack, (IModuleDataProvider)type);
        if (module != null) {
            if (((Module)module).getInstalledCount() > 1) {
                ((Module)module).setInstalledCount(((Module)module).getInstalledCount() - 1);
                ((Module)module).save(null);
                ((Module)module).onRemoved(false);
            } else {
                CompoundTag modules = ItemDataUtils.getCompound(stack, "modules");
                modules.m_128473_(type.getRegistryName().toString());
                ((Module)module).onRemoved(true);
            }
        }
    }

    default public void addModule(ItemStack stack, ModuleData<?> type) {
        IModule module = ModuleHelper.INSTANCE.load(stack, (IModuleDataProvider)type);
        if (module == null) {
            if (!ItemDataUtils.hasData(stack, "modules", 10)) {
                ItemDataUtils.setCompound(stack, "modules", new CompoundTag());
            }
            ItemDataUtils.getCompound(stack, "modules").m_128365_(type.getRegistryName().toString(), (Tag)new CompoundTag());
            ((Module)ModuleHelper.INSTANCE.load(stack, (IModuleDataProvider)type)).onAdded(true);
        } else {
            ((Module)module).setInstalledCount(((Module)module).getInstalledCount() + 1);
            ((Module)module).save(null);
            ((Module)module).onAdded(false);
        }
    }

    @Override
    default public void addHUDStrings(List<Component> list, Player player, ItemStack stack, EquipmentSlot slotType) {
        for (Module<?> module : this.getModules(stack)) {
            if (!module.renderHUD()) continue;
            module.addHUDStrings(player, list);
        }
    }

    default public List<IHUDElement> getHUDElements(Player player, ItemStack stack) {
        ArrayList<IHUDElement> ret = new ArrayList<IHUDElement>();
        for (Module<?> module : this.getModules(stack)) {
            if (!module.renderHUD()) continue;
            module.addHUDElements(player, ret);
        }
        return ret;
    }

    public static boolean hasOtherEnchants(ItemStack stack) {
        MatchedEnchants enchants = new MatchedEnchants(stack);
        IModuleContainerItem.forMatchingEnchants(stack, enchants, (e, module) -> ++e.matchedCount);
        return enchants.enchantments == null || enchants.matchedCount < enchants.enchantments.size();
    }

    default public void filterTooltips(ItemStack stack, List<Component> tooltips) {
        ArrayList enchantsToRemove = new ArrayList();
        IModuleContainerItem.forMatchingEnchants(stack, new MatchedEnchants(stack), (e, module) -> enchantsToRemove.add(((EnchantmentBasedModule)module.getCustomInstance()).getEnchantment().m_44700_(module.getInstalledCount())));
        tooltips.removeAll(enchantsToRemove);
    }

    public static void forMatchingEnchants(ItemStack stack, MatchedEnchants enchants, BiConsumer<MatchedEnchants, IModule<? extends EnchantmentBasedModule<?>>> consumer) {
        for (IModule<EnchantmentBasedModule> module : MekanismAPI.getModuleHelper().loadAll(stack, EnchantmentBasedModule.class)) {
            if (!module.isEnabled() || enchants.getEnchantments().getOrDefault(module.getCustomInstance().getEnchantment(), 0).intValue() != module.getInstalledCount()) continue;
            consumer.accept(enchants, module);
        }
    }

    public static class MatchedEnchants {
        private final ItemStack stack;
        private Map<Enchantment, Integer> enchantments;
        private int matchedCount;

        public MatchedEnchants(ItemStack stack) {
            this.stack = stack;
        }

        public Map<Enchantment, Integer> getEnchantments() {
            if (this.enchantments == null) {
                this.enchantments = EnchantmentHelper.m_44831_((ItemStack)this.stack);
            }
            return this.enchantments;
        }
    }
}

