/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.gear.mekasuit;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.IIncrementalEnum;
import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IModule;
import mekanism.api.gear.config.IModuleConfigItem;
import mekanism.api.gear.config.ModuleConfigItemCreator;
import mekanism.api.gear.config.ModuleEnumData;
import mekanism.api.math.FloatingLong;
import mekanism.api.math.MathUtils;
import mekanism.api.text.IHasTextComponent;
import mekanism.api.text.TextComponentUtil;
import mekanism.common.MekanismLang;
import mekanism.common.config.MekanismConfig;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

@ParametersAreNonnullByDefault
public class ModuleLocomotiveBoostingUnit
implements ICustomModule<ModuleLocomotiveBoostingUnit> {
    private IModuleConfigItem<SprintBoost> sprintBoost;

    @Override
    public void init(IModule<ModuleLocomotiveBoostingUnit> module, ModuleConfigItemCreator configItemCreator) {
        this.sprintBoost = configItemCreator.createConfigItem("sprint_boost", MekanismLang.MODULE_SPRINT_BOOST, new ModuleEnumData<SprintBoost>(SprintBoost.class, module.getInstalledCount() + 1, SprintBoost.LOW));
    }

    @Override
    public void changeMode(IModule<ModuleLocomotiveBoostingUnit> module, Player player, ItemStack stack, int shift, boolean displayChangeMessage) {
        if (module.isEnabled()) {
            SprintBoost newMode = this.sprintBoost.get().adjust(shift, v -> v.ordinal() < module.getInstalledCount() + 1);
            if (this.sprintBoost.get() != newMode) {
                this.sprintBoost.set(newMode);
                if (displayChangeMessage) {
                    module.displayModeChange(player, (Component)MekanismLang.MODULE_SPRINT_BOOST.translate(new Object[0]), newMode);
                }
            }
        }
    }

    @Override
    public void tickServer(IModule<ModuleLocomotiveBoostingUnit> module, Player player) {
        if (this.tick(module, player)) {
            module.useEnergy((LivingEntity)player, ((FloatingLong)MekanismConfig.gear.mekaSuitEnergyUsageSprintBoost.get()).multiply(this.getBoost() / 0.1f));
        }
    }

    @Override
    public void tickClient(IModule<ModuleLocomotiveBoostingUnit> module, Player player) {
        this.tick(module, player);
    }

    private boolean tick(IModule<ModuleLocomotiveBoostingUnit> module, Player player) {
        if (this.canFunction(module, player)) {
            float boost = this.getBoost();
            if (!player.m_20096_()) {
                boost /= 5.0f;
            }
            if (player.m_20069_()) {
                boost /= 5.0f;
            }
            player.m_19920_(boost, new Vec3(0.0, 0.0, 1.0));
            return true;
        }
        return false;
    }

    public boolean canFunction(IModule<ModuleLocomotiveBoostingUnit> module, Player player) {
        return !player.m_21255_() && player.m_20142_() && module.canUseEnergy((LivingEntity)player, ((FloatingLong)MekanismConfig.gear.mekaSuitEnergyUsageSprintBoost.get()).multiply(this.getBoost() / 0.1f));
    }

    public float getBoost() {
        return this.sprintBoost.get().getBoost();
    }

    public static enum SprintBoost implements IHasTextComponent,
    IIncrementalEnum<SprintBoost>
    {
        OFF(0.0f),
        LOW(0.05f),
        MED(0.1f),
        HIGH(0.25f),
        ULTRA(0.5f);

        private static final SprintBoost[] MODES;
        private final float boost;
        private final Component label;

        private SprintBoost(float boost) {
            this.boost = boost;
            this.label = TextComponentUtil.getString(Float.toString(boost));
        }

        @Override
        @Nonnull
        public SprintBoost byIndex(int index) {
            return MathUtils.getByIndexMod(MODES, index);
        }

        @Override
        public Component getTextComponent() {
            return this.label;
        }

        public float getBoost() {
            return this.boost;
        }

        static {
            MODES = SprintBoost.values();
        }
    }
}

