/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.oredictionificator;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.IntBinaryOperator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.common.config.value.CachedOredictionificatorConfigValue;
import mekanism.common.content.filter.BaseFilter;
import mekanism.common.util.NBTUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.tags.ITag;
import net.minecraftforge.registries.tags.ITagManager;

public abstract class OredictionificatorFilter<TYPE extends IForgeRegistryEntry<TYPE>, STACK, FILTER extends OredictionificatorFilter<TYPE, STACK, FILTER>>
extends BaseFilter<FILTER> {
    @Nullable
    private TagKey<TYPE> filterLocation;
    @Nullable
    private ITag<TYPE> filterTag;
    @Nonnull
    private TYPE selectedOutput = this.getFallbackElement();
    @Nullable
    private STACK cachedSelectedStack;
    private boolean isValid;

    protected OredictionificatorFilter() {
    }

    protected OredictionificatorFilter(OredictionificatorFilter<TYPE, STACK, FILTER> filter) {
        this.filterLocation = filter.filterLocation;
        this.filterTag = filter.filterTag;
        this.selectedOutput = filter.selectedOutput;
        this.cachedSelectedStack = filter.cachedSelectedStack;
        this.isValid = filter.isValid;
    }

    public void flushCachedTag() {
        ITag<TYPE> iTag = this.filterTag = this.filterLocation == null ? null : this.getTagManager().getTag(this.filterLocation);
        if (this.filterTag == null || !this.filterTag.isBound()) {
            this.setSelectedOutput(this.getFallbackElement());
        } else if (!this.filterTag.contains(this.selectedOutput)) {
            this.filterTag.stream().findFirst().ifPresentOrElse(this::setSelectedOutput, () -> this.setSelectedOutput(this.getFallbackElement()));
        }
    }

    @Override
    public boolean hasFilter() {
        return this.filterLocation != null && this.isValid;
    }

    public void checkValidity() {
        if (this.filterLocation != null && this.getTagManager().isKnownTagName(this.filterLocation)) {
            for (String filter : ((Map)this.getValidValuesConfig().get()).getOrDefault(this.filterLocation.f_203868_().m_135827_(), Collections.emptyList())) {
                if (!this.filterLocation.f_203868_().m_135815_().startsWith(filter)) continue;
                this.isValid = true;
                return;
            }
        }
        this.isValid = false;
    }

    public String getFilterText() {
        return this.filterLocation == null ? "" : this.filterLocation.f_203868_().toString();
    }

    public final void setFilter(@Nullable ResourceLocation location) {
        this.filterLocation = location == null ? null : this.getTagManager().createTagKey(location);
        this.flushCachedTag();
        this.isValid = true;
    }

    public final void setSelectedOutput(@Nonnull TYPE output) {
        this.selectedOutput = output;
        this.cachedSelectedStack = null;
    }

    public boolean filterMatches(ResourceLocation location) {
        return this.filterLocation != null && this.filterLocation.f_203868_().equals((Object)location);
    }

    @Override
    public CompoundTag write(CompoundTag nbtTags) {
        super.write(nbtTags);
        nbtTags.m_128359_("filter", this.getFilterText());
        if (this.selectedOutput != this.getFallbackElement()) {
            nbtTags.m_128359_("selected", this.selectedOutput.getRegistryName().toString());
        }
        return nbtTags;
    }

    @Override
    public void read(CompoundTag nbtTags) {
        NBTUtils.setResourceLocationIfPresentElse(nbtTags, "filter", this::setFilter, () -> this.setFilter(null));
        NBTUtils.setResourceLocationIfPresent(nbtTags, "selected", this::setSelectedOrFallback);
        this.checkValidity();
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        super.write(buffer);
        buffer.writeBoolean(this.filterLocation != null);
        if (this.filterLocation != null) {
            buffer.m_130085_(this.filterLocation.f_203868_());
        }
        buffer.m_130085_(this.selectedOutput.getRegistryName());
        buffer.writeBoolean(this.isValid);
    }

    @Override
    public void read(FriendlyByteBuf buffer) {
        this.setFilter(buffer.readBoolean() ? buffer.m_130281_() : null);
        this.setSelectedOrFallback(buffer.m_130281_());
        this.isValid = buffer.readBoolean();
    }

    private void setSelectedOrFallback(@Nonnull ResourceLocation resourceLocation) {
        IForgeRegistryEntry output = this.getRegistry().getValue(resourceLocation);
        this.setSelectedOutput(output == null ? this.getFallbackElement() : output);
    }

    public STACK getResult() {
        if (this.cachedSelectedStack == null) {
            List<TYPE> matchingElements = this.matchingElements();
            if (matchingElements.isEmpty()) {
                this.cachedSelectedStack = this.getEmptyStack();
            } else {
                if (this.selectedOutput == this.getFallbackElement() || !matchingElements.contains(this.selectedOutput)) {
                    this.selectedOutput = (IForgeRegistryEntry)matchingElements.get(0);
                }
                this.cachedSelectedStack = this.createResultStack(this.selectedOutput);
            }
        }
        return this.cachedSelectedStack;
    }

    public final void next() {
        this.adjustSelected((index, size) -> {
            if (index < size - 1) {
                return index + 1;
            }
            return 0;
        });
    }

    public final void previous() {
        this.adjustSelected((index, size) -> {
            if (index == -1) {
                return 0;
            }
            if (index > 0) {
                return index - 1;
            }
            return size - 1;
        });
    }

    private List<TYPE> matchingElements() {
        return this.filterTag == null || !this.filterTag.isBound() ? Collections.emptyList() : this.filterTag.stream().toList();
    }

    private void adjustSelected(IntBinaryOperator calculateSelected) {
        List<TYPE> matchingElements = this.matchingElements();
        int size = matchingElements.size();
        if (size > 1) {
            int selected = this.selectedOutput == this.getFallbackElement() ? size - 1 : calculateSelected.applyAsInt(matchingElements.indexOf(this.selectedOutput), size);
            this.setSelectedOutput((IForgeRegistryEntry)matchingElements.get(selected));
        }
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.filterLocation);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return Objects.equals(this.filterLocation, ((OredictionificatorFilter)o).filterLocation);
    }

    public abstract TYPE getResultElement();

    protected abstract IForgeRegistry<TYPE> getRegistry();

    protected abstract ITagManager<TYPE> getTagManager();

    protected abstract TYPE getFallbackElement();

    protected abstract STACK getEmptyStack();

    protected abstract STACK createResultStack(TYPE var1);

    protected abstract CachedOredictionificatorConfigValue getValidValuesConfig();
}

