/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.qio;

import it.unimi.dsi.fastutil.objects.Object2LongMap;
import mekanism.common.content.qio.QIODriveData;
import mekanism.common.lib.inventory.HashedItem;
import mekanism.common.util.ItemDataUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public interface IQIODriveItem {
    default public boolean hasStoredItemMap(ItemStack stack) {
        return ItemDataUtils.hasData(stack, "qioItemMap", 9);
    }

    default public void loadItemMap(ItemStack stack, QIODriveData data) {
        if (this.hasStoredItemMap(stack)) {
            ListTag list = ItemDataUtils.getList(stack, "qioItemMap");
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag tag = list.m_128728_(i);
                ItemStack itemType = ItemStack.m_41712_((CompoundTag)tag.m_128469_("Item"));
                if (itemType.m_41619_()) continue;
                long count = tag.m_128454_("amount");
                data.getItemMap().put((Object)HashedItem.create(itemType), count);
            }
        }
    }

    default public void writeItemMap(ItemStack stack, QIODriveData map) {
        ListTag list = new ListTag();
        for (Object2LongMap.Entry entry : map.getItemMap().object2LongEntrySet()) {
            CompoundTag tag = new CompoundTag();
            tag.m_128365_("Item", (Tag)((HashedItem)entry.getKey()).getStack().m_41739_(new CompoundTag()));
            tag.m_128356_("amount", entry.getLongValue());
            list.add((Object)tag);
        }
        ItemDataUtils.setList(stack, "qioItemMap", list);
    }

    public long getCountCapacity(ItemStack var1);

    public int getTypeCapacity(ItemStack var1);

    public record DriveMetadata(long count, int types) {
        public void write(ItemStack stack) {
            ItemDataUtils.setLong(stack, "qioMetaCount", this.count);
            ItemDataUtils.setInt(stack, "qioMetaTypes", this.types);
        }

        public static DriveMetadata load(ItemStack stack) {
            return new DriveMetadata(ItemDataUtils.getLong(stack, "qioMetaCount"), ItemDataUtils.getInt(stack, "qioMetaTypes"));
        }
    }
}

